/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFileImpl;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefPackageImpl;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastContextKt;

public class RefJavaFileImpl
extends RefFileImpl {
    RefJavaFileImpl(PsiFile elem, RefManager manager) {
        super(elem, manager);
    }

    public void buildReferences() {
        PsiPackageStatement packageStatement;
        PsiFile file = this.getPsiElement();
        if (file != null && "package-info.java".equals(file.getName()) && (packageStatement = ((PsiJavaFile)file).getPackageStatement()) != null) {
            packageStatement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
                    if (reference == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitReferenceElement(reference);
                    this.processReference(reference.resolve());
                }

                public void visitNameValuePair(@NotNull PsiNameValuePair pair) {
                    if (pair == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.visitNameValuePair(pair);
                    PsiReference reference = pair.getReference();
                    if (reference != null) {
                        this.processReference(reference.resolve());
                    }
                }

                private void processReference(PsiElement element) {
                    RefElement refElement = RefJavaFileImpl.this.getRefManager().getReference(element);
                    if (refElement instanceof RefJavaElementImpl) {
                        RefJavaFileImpl.this.addOutReference(refElement);
                        ((RefJavaElementImpl)refElement).markReferenced((RefElementImpl)RefJavaFileImpl.this, false, true, null);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "reference";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "pair";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/codeInspection/reference/RefJavaFileImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitReferenceElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitNameValuePair";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    protected synchronized void initialize() {
        String packageName;
        PsiFile psiFile = this.getPsiElement();
        if (psiFile == null) {
            return;
        }
        UFile file = (UFile)UastContextKt.toUElement((PsiElement)psiFile, UFile.class);
        String string = packageName = file != null ? file.getPackageName() : null;
        if (!StringUtil.isEmpty((String)packageName)) {
            ((RefPackageImpl)((RefJavaManager)this.getRefManager().getExtension(RefJavaManager.MANAGER)).getPackage(packageName)).add((RefEntity)this);
        } else {
            RefModule module = this.getModule();
            if (module != null) {
                ((WritableRefEntity)module).add((RefEntity)this);
            } else {
                ((RefProjectImpl)this.getRefManager().getRefProject()).add((RefEntity)this);
            }
        }
    }
}

