/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UTypeReferenceExpression;

public final class RefParameterImpl
extends RefJavaElementImpl
implements RefParameter {
    private static final int USED_FOR_READING_MASK = 65536;
    private static final int USED_FOR_WRITING_MASK = 131072;
    private final short myIndex;
    private Object myActualValueTemplate;
    private short myUsageCount;

    RefParameterImpl(UParameter parameter, PsiElement psi, int index, RefManager manager, RefElement refElement) {
        super((UDeclaration)parameter, psi, manager);
        String name;
        this.myIndex = (short)index;
        this.myActualValueTemplate = VALUE_UNDEFINED;
        RefElementImpl owner = (RefElementImpl)refElement;
        if (owner != null) {
            owner.add((RefEntity)this);
        }
        if (psi.getLanguage().isKindOf("kotlin") && this.myIndex == 0 && ("$receiver".equals(name = this.getName()) || name.startsWith("$this$"))) {
            this.setUsedForReading();
        }
    }

    public void parameterReferenced(boolean forWriting) {
        if (forWriting) {
            this.setUsedForWriting();
        } else {
            this.setUsedForReading();
        }
    }

    public boolean isUsedForReading() {
        return this.checkFlag(65536L);
    }

    void setUsedForReading() {
        this.setFlag(true, 65536L);
    }

    public synchronized int getUsageCount() {
        return this.myUsageCount;
    }

    public boolean isUsedForWriting() {
        return this.checkFlag(131072L);
    }

    private void setUsedForWriting() {
        this.setFlag(true, 131072L);
    }

    public void accept(@NotNull RefVisitor visitor2) {
        if (visitor2 == null) {
            RefParameterImpl.$$$reportNull$$$0(0);
        }
        if (visitor2 instanceof RefJavaVisitor) {
            RefJavaVisitor javaVisitor = (RefJavaVisitor)visitor2;
            ReadAction.run(() -> javaVisitor.visitParameter((RefParameter)this));
        } else {
            super.accept(visitor2);
        }
    }

    public int getIndex() {
        return this.myIndex;
    }

    public void buildReferences() {
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        UParameter parameter = this.getUastElement();
        if (parameter != null) {
            List annotations = parameter.getUAnnotations();
            refUtil.addReferencesTo((UElement)parameter, (RefJavaElement)this, annotations.toArray(UElementKt.EMPTY_ARRAY));
            UTypeReferenceExpression typeReference = parameter.getTypeReference();
            refUtil.addReferencesTo((UElement)parameter, (RefJavaElement)this, new UElement[]{typeReference});
        }
    }

    synchronized void clearTemplateValue() {
        this.myActualValueTemplate = VALUE_IS_NOT_CONST;
    }

    synchronized void updateTemplateValue(@Nullable UExpression expression, @Nullable PsiElement accessPlace) {
        this.myUsageCount = (short)(this.myUsageCount + 1);
        if (this.myActualValueTemplate == VALUE_IS_NOT_CONST) {
            return;
        }
        Object newTemplate = RefParameterImpl.getAccessibleExpressionValue(expression, () -> accessPlace == null ? this.getContainingFile() : accessPlace);
        if (this.myActualValueTemplate == VALUE_UNDEFINED) {
            this.myActualValueTemplate = newTemplate;
        } else if (!Comparing.equal((Object)this.myActualValueTemplate, (Object)newTemplate)) {
            this.myActualValueTemplate = VALUE_IS_NOT_CONST;
        }
    }

    @Nullable
    public synchronized Object getActualConstValue() {
        return this.myActualValueTemplate;
    }

    protected void initialize() {
    }

    public String getExternalName() {
        return (String)ReadAction.compute(() -> {
            UParameter parameter = this.getUastElement();
            LOG.assertTrue(parameter != null);
            return PsiFormatUtil.getExternalName((PsiModifierListOwner)((PsiModifierListOwner)parameter.getJavaPsi()));
        });
    }

    public UParameter getUastElement() {
        WritableRefEntity writableRefEntity = this.getOwner();
        if (!(writableRefEntity instanceof RefMethod)) {
            return null;
        }
        RefMethod method = (RefMethod)writableRefEntity;
        UMethod uMethod = method.getUastElement();
        if (uMethod == null) {
            return null;
        }
        List parameters = uMethod.getUastParameters();
        if (parameters.size() <= this.getIndex()) {
            return null;
        }
        return (UParameter)parameters.get(this.getIndex());
    }

    @Nullable
    public static Object getAccessibleExpressionValue(@Nullable UExpression expression, @NotNull Supplier<? extends PsiElement> accessPlace) {
        PsiClassType type;
        PsiClass aClass;
        UReferenceExpression referenceExpression;
        UElement resolved;
        if (accessPlace == null) {
            RefParameterImpl.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            return VALUE_IS_NOT_CONST;
        }
        if (expression instanceof UExpressionList) {
            UExpressionList expressionList = (UExpressionList)expression;
            List exprValues = ContainerUtil.map((Collection)expressionList.getExpressions(), expr -> RefParameterImpl.getAccessibleExpressionValue(expr, accessPlace));
            return ContainerUtil.all((Collection)exprValues, value -> value == VALUE_IS_NOT_CONST) ? VALUE_IS_NOT_CONST : exprValues;
        }
        if (expression instanceof UReferenceExpression && (resolved = UResolvableKt.resolveToUElement((UResolvable)(referenceExpression = (UReferenceExpression)expression))) instanceof UField) {
            UField uField = (UField)resolved;
            PsiElement element = accessPlace.get();
            if (uField.isStatic() && uField.isFinal()) {
                PsiElement javaPsi;
                UClass uClass;
                if (element == null || !RefParameterImpl.isAccessible(uField, element)) {
                    return VALUE_IS_NOT_CONST;
                }
                UDeclaration containingClass = UDeclarationKt.getContainingDeclaration((UElement)uField);
                if (containingClass instanceof UClass && (uClass = (UClass)containingClass).getQualifiedName() != null && (javaPsi = uField.getJavaPsi()) != null) {
                    return new ConstValue(PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)javaPsi), (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY), PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)javaPsi), (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY));
                }
            }
        }
        if (expression instanceof ULiteralExpression) {
            ULiteralExpression literal = (ULiteralExpression)expression;
            Object value2 = literal.getValue();
            if (value2 == null) {
                return null;
            }
            PsiElement sourcePsi = Objects.requireNonNull(expression.getSourcePsi());
            return value2 instanceof String ? "\"" + StringUtil.unquoteString((String)sourcePsi.getText()) + "\"" : RefParameterImpl.convertToStringRepresentation(value2);
        }
        Object value3 = expression.evaluate();
        if (value3 instanceof PsiClassType && ((aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)(type = (PsiClassType)value3))) == null || PsiUtil.isLocalClass((PsiClass)aClass))) {
            return VALUE_IS_NOT_CONST;
        }
        return value3 == null ? VALUE_IS_NOT_CONST : RefParameterImpl.convertToStringRepresentation(value3);
    }

    @NotNull
    private static Object convertToStringRepresentation(@NotNull Object value) {
        if (value == null) {
            RefParameterImpl.$$$reportNull$$$0(2);
        }
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        Object object3 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Short.class, Byte.class, String.class, Character.class, PsiType.class}, (Object)object2, n)) {
            case 0 -> {
                Long aLong = (Long)object2;
                yield aLong + "L";
            }
            case 1 -> {
                Short aShort = (Short)object2;
                yield "(short)" + aShort;
            }
            case 2 -> {
                Byte aByte = (Byte)object2;
                yield "(byte)" + aByte;
            }
            case 3 -> {
                String string = (String)object2;
                yield "\"" + StringUtil.escapeStringCharacters((String)string) + "\"";
            }
            case 4 -> {
                Character character = (Character)object2;
                yield "'" + StringUtil.escapeCharCharacters((String)String.valueOf(character)) + "'";
            }
            case 5 -> {
                PsiType type = (PsiType)object2;
                yield new ConstValue(type.getCanonicalText() + ".class", type.getPresentableText() + ".class");
            }
            default -> value;
        };
        if (object3 == null) {
            RefParameterImpl.$$$reportNull$$$0(3);
        }
        return object3;
    }

    private static boolean isAccessible(@NotNull UField field, @NotNull PsiElement place) {
        UDeclaration fieldContainingClass;
        if (field == null) {
            RefParameterImpl.$$$reportNull$$$0(4);
        }
        if (place == null) {
            RefParameterImpl.$$$reportNull$$$0(5);
        }
        if (!((fieldContainingClass = UDeclarationKt.getContainingDeclaration((UElement)field)) instanceof UClass)) {
            return false;
        }
        UClass aClass = (UClass)fieldContainingClass;
        String qName = aClass.getQualifiedName();
        if (qName == null) {
            return false;
        }
        String fieldQName = qName + "." + field.getName();
        return PsiResolveHelper.getInstance((Project)place.getProject()).resolveReferencedVariable(fieldQName, place) != null;
    }

    @Nullable
    static RefElement parameterFromExternalName(RefManager manager, String fqName) {
        String method;
        RefJavaElement refMethod;
        int idx = fqName.lastIndexOf(32);
        if (idx > 0 && (refMethod = RefMethodImpl.methodFromExternalName(manager, method = fqName.substring(0, idx))) != null) {
            UElement uElement = refMethod.getUastElement();
            if (!(uElement instanceof UMethod)) {
                return null;
            }
            UMethod uMethod = (UMethod)uElement;
            int paramIdx = 0;
            String paramName = fqName.substring(idx + 1);
            for (UParameter parameter : uMethod.getUastParameters()) {
                if (paramName.equals(parameter.getName())) {
                    return ((RefJavaManager)manager.getExtension(RefJavaManager.MANAGER)).getParameterReference(parameter, paramIdx, (RefElement)refMethod);
                }
                ++paramIdx;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessPlace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefParameterImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefParameterImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToStringRepresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAccessibleExpressionValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertToStringRepresentation";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public record ConstValue(String canonicalText, String presentableText) {
        @Override
        public String toString() {
            return this.presentableText;
        }
    }
}

