/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.restriction;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationMethod;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public final class AnnotationContext {
    private static final AnnotationContext EMPTY = new AnnotationContext(null, null);
    @Nullable
    private final PsiModifierListOwner myOwner;
    @Nullable
    private final PsiType myType;
    @Nullable
    private final PsiElement myPlace;
    @Nullable
    private final Supplier<? extends Stream<PsiModifierListOwner>> myNext;

    private AnnotationContext(@Nullable PsiModifierListOwner owner, @Nullable PsiType type) {
        this(owner, type, null);
    }

    private AnnotationContext(@Nullable PsiModifierListOwner owner, @Nullable PsiType type, @Nullable Supplier<? extends Stream<PsiModifierListOwner>> next) {
        this(owner, type, next, null);
    }

    private AnnotationContext(@Nullable PsiModifierListOwner owner, @Nullable PsiType type, @Nullable Supplier<? extends Stream<PsiModifierListOwner>> next, @Nullable PsiElement place) {
        this.myOwner = owner;
        this.myType = type;
        this.myNext = next;
        this.myPlace = place;
    }

    private AnnotationContext withType(PsiType type) {
        return new AnnotationContext(this.myOwner, type, this.myNext);
    }

    private AnnotationContext withPlace(@Nullable PsiElement place) {
        return new AnnotationContext(this.myOwner, this.myType, this.myNext, place);
    }

    @Nullable
    public PsiModifierListOwner getOwner() {
        return this.myOwner;
    }

    @Nullable
    public PsiElement getPlace() {
        return this.myPlace;
    }

    @NotNull
    public Stream<PsiModifierListOwner> secondaryItems() {
        Stream<PsiModifierListOwner> stream = this.myNext == null ? Stream.empty() : this.myNext.get();
        if (stream == null) {
            AnnotationContext.$$$reportNull$$$0(0);
        }
        return stream;
    }

    @NotNull
    public Stream<PsiAnnotationOwner> allItems() {
        AbstractStreamEx abstractStreamEx = ((StreamEx)StreamEx.ofNullable((Object)this.myType).append((Stream)StreamEx.ofNullable(this.myOwner == null ? null : this.myOwner.getModifierList()))).append(this.secondaryItems().map(PsiModifierListOwner::getModifierList));
        if (abstractStreamEx == null) {
            AnnotationContext.$$$reportNull$$$0(1);
        }
        return abstractStreamEx;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationContext context = (AnnotationContext)o;
        return Objects.equals(this.myOwner, context.myOwner) && Objects.equals(this.myType, context.myType);
    }

    public int hashCode() {
        return Objects.hash(this.myOwner, this.myType);
    }

    @Nullable
    public PsiType getType() {
        return this.myType;
    }

    @NotNull
    public static AnnotationContext fromModifierListOwner(@Nullable PsiModifierListOwner owner) {
        if (owner instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)owner;
            return new AnnotationContext(owner, method.getReturnType(), () -> {
                HashSet visited = new HashSet();
                return StreamEx.ofNullable((Object)AnnotationContext.getKotlinProperty(owner)).append((Stream)StreamEx.ofTree((Object)method, m -> StreamEx.of((Object[])m.findSuperMethods()).filter(visited::add)).skip(1L));
            });
        }
        if (owner instanceof PsiParameter) {
            int index;
            PsiMethod method;
            PsiParameter parameter = (PsiParameter)owner;
            PsiParameterList parameterList = (PsiParameterList)ObjectUtils.tryCast((Object)parameter.getParent(), PsiParameterList.class);
            PsiMethod psiMethod = method = parameterList == null ? null : (PsiMethod)ObjectUtils.tryCast((Object)parameterList.getParent(), PsiMethod.class);
            if (parameterList != null && method != null && (index = parameterList.getParameterIndex(parameter)) >= 0) {
                Supplier<Stream> supplier = () -> {
                    HashSet visited = new HashSet();
                    return ((StreamEx)StreamEx.ofTree((Object)method, m -> StreamEx.of((Object[])m.findSuperMethods()).filter(visited::add)).skip(1L)).map(m -> m.getParameterList().getParameter(index)).select(PsiModifierListOwner.class);
                };
                return new AnnotationContext(owner, ((PsiVariable)owner).getType(), supplier);
            }
        }
        if (owner instanceof PsiVariable) {
            return new AnnotationContext(owner, ((PsiVariable)owner).getType());
        }
        AnnotationContext annotationContext = EMPTY;
        if (annotationContext == null) {
            AnnotationContext.$$$reportNull$$$0(2);
        }
        return annotationContext;
    }

    @NotNull
    public static AnnotationContext fromExpression(@NotNull UExpression expression) {
        AnnotationContext context;
        if (expression == null) {
            AnnotationContext.$$$reportNull$$$0(3);
        }
        if ((context = AnnotationContext.fromMethodReturn(expression)) != EMPTY) {
            AnnotationContext annotationContext = context;
            if (annotationContext == null) {
                AnnotationContext.$$$reportNull$$$0(4);
            }
            return annotationContext;
        }
        context = AnnotationContext.fromArgument(expression);
        if (context != EMPTY) {
            AnnotationContext annotationContext = context;
            if (annotationContext == null) {
                AnnotationContext.$$$reportNull$$$0(5);
            }
            return annotationContext;
        }
        context = AnnotationContext.fromInfixMethod(expression);
        if (context != EMPTY) {
            AnnotationContext annotationContext = context;
            if (annotationContext == null) {
                AnnotationContext.$$$reportNull$$$0(6);
            }
            return annotationContext;
        }
        return AnnotationContext.fromInitializer(expression);
    }

    @NotNull
    private static AnnotationContext fromMethodReturn(@NotNull UExpression expression) {
        AnnotationContext result;
        PsiMethod method;
        UAnnotation anno;
        if (expression == null) {
            AnnotationContext.$$$reportNull$$$0(7);
        }
        PsiType returnType = null;
        PsiParameter next = null;
        UElement parent = expression.getUastParent();
        if (parent instanceof UCallExpression && (anno = (UAnnotation)UastContextKt.toUElement((PsiElement)parent.getSourcePsi(), UAnnotation.class)) != null) {
            parent = anno;
        }
        if (parent instanceof UAnnotationMethod) {
            UExpression defaultValue = ((UAnnotationMethod)parent).getUastDefaultValue();
            if (defaultValue == null || !AnnotationContext.expressionsAreEquivalent(defaultValue, expression)) {
                AnnotationContext annotationContext = EMPTY;
                if (annotationContext == null) {
                    AnnotationContext.$$$reportNull$$$0(8);
                }
                return annotationContext;
            }
            method = ((UAnnotationMethod)parent).getPsi();
        } else if (parent instanceof UNamedExpression) {
            method = UastUtils.getAnnotationMethod((UNamedExpression)((UNamedExpression)parent));
        } else if (parent instanceof UAnnotation) {
            PsiClass psiClass = ((UAnnotation)parent).resolve();
            if (psiClass == null || !psiClass.isAnnotationType()) {
                AnnotationContext annotationContext = EMPTY;
                if (annotationContext == null) {
                    AnnotationContext.$$$reportNull$$$0(9);
                }
                return annotationContext;
            }
            method = (PsiMethod)ArrayUtil.getFirstElement((Object[])psiClass.findMethodsByName("value", false));
        } else {
            UElement jumpTarget = null;
            if (parent instanceof UReturnExpression) {
                jumpTarget = ((UReturnExpression)parent).getJumpTarget();
            } else if (parent instanceof ULambdaExpression && expression instanceof UBlockExpression) {
                jumpTarget = parent;
            }
            if (jumpTarget instanceof UMethod) {
                method = ((UMethod)jumpTarget).getJavaPsi();
            } else if (jumpTarget instanceof ULambdaExpression) {
                next = AnnotationContext.getFunctionalParameter((ULambdaExpression)jumpTarget);
                PsiType type = ((ULambdaExpression)jumpTarget).getFunctionalInterfaceType();
                if (type == null) {
                    return AnnotationContext.fromModifierListOwner((PsiModifierListOwner)next);
                }
                returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)type);
                method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)type);
            } else {
                AnnotationContext annotationContext = EMPTY;
                if (annotationContext == null) {
                    AnnotationContext.$$$reportNull$$$0(10);
                }
                return annotationContext;
            }
        }
        if (method == null) {
            AnnotationContext annotationContext = EMPTY;
            if (annotationContext == null) {
                AnnotationContext.$$$reportNull$$$0(11);
            }
            return annotationContext;
        }
        AnnotationContext annotationContext = result = returnType == null ? AnnotationContext.fromModifierListOwner((PsiModifierListOwner)method) : AnnotationContext.fromModifierListOwner((PsiModifierListOwner)method).withType(returnType);
        if (next != null) {
            PsiParameter finalNext = next;
            return new AnnotationContext(result.myOwner, result.myType, () -> AnnotationContext.lambda$fromMethodReturn$5((PsiModifierListOwner)finalNext, result));
        }
        AnnotationContext annotationContext2 = result;
        if (annotationContext2 == null) {
            AnnotationContext.$$$reportNull$$$0(12);
        }
        return annotationContext2;
    }

    @Nullable
    private static PsiModifierListOwner getKotlinProperty(@NotNull PsiModifierListOwner owner) {
        PsiElement javaPsi;
        boolean maybeSetter;
        if (owner == null) {
            AnnotationContext.$$$reportNull$$$0(13);
        }
        if (!(owner instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)owner;
        if (!owner.getClass().getSimpleName().equals("KtUltraLightMethodForSourceDeclaration")) {
            return null;
        }
        String name = method.getName();
        boolean maybeGetter = (name.startsWith("get") || name.startsWith("is")) && method.getParameterList().isEmpty();
        boolean bl = maybeSetter = name.startsWith("set") && method.getParameterList().getParametersCount() == 1;
        if (!maybeGetter && !maybeSetter) {
            return null;
        }
        UElement element = UastContextKt.toUElement((PsiElement)owner.getNavigationElement());
        if (element instanceof UField && (javaPsi = element.getJavaPsi()) instanceof PsiField) {
            return (PsiField)javaPsi;
        }
        return null;
    }

    @Nullable
    private static PsiParameter getFunctionalParameter(ULambdaExpression function) {
        UCallExpression call = (UCallExpression)ObjectUtils.tryCast((Object)function.getUastParent(), UCallExpression.class);
        if (call != null) {
            return AnnotationContext.getParameter(call, (UExpression)function);
        }
        return null;
    }

    @NotNull
    private static AnnotationContext fromArgument(@NotNull UExpression expression) {
        UElement parent;
        UCallExpression callExpression;
        if (expression == null) {
            AnnotationContext.$$$reportNull$$$0(14);
        }
        if ((callExpression = UastUtils.getUCallExpression((UElement)(parent = expression.getUastParent()), (int)1)) == null) {
            AnnotationContext annotationContext = EMPTY;
            if (annotationContext == null) {
                AnnotationContext.$$$reportNull$$$0(15);
            }
            return annotationContext;
        }
        PsiParameter parameter = AnnotationContext.getParameter(callExpression, expression);
        if (parameter == null) {
            AnnotationContext annotationContext = EMPTY;
            if (annotationContext == null) {
                AnnotationContext.$$$reportNull$$$0(16);
            }
            return annotationContext;
        }
        PsiType parameterType = parameter.getType();
        PsiElement psi = callExpression.getSourcePsi();
        if (psi instanceof PsiMethodCallExpression) {
            PsiSubstitutor substitutor = ((PsiMethodCallExpression)psi).getMethodExpression().advancedResolve(false).getSubstitutor();
            parameterType = substitutor.substitute(parameterType);
        }
        AnnotationContext annotationContext = AnnotationContext.fromModifierListOwner((PsiModifierListOwner)parameter).withType(parameterType).withPlace(callExpression.getSourcePsi());
        if (annotationContext == null) {
            AnnotationContext.$$$reportNull$$$0(17);
        }
        return annotationContext;
    }

    @NotNull
    private static AnnotationContext fromInfixMethod(@NotNull UExpression expression) {
        PsiParameter parameter;
        UBinaryExpression parent;
        PsiMethod method;
        if (expression == null) {
            AnnotationContext.$$$reportNull$$$0(18);
        }
        PsiMethod psiMethod = method = (parent = (UBinaryExpression)ObjectUtils.tryCast((Object)expression.getUastParent(), UBinaryExpression.class)) != null ? parent.resolveOperator() : null;
        if (method == null) {
            AnnotationContext annotationContext = EMPTY;
            if (annotationContext == null) {
                AnnotationContext.$$$reportNull$$$0(19);
            }
            return annotationContext;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != 2) {
            AnnotationContext annotationContext = EMPTY;
            if (annotationContext == null) {
                AnnotationContext.$$$reportNull$$$0(20);
            }
            return annotationContext;
        }
        PsiParameter psiParameter = parameter = UastUtils.isPsiAncestor((UElement)expression, (UElement)parent.getRightOperand()) ? parameters[1] : parameters[0];
        if (parameter == null) {
            AnnotationContext annotationContext = EMPTY;
            if (annotationContext == null) {
                AnnotationContext.$$$reportNull$$$0(21);
            }
            return annotationContext;
        }
        PsiType parameterType = parameter.getType();
        AnnotationContext annotationContext = AnnotationContext.fromModifierListOwner((PsiModifierListOwner)parameter).withType(parameterType);
        if (annotationContext == null) {
            AnnotationContext.$$$reportNull$$$0(22);
        }
        return annotationContext;
    }

    @NotNull
    private static AnnotationContext fromInitializer(UExpression expression) {
        UExpression selector;
        USwitchExpression switchExpression;
        USwitchClauseExpression switchClause;
        List caseValues;
        UElement parent = expression.getUastParent();
        PsiModifierListOwner var = null;
        if (parent instanceof UVariable) {
            var = (PsiModifierListOwner)ObjectUtils.tryCast((Object)parent.getJavaPsi(), PsiModifierListOwner.class);
        } else if (parent instanceof UBinaryExpression) {
            UBinaryExpression binOp = (UBinaryExpression)parent;
            UastBinaryOperator operator = binOp.getOperator();
            UExpression rightOperand = binOp.getRightOperand();
            if ((operator == UastBinaryOperator.ASSIGN || operator == UastBinaryOperator.PLUS_ASSIGN) && AnnotationContext.expressionsAreEquivalent(expression, rightOperand)) {
                PsiParameter[] parameters;
                UExpression leftOperand = UastUtils.skipParenthesizedExprDown((UExpression)binOp.getLeftOperand());
                UReferenceExpression lValue = (UReferenceExpression)ObjectUtils.tryCast((Object)leftOperand, UReferenceExpression.class);
                if (lValue instanceof UQualifiedReferenceExpression) {
                    lValue = (UReferenceExpression)ObjectUtils.tryCast((Object)((UQualifiedReferenceExpression)lValue).getSelector(), UReferenceExpression.class);
                }
                if (lValue != null) {
                    var = (PsiModifierListOwner)ObjectUtils.tryCast((Object)lValue.resolve(), PsiModifierListOwner.class);
                } else {
                    while (leftOperand instanceof UArrayAccessExpression) {
                        leftOperand = ((UArrayAccessExpression)leftOperand).getReceiver();
                    }
                    if (leftOperand instanceof UResolvable) {
                        var = (PsiModifierListOwner)ObjectUtils.tryCast((Object)((UResolvable)leftOperand).resolve(), PsiModifierListOwner.class);
                    }
                }
                if (var != null && var.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && var instanceof PsiMethod && PsiTypes.voidType().equals((Object)((PsiMethod)var).getReturnType()) && (parameters = ((PsiMethod)var).getParameterList().getParameters()).length == 1) {
                    var = parameters[0];
                }
            }
        } else if (parent instanceof USwitchClauseExpression && (caseValues = ContainerUtil.map((Collection)(switchClause = (USwitchClauseExpression)parent).getCaseValues(), caseValue -> AnnotationContext.normalize(caseValue))).contains(AnnotationContext.normalize(expression)) && (switchExpression = (USwitchExpression)UastUtils.getParentOfType((UElement)parent, USwitchExpression.class)) != null && (selector = switchExpression.getExpression()) instanceof UResolvable) {
            var = (PsiModifierListOwner)ObjectUtils.tryCast((Object)((UResolvable)selector).resolve(), PsiModifierListOwner.class);
        }
        return AnnotationContext.fromModifierListOwner(var);
    }

    public static boolean expressionsAreEquivalent(@NotNull UExpression expr1, @NotNull UExpression expr2) {
        if (expr1 == null) {
            AnnotationContext.$$$reportNull$$$0(23);
        }
        if (expr2 == null) {
            AnnotationContext.$$$reportNull$$$0(24);
        }
        return AnnotationContext.normalize(expr1).equals((Object)AnnotationContext.normalize(expr2));
    }

    @NotNull
    static UExpression normalize(@NotNull UExpression expression) {
        List operands;
        if (expression == null) {
            AnnotationContext.$$$reportNull$$$0(25);
        }
        if (expression instanceof UPolyadicExpression && ((UPolyadicExpression)expression).getOperator() == UastBinaryOperator.PLUS && (operands = ((UPolyadicExpression)expression).getOperands()).size() == 1) {
            UExpression uExpression = (UExpression)operands.get(0);
            if (uExpression == null) {
                AnnotationContext.$$$reportNull$$$0(26);
            }
            return uExpression;
        }
        UExpression uExpression = expression;
        if (uExpression == null) {
            AnnotationContext.$$$reportNull$$$0(27);
        }
        return uExpression;
    }

    @Nullable
    public static PsiParameter getParameter(@NotNull UCallExpression call, @NotNull UExpression expr) {
        UExpression arg;
        if (call == null) {
            AnnotationContext.$$$reportNull$$$0(28);
        }
        if (expr == null) {
            AnnotationContext.$$$reportNull$$$0(29);
        }
        if ((arg = AnnotationContext.getValueArgumentParent(call, expr)) == null) {
            return null;
        }
        return UastUtils.getParameterForArgument((UCallExpression)call, (UExpression)arg);
    }

    @Nullable
    private static UExpression getValueArgumentParent(@NotNull UCallExpression call, @NotNull UExpression arg) {
        UElement parent;
        if (call == null) {
            AnnotationContext.$$$reportNull$$$0(30);
        }
        if (arg == null) {
            AnnotationContext.$$$reportNull$$$0(31);
        }
        while (!call.equals((Object)(parent = arg.getUastParent()))) {
            if (!(parent instanceof UExpression)) {
                return null;
            }
            arg = (UExpression)parent;
        }
        return arg;
    }

    private static /* synthetic */ Stream lambda$fromMethodReturn$5(PsiModifierListOwner finalNext, AnnotationContext result) {
        return StreamEx.of((Object)finalNext).append(result.secondaryItems());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 7, 13, 14, 18, 23, 24, 25, 28, 29, 30, 31 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/restriction/AnnotationContext";
                break;
            }
            case 3: 
            case 7: 
            case 14: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr1";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr2";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "secondaryItems";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "allItems";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fromModifierListOwner";
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/restriction/AnnotationContext";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fromExpression";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMethodReturn";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "fromArgument";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "fromInfixMethod";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromMethodReturn";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getKotlinProperty";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fromArgument";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fromInfixMethod";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "expressionsAreEquivalent";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getValueArgumentParent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 7, 13, 14, 18, 23, 24, 25, 28, 29, 30, 31 -> new IllegalArgumentException(string);
        };
    }
}

