/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unnecessaryModuleDependency;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;

public class UnnecessaryModuleDependencyAnnotator
extends RefGraphAnnotator {
    public static final Key<Set<Module>> DEPENDENCIES = Key.create((String)"inspection.dependencies");
    private final RefManager myManager;

    public UnnecessaryModuleDependencyAnnotator(RefManager manager) {
        this.myManager = manager;
    }

    public void onMarkReferenced(PsiElement what, PsiElement from, boolean referencedFromClassInitializer) {
        if (what != null && from != null) {
            RefModule refModule;
            Module fromModule = ModuleUtilCore.findModuleForFile((PsiFile)from.getContainingFile());
            Set<Module> onModules = UnnecessaryModuleDependencyAnnotator.getAllPossibleWhatModules(what);
            if (onModules != null && fromModule != null && (refModule = this.myManager.getRefModule(fromModule)) != null) {
                HashSet<Module> modules = new HashSet<Module>(onModules);
                UnnecessaryModuleDependencyAnnotator.collectRequiredModulesInHierarchy(this.myManager.getReference(what), modules);
                modules.remove(fromModule);
                UnnecessaryModuleDependencyAnnotator.getModules(refModule).addAll(modules);
            }
        }
    }

    public void onMarkReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer) {
        RefModule fromModule = refFrom.getModule();
        RefModule whatModule = refWhat.getModule();
        if (fromModule != null && whatModule != null) {
            Set<Module> currentFromModules = UnnecessaryModuleDependencyAnnotator.getModules(fromModule);
            currentFromModules.add(whatModule.getModule());
            Set modules = (Set)refWhat.getUserData(DEPENDENCIES);
            if (modules != null) {
                currentFromModules.addAll(modules);
            }
        }
    }

    public void onInitialize(RefElement refElement) {
        RefModule refModule = refElement.getModule();
        if (refModule != null) {
            Set modules = Collections.synchronizedSet(new HashSet());
            UnnecessaryModuleDependencyAnnotator.collectRequiredModulesInHierarchy(refElement, modules);
            modules.remove(refModule.getModule());
            if (!modules.isEmpty()) {
                refElement.putUserData(DEPENDENCIES, modules);
                UnnecessaryModuleDependencyAnnotator.getModules(refModule).addAll(modules);
            }
        }
    }

    private static void collectRequiredModulesInHierarchy(RefElement refElement, Set<? super Module> modules) {
        UField element;
        UClass aClass;
        if (refElement instanceof RefClass) {
            UnnecessaryModuleDependencyAnnotator.processClassHierarchy(null, (RefClass)refElement, modules);
        } else if (refElement instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refElement;
            UMethod uMethod = refMethod.getUastElement();
            if (uMethod != null) {
                HashSet classes = new HashSet();
                UnnecessaryModuleDependencyAnnotator.processTypeHierarchy(classes, uMethod.getReturnType(), modules);
                for (UParameter parameter : uMethod.getUastParameters()) {
                    UnnecessaryModuleDependencyAnnotator.processTypeHierarchy(classes, parameter.getType(), modules);
                }
            }
        } else if (refElement instanceof RefField && (aClass = (UClass)UastContextKt.toUElement((PsiElement)PsiUtil.resolveClassInType((PsiType)(element = ((RefField)refElement).getUastElement()).getType()), UClass.class)) != null) {
            UnnecessaryModuleDependencyAnnotator.processClassHierarchy(aClass, null, modules);
        }
    }

    private static void processTypeHierarchy(Set<? super PsiClass> classes, PsiType returnType, Set<? super Module> modules) {
        UClass aClass = (UClass)UastContextKt.toUElement((PsiElement)PsiUtil.resolveClassInType((PsiType)returnType), UClass.class);
        if (aClass != null && classes.add((PsiClass)aClass)) {
            UnnecessaryModuleDependencyAnnotator.processClassHierarchy(aClass, null, modules);
        }
    }

    private static void processClassHierarchy(UClass uClass, RefClass refClass, Set<? super Module> modules) {
        LinkedHashSet<UClass> superClasses = new LinkedHashSet<UClass>();
        if (refClass == null) {
            UnnecessaryModuleDependencyAnnotator.processSupers(uClass, superClasses);
        } else {
            for (RefClass refClass2 : refClass.getBaseClasses()) {
                UClass superClass = refClass2.getUastElement();
                if (superClass == null) continue;
                superClasses.add(superClass);
            }
        }
        for (PsiClass psiClass : superClasses) {
            Set<Module> onModules = UnnecessaryModuleDependencyAnnotator.getAllPossibleWhatModules((PsiElement)psiClass);
            if (onModules == null) continue;
            modules.addAll(onModules);
        }
    }

    private static void processSupers(UClass uClass, LinkedHashSet<UClass> superClasses) {
        for (UTypeReferenceExpression uastSuperType : uClass.getUastSuperTypes()) {
            UClass aClass;
            PsiClass superClass = PsiUtil.resolveClassInType((PsiType)uastSuperType.getType());
            if (superClass == null || !superClass.getManager().isInProject((PsiElement)superClass) || (aClass = (UClass)UastContextKt.toUElement((PsiElement)superClass, UClass.class)) == null || !superClasses.add(aClass)) continue;
            UnnecessaryModuleDependencyAnnotator.processSupers(aClass, superClasses);
        }
    }

    private static Set<Module> getAllPossibleWhatModules(@NotNull PsiElement what) {
        VirtualFile vFile;
        if (what == null) {
            UnnecessaryModuleDependencyAnnotator.$$$reportNull$$$0(0);
        }
        if ((vFile = PsiUtilCore.getVirtualFile((PsiElement)what)) == null) {
            return null;
        }
        Project project = what.getProject();
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        if (fileIndex.isInLibrary(vFile)) {
            List orderEntries = fileIndex.getOrderEntriesForFile(vFile);
            if (orderEntries.isEmpty()) {
                return null;
            }
            HashSet<Module> modules = new HashSet<Module>(orderEntries.size());
            for (OrderEntry orderEntry : orderEntries) {
                if (orderEntry instanceof JdkOrderEntry) {
                    return null;
                }
                modules.add(orderEntry.getOwnerModule());
            }
            return modules;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)project);
        return module != null ? Collections.singleton(module) : null;
    }

    private static synchronized Set<Module> getModules(RefModule refModule) {
        Set modules = (Set)refModule.getUserData(DEPENDENCIES);
        if (modules == null) {
            modules = Collections.synchronizedSet(new HashSet());
            refModule.putUserData(DEPENDENCIES, modules);
        }
        return modules;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyAnnotator", "getAllPossibleWhatModules"));
    }
}

