/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unneededThrows;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.UnhandledExceptions;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefFunctionalExpression;
import com.intellij.codeInspection.reference.RefGraphAnnotatorEx;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class RedundantThrowsGraphAnnotator
extends RefGraphAnnotatorEx {
    private final RefManager myRefManager;

    public RedundantThrowsGraphAnnotator(RefManager refManager) {
        this.myRefManager = refManager;
    }

    public void onInitialize(RefElement refElement) {
        if (refElement instanceof RefMethodImpl) {
            RefMethodImpl methodImpl = (RefMethodImpl)refElement;
            PsiElement psiElement = refElement.getPsiElement();
            if (psiElement instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)psiElement;
                PsiCodeBlock body = method.getBody();
                if (body == null) {
                    return;
                }
                UnhandledExceptions exceptions = UnhandledExceptions.ofMethod((PsiMethod)method);
                if (exceptions.hasUnresolvedCalls()) {
                    PsiClassType throwableType = JavaPsiFacade.getElementFactory((Project)method.getProject()).createTypeByFQClassName("java.lang.Throwable", method.getResolveScope());
                    methodImpl.updateThrowsList(throwableType);
                }
                Set exceptionTypes = exceptions.exceptions();
                for (PsiClassType exceptionType : exceptionTypes) {
                    methodImpl.updateThrowsList(exceptionType);
                }
            }
        } else if (refElement instanceof RefFunctionalExpression) {
            PsiElement expression = refElement.getPsiElement();
            List exceptionTypes = null;
            PsiMethod method = null;
            if (expression instanceof PsiLambdaExpression) {
                PsiElement body = ((PsiLambdaExpression)expression).getBody();
                exceptionTypes = body != null ? ExceptionUtil.collectUnhandledExceptions((PsiElement)body, (PsiElement)expression, (boolean)false) : Collections.emptyList();
                method = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)expression);
            } else if (expression instanceof PsiMethodReferenceExpression) {
                PsiMethod resolved = (PsiMethod)ObjectUtils.tryCast((Object)((PsiMethodReferenceExpression)expression).resolve(), PsiMethod.class);
                if (resolved != null) {
                    PsiClassType[] types = resolved.getThrowsList().getReferencedTypes();
                    exceptionTypes = types.length == 0 ? Collections.emptyList() : Arrays.asList(types);
                }
                method = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)expression);
            }
            if (method == null || exceptionTypes == null) {
                return;
            }
            RefElement refMethod = this.myRefManager.getReference((PsiElement)method);
            if (refMethod == null) {
                return;
            }
            List finalExceptionTypes = exceptionTypes;
            this.myRefManager.executeTask(() -> {
                refMethod.initializeIfNeeded();
                for (PsiClassType exceptionType : finalExceptionTypes) {
                    ((RefMethodImpl)refMethod).updateThrowsList(exceptionType);
                }
            });
        }
    }
}

