/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedSymbol;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.GlobalUsageHelper;
import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.LocalRefUseInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceWithUnnamedPatternFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.intention.impl.PriorityIntentionActionWrapper;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixBackedByIntentionAction;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.options.OptDropdown;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.reference.UnusedDeclarationFixProvider;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.SpecialAnnotationsUtilBase;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDeconstructionList;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.AccessModifier;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.SerializationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.intellij.lang.annotations.Language;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.annotations.TestOnly;

public final class UnusedSymbolLocalInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "unused";
    @NonNls
    public static final String UNUSED_PARAMETERS_SHORT_NAME = "UnusedParameters";
    @NonNls
    public static final String UNUSED_ID = "unused";
    public boolean LOCAL_VARIABLE = true;
    public boolean FIELD = true;
    public boolean METHOD = true;
    public boolean CLASS = true;
    private boolean INNER_CLASS = true;
    public boolean PARAMETER = true;
    public boolean REPORT_PARAMETER_FOR_PUBLIC_METHODS = true;
    private String myClassVisibility = "public";
    private String myInnerClassVisibility = "public";
    private String myFieldVisibility = "public";
    private String myMethodVisibility = "public";
    private String myParameterVisibility = "public";
    private boolean myIgnoreAccessors = false;
    private boolean myCheckParameterExcludingHierarchy = false;

    public boolean runForWholeFile() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnusedSymbolLocalInspection.$$$reportNull$$$0(0);
        }
        final PsiFile file = holder.getFile();
        final LocalRefUseInfo info = LocalRefUseInfo.forFile(file);
        final Project project = holder.getProject();
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        UnusedDeclarationInspectionBase deadCodeInspection = (UnusedDeclarationInspectionBase)((Object)ObjectUtils.tryCast((Object)profile.getUnwrappedTool("unused", (PsiElement)file), UnusedDeclarationInspectionBase.class));
        final GlobalUsageHelper helper = info.getGlobalUsageHelper(file, deadCodeInspection);
        return new JavaElementVisitor(){
            private final QuickFixFactory fixFactory = QuickFixFactory.getInstance();
            private final Map<PsiMethod, Boolean> isOverriddenOrOverrides = ConcurrentFactoryMap.createMap(method -> {
                boolean overrides = SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst() != null;
                return overrides || OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null;
            });

            private boolean isOverriddenOrOverrides(@NotNull PsiMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                return this.isOverriddenOrOverrides.get(method);
            }

            private static boolean compareVisibilities(PsiModifierListOwner listOwner, String visibility) {
                if (visibility != null) {
                    while (listOwner != null) {
                        if (VisibilityUtil.compare((String)VisibilityUtil.getVisibilityModifier((PsiModifierList)listOwner.getModifierList()), (String)visibility) >= 0) {
                            return true;
                        }
                        listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)listOwner, PsiModifierListOwner.class, (boolean)true);
                    }
                }
                return false;
            }

            private void registerProblem(@NotNull PsiElement element, @NotNull @InspectionMessage String message, @NotNull List<? extends IntentionAction> fixes) {
                PsiNameIdentifierOwner owner;
                PsiElement identifier;
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (fixes == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (element instanceof SyntheticElement) {
                    return;
                }
                if (element instanceof PsiNameIdentifierOwner && (identifier = (owner = (PsiNameIdentifierOwner)element).getNameIdentifier()) != null) {
                    element = identifier;
                }
                for (UnusedDeclarationFixProvider provider : UnusedDeclarationFixProvider.EP_NAME.getExtensionList()) {
                    Object[] additionalFixes = provider.getQuickFixes(element);
                    fixes = ContainerUtil.append(fixes, (Object[])additionalFixes);
                }
                holder.registerProblem(element, message, (LocalQuickFix[])ContainerUtil.map2Array(fixes, (Object[])LocalQuickFix.EMPTY_ARRAY, UnusedSymbolLocalInspection::toLocalQuickFix));
            }

            public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
                if (variable == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (!UnusedSymbolLocalInspection.this.LOCAL_VARIABLE) {
                    return;
                }
                if (variable.isUnnamed() || PsiUtil.isIgnoredName((String)variable.getName())) {
                    return;
                }
                if (UnusedSymbolUtil.isImplicitUsage(project, (PsiModifierListOwner)variable)) {
                    return;
                }
                if (!info.isReferenced((PsiElement)variable)) {
                    IntentionAction fix = variable instanceof PsiResourceVariable ? this.fixFactory.createRenameToIgnoredFix((PsiVariable)variable, false) : QuickFixFactory.getInstance().createRemoveUnusedVariableFix((PsiVariable)variable);
                    this.registerProblem((PsiElement)variable, JavaErrorBundle.message("local.variable.is.never.used", variable.getName()), List.of(fix));
                } else if (!info.isReferencedForRead((PsiVariable)variable) && !UnusedSymbolUtil.isImplicitRead(project, (PsiVariable)variable)) {
                    this.registerProblem((PsiElement)variable, JavaErrorBundle.message("local.variable.is.not.used.for.reading", variable.getName()), List.of(QuickFixFactory.getInstance().createRemoveUnusedVariableFix((PsiVariable)variable)));
                } else if (!(variable.hasInitializer() || info.isReferencedForWrite((PsiVariable)variable) || UnusedSymbolUtil.isImplicitWrite(project, (PsiVariable)variable))) {
                    this.registerProblem((PsiElement)variable, JavaErrorBundle.message("local.variable.is.not.assigned", variable.getName()), List.of(this.fixFactory.createAddVariableInitializerFix((PsiVariable)variable)));
                }
            }

            public void visitField(@NotNull PsiField field) {
                if (field == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (!1.compareVisibilities((PsiModifierListOwner)field, UnusedSymbolLocalInspection.this.getFieldVisibility())) {
                    return;
                }
                if (SerializationUtils.isSerializationImplicitlyUsedField(field)) {
                    return;
                }
                if (field.hasModifierProperty("private")) {
                    if (!info.isReferenced((PsiElement)field) && !UnusedSymbolUtil.isImplicitUsage(project, (PsiModifierListOwner)field)) {
                        ArrayList<IntentionAction> fixes = new ArrayList<IntentionAction>(this.suggestionsToMakeFieldUsed(field));
                        if (!field.hasInitializer() && !field.hasModifierProperty("final")) {
                            fixes.add(this.fixFactory.createCreateConstructorParameterFromFieldFix(field));
                        }
                        this.registerProblem((PsiElement)field, JavaErrorBundle.message("private.field.is.not.used", field.getName()), fixes);
                        return;
                    }
                    boolean readReferenced = info.isReferencedForRead((PsiVariable)field);
                    if (!readReferenced && !UnusedSymbolUtil.isImplicitRead(project, (PsiVariable)field)) {
                        this.registerProblem((PsiElement)field, 1.getNotUsedForReadingMessage(field), this.suggestionsToMakeFieldUsed(field));
                        return;
                    }
                    if (field.hasInitializer()) {
                        return;
                    }
                    boolean writeReferenced = info.isReferencedForWrite((PsiVariable)field);
                    if (!writeReferenced && !UnusedSymbolUtil.isImplicitWrite(project, (PsiVariable)field)) {
                        ArrayList<IntentionAction> fixes = new ArrayList<IntentionAction>();
                        fixes.add(this.fixFactory.createCreateGetterOrSetterFix(false, true, field));
                        if (!field.hasModifierProperty("final")) {
                            fixes.add(this.fixFactory.createCreateConstructorParameterFromFieldFix(field));
                        }
                        SpecialAnnotationsUtilBase.processUnknownAnnotations((PsiModifierListOwner)field, (Processor<? super String>)((Processor)annoName -> fixes.add(this.fixFactory.createAddToImplicitlyWrittenFieldsFix(project, annoName))));
                        this.registerProblem((PsiElement)field, JavaErrorBundle.message("private.field.is.not.assigned", field.getName()), fixes);
                    }
                } else if (!UnusedSymbolUtil.isFieldUsed(project, file, field, helper)) {
                    if (UnusedSymbolUtil.isImplicitWrite(project, (PsiVariable)field) && !UnusedSymbolUtil.isImplicitRead(project, (PsiVariable)field)) {
                        this.registerProblem((PsiElement)field, 1.getNotUsedForReadingMessage(field), List.of(this.fixFactory.createSafeDeleteFix((PsiElement)field)));
                    } else if (!UnusedSymbolUtil.isImplicitUsage(project, (PsiModifierListOwner)field)) {
                        this.formatUnusedSymbolHighlightInfo("field.is.not.used", (PsiMember)field);
                    }
                }
            }

            private void formatUnusedSymbolHighlightInfo(@NotNull @PropertyKey(resourceBundle="messages.JavaErrorBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaErrorBundle") String pattern, @NotNull PsiMember member) {
                if (pattern == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (member == null) {
                    1.$$$reportNull$$$0(7);
                }
                ArrayList<IntentionAction> fixes = new ArrayList<IntentionAction>();
                fixes.add(QuickFixFactory.getInstance().createSafeDeleteFix((PsiElement)member));
                SpecialAnnotationsUtilBase.processUnknownAnnotations((PsiModifierListOwner)member, (Processor<? super String>)((Processor)annoName -> fixes.add(QuickFixFactory.getInstance().createAddToDependencyInjectionAnnotationsFix(project, annoName))));
                this.registerProblem((PsiElement)member, JavaErrorBundle.message(pattern, member.getName()), fixes);
            }

            private static boolean isUsedMainOrPremainMethod(@NotNull PsiMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (!PsiClassImplUtil.isMainOrPremainMethod((PsiMethod)method)) {
                    return false;
                }
                if (!"main".equals(method.getName())) {
                    return true;
                }
                return !PsiUtil.isAvailable((JavaFeature)JavaFeature.IMPLICIT_CLASSES, (PsiElement)method);
            }

            public void visitMethod(@NotNull PsiMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (UnusedSymbolLocalInspection.this.isIgnoreAccessors() && PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)method)) {
                    return;
                }
                if (!1.compareVisibilities((PsiModifierListOwner)method, UnusedSymbolLocalInspection.this.getMethodVisibility())) {
                    return;
                }
                if (UnusedSymbolUtil.isMethodUsed(project, file, method, helper)) {
                    return;
                }
                @PropertyKey(resourceBundle="messages.JavaErrorBundle") String key = method.hasModifierProperty("private") ? (method.isConstructor() ? "private.constructor.is.not.used" : "private.method.is.not.used") : (method.isConstructor() ? "constructor.is.not.used" : "method.is.not.used");
                int options = 8194;
                String symbolName = HighlightMessageUtil.getSymbolName((PsiElement)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options);
                QuickFixFactory factory = QuickFixFactory.getInstance();
                ArrayList<IntentionAction> fixes = new ArrayList<IntentionAction>();
                fixes.add(factory.createSafeDeleteFix((PsiElement)method));
                if (ApplicationManager.getApplication().isHeadlessEnvironment() && method.hasModifierProperty("private")) {
                    fixes.add(factory.createDeletePrivateMethodFix(method).asIntention());
                }
                SpecialAnnotationsUtilBase.processUnknownAnnotations((PsiModifierListOwner)method, (Processor<? super String>)((Processor)annoName -> fixes.add(factory.createAddToDependencyInjectionAnnotationsFix(project, annoName))));
                this.registerProblem((PsiElement)method, JavaErrorBundle.message(key, symbolName), fixes);
            }

            public void visitParameter(@NotNull PsiParameter parameter) {
                String message;
                boolean needToProcessParameter;
                PsiElement declarationScope;
                if (parameter == null) {
                    1.$$$reportNull$$$0(10);
                }
                if ((declarationScope = parameter.getDeclarationScope()) instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)declarationScope;
                    needToProcessParameter = 1.compareVisibilities((PsiModifierListOwner)method, UnusedSymbolLocalInspection.this.getParameterVisibility());
                } else {
                    needToProcessParameter = declarationScope instanceof PsiLambdaExpression ? 1.compareVisibilities((PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)declarationScope, PsiModifierListOwner.class), UnusedSymbolLocalInspection.this.getParameterVisibility()) : UnusedSymbolLocalInspection.this.LOCAL_VARIABLE;
                }
                if (!needToProcessParameter) {
                    return;
                }
                if (parameter.isUnnamed() || PsiUtil.isIgnoredName((String)parameter.getName())) {
                    return;
                }
                QuickFixFactory quickFixFactory = QuickFixFactory.getInstance();
                if (declarationScope instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)declarationScope;
                    if (PsiUtilCore.hasErrorElementChild((PsiElement)method)) {
                        return;
                    }
                    if (!(!method.isConstructor() && !method.hasModifierProperty("private") && !method.hasModifierProperty("static") && (method.hasModifierProperty("abstract") || this.isOverriddenOrOverrides(method) && !UnusedSymbolLocalInspection.this.shouldCheckParameterExcludingHierarchy()) || method.hasModifierProperty("native") || JavaHighlightUtil.isSerializationRelatedMethod(method, method.getContainingClass()) || 1.isUsedMainOrPremainMethod(method))) {
                        if (UnusedSymbolUtil.isInjected(project, (PsiModifierListOwner)method)) {
                            return;
                        }
                        String message2 = this.checkUnusedParameter(parameter);
                        if (message2 != null) {
                            this.registerProblem((PsiElement)parameter, message2, ContainerUtil.append(1.getFixesForUnusedParameter(method, parameter), (Object[])new IntentionAction[]{quickFixFactory.createRenameToIgnoredFix((PsiVariable)parameter, true), PriorityIntentionActionWrapper.highPriority((IntentionAction)quickFixFactory.createSafeDeleteUnusedParameterInHierarchyFix(parameter, UnusedSymbolLocalInspection.this.shouldCheckParameterExcludingHierarchy() && this.isOverriddenOrOverrides(method)))}));
                        }
                    }
                } else if (declarationScope instanceof PsiForeachStatement) {
                    String message3 = this.checkUnusedParameter(parameter);
                    if (message3 != null) {
                        this.registerProblem((PsiElement)parameter, message3, List.of(quickFixFactory.createRenameToIgnoredFix((PsiVariable)parameter, false)));
                    }
                } else if (parameter instanceof PsiPatternVariable) {
                    PsiPatternVariable variable = (PsiPatternVariable)parameter;
                    String message4 = this.checkUnusedParameter(parameter);
                    if (message4 != null) {
                        PsiPattern pattern = variable.getPattern();
                        LocalQuickFixAndIntentionActionOnPsiElement action = null;
                        if (PsiUtil.isAvailable((JavaFeature)JavaFeature.UNNAMED_PATTERNS_AND_VARIABLES, (PsiElement)parameter) && pattern instanceof PsiTypeTestPattern) {
                            PsiTypeTestPattern ttPattern = (PsiTypeTestPattern)pattern;
                            if (pattern.getParent() instanceof PsiDeconstructionList) {
                                PsiRecordComponent component = JavaPsiPatternUtil.getRecordComponentForPattern((PsiPattern)pattern);
                                PsiTypeElement checkType = ttPattern.getCheckType();
                                if (component != null && checkType != null && checkType.getType().isAssignableFrom(component.getType())) {
                                    action = new ReplaceWithUnnamedPatternFix(pattern).asIntention();
                                }
                            }
                        }
                        if (action == null && declarationScope.getParent() instanceof PsiSwitchBlock) {
                            action = variable.getParent() instanceof PsiDeconstructionPattern ? quickFixFactory.createDeleteFix((PsiElement)parameter) : quickFixFactory.createRenameToIgnoredFix((PsiVariable)parameter, false);
                        } else if (!(pattern instanceof PsiTypeTestPattern) || !(pattern.getParent() instanceof PsiDeconstructionList)) {
                            action = quickFixFactory.createDeleteFix((PsiElement)parameter);
                        }
                        this.registerProblem((PsiElement)parameter, message4, ContainerUtil.createMaybeSingletonList((Object)action));
                    }
                } else if ((UnusedSymbolLocalInspection.this.shouldCheckParameterExcludingHierarchy() || PsiUtil.isAvailable((JavaFeature)JavaFeature.UNNAMED_PATTERNS_AND_VARIABLES, (PsiElement)declarationScope)) && declarationScope instanceof PsiLambdaExpression && (message = this.checkUnusedParameter(parameter)) != null) {
                    this.registerProblem((PsiElement)parameter, message, List.of(quickFixFactory.createRenameToIgnoredFix((PsiVariable)parameter, true), PriorityIntentionActionWrapper.lowPriority((IntentionAction)quickFixFactory.createSafeDeleteUnusedParameterInHierarchyFix(parameter, true))));
                }
            }

            @Nullable
            @InspectionMessage
            private String checkUnusedParameter(@NotNull PsiParameter parameter) {
                if (parameter == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (!info.isReferenced((PsiElement)parameter) && !UnusedSymbolUtil.isImplicitUsage(project, (PsiModifierListOwner)parameter)) {
                    return JavaErrorBundle.message(parameter instanceof PsiPatternVariable ? "pattern.variable.is.not.used" : "parameter.is.not.used", parameter.getName());
                }
                return null;
            }

            @NotNull
            private static List<IntentionAction> getFixesForUnusedParameter(@NotNull PsiMethod declarationMethod, @NotNull PsiParameter parameter) {
                if (declarationMethod == null) {
                    1.$$$reportNull$$$0(12);
                }
                if (parameter == null) {
                    1.$$$reportNull$$$0(13);
                }
                IntentionAction assignFix = QuickFixFactory.getInstance().createAssignFieldFromParameterFix(parameter);
                IntentionAction createFieldFix = QuickFixFactory.getInstance().createCreateFieldFromParameterFix(parameter);
                if (!declarationMethod.isConstructor()) {
                    assignFix = PriorityIntentionActionWrapper.lowPriority((IntentionAction)assignFix);
                    createFieldFix = PriorityIntentionActionWrapper.lowPriority((IntentionAction)createFieldFix);
                }
                List<IntentionAction> list = List.of(assignFix, createFieldFix);
                if (list == null) {
                    1.$$$reportNull$$$0(14);
                }
                return list;
            }

            public void visitClass(@NotNull PsiClass aClass) {
                String acceptedVisibility;
                if (aClass == null) {
                    1.$$$reportNull$$$0(15);
                }
                if (aClass instanceof PsiImplicitClass) {
                    return;
                }
                String string = acceptedVisibility = aClass.getContainingClass() == null ? UnusedSymbolLocalInspection.this.getClassVisibility() : UnusedSymbolLocalInspection.this.getInnerClassVisibility();
                if (!1.compareVisibilities((PsiModifierListOwner)aClass, acceptedVisibility)) {
                    return;
                }
                if (UnusedSymbolUtil.isClassUsed(project, file, aClass, helper)) {
                    return;
                }
                @PropertyKey(resourceBundle="messages.JavaErrorBundle") String pattern = aClass.getContainingClass() != null && aClass.hasModifierProperty("private") ? (aClass.isInterface() ? "private.inner.interface.is.not.used" : "private.inner.class.is.not.used") : (aClass.getParent() instanceof PsiDeclarationStatement ? "local.class.is.not.used" : (aClass instanceof PsiTypeParameter ? "type.parameter.is.not.used" : (aClass.isAnnotationType() ? "annotation.interface.is.not.used" : (aClass.isInterface() ? "interface.is.not.used" : (aClass.isEnum() ? "enum.is.not.used" : (aClass.isRecord() ? "record.is.not.used" : "class.is.not.used"))))));
                this.formatUnusedSymbolHighlightInfo(pattern, (PsiMember)aClass);
            }

            @NlsContexts.DetailedDescription
            @NotNull
            private static String getNotUsedForReadingMessage(@NotNull PsiField field) {
                if (field == null) {
                    1.$$$reportNull$$$0(16);
                }
                String visibility = VisibilityUtil.getVisibilityStringToDisplay((PsiMember)field);
                String message = JavaErrorBundle.message("field.is.not.used.for.reading", visibility, field.getName());
                String string = StringUtil.capitalize((String)message);
                if (string == null) {
                    1.$$$reportNull$$$0(17);
                }
                return string;
            }

            private List<IntentionAction> suggestionsToMakeFieldUsed(@NotNull PsiField field) {
                if (field == null) {
                    1.$$$reportNull$$$0(18);
                }
                ArrayList<IntentionAction> quickFixes = new ArrayList<IntentionAction>();
                SpecialAnnotationsUtilBase.processUnknownAnnotations((PsiModifierListOwner)field, (Processor<? super String>)((Processor)annoName -> quickFixes.add(EntryPointsManagerBase.createAddEntryPointAnnotation(annoName).asIntention())));
                quickFixes.add(QuickFixFactory.getInstance().createRemoveUnusedVariableFix((PsiVariable)field));
                quickFixes.add(this.fixFactory.createCreateGetterOrSetterFix(true, false, field));
                quickFixes.add(this.fixFactory.createCreateGetterOrSetterFix(false, true, field));
                quickFixes.add(this.fixFactory.createCreateGetterOrSetterFix(true, true, field));
                return quickFixes;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 14, 17 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fixes";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                    case 5: 
                    case 16: 
                    case 18: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pattern";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "member";
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameter";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "declarationMethod";
                        break;
                    }
                    case 14: 
                    case 17: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/unusedSymbol/UnusedSymbolLocalInspection$1";
                        break;
                    }
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/unusedSymbol/UnusedSymbolLocalInspection$1";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFixesForUnusedParameter";
                        break;
                    }
                    case 17: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNotUsedForReadingMessage";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isOverriddenOrOverrides";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "registerProblem";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "visitLocalVariable";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "visitField";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "formatUnusedSymbolHighlightInfo";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "isUsedMainOrPremainMethod";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "visitMethod";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "visitParameter";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "checkUnusedParameter";
                        break;
                    }
                    case 12: 
                    case 13: {
                        objectArray = objectArray;
                        objectArray[2] = "getFixesForUnusedParameter";
                        break;
                    }
                    case 14: 
                    case 17: {
                        break;
                    }
                    case 15: {
                        objectArray = objectArray;
                        objectArray[2] = "visitClass";
                        break;
                    }
                    case 16: {
                        objectArray = objectArray;
                        objectArray[2] = "getNotUsedForReadingMessage";
                        break;
                    }
                    case 18: {
                        objectArray = objectArray;
                        objectArray[2] = "suggestionsToMakeFieldUsed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 14, 17 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    private static LocalQuickFix toLocalQuickFix(IntentionAction fix) {
        ModCommandAction action = fix.asModCommandAction();
        OrderedLocalQuickFixBackedByIntentionAction orderedLocalQuickFixBackedByIntentionAction = action == null ? new OrderedLocalQuickFixBackedByIntentionAction(fix) : LocalQuickFix.from((ModCommandAction)action);
        if (orderedLocalQuickFixBackedByIntentionAction == null) {
            UnusedSymbolLocalInspection.$$$reportNull$$$0(1);
        }
        return orderedLocalQuickFixBackedByIntentionAction;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"CLASS", (String)JavaBundle.message((String)"inspection.unused.symbol.check.classes", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{UnusedSymbolLocalInspection.modifierSelector("myClassVisibility")}), OptPane.checkbox((String)"INNER_CLASS", (String)JavaBundle.message((String)"inspection.unused.symbol.check.inner.classes", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{UnusedSymbolLocalInspection.modifierSelector("myInnerClassVisibility")}), OptPane.checkbox((String)"FIELD", (String)JavaBundle.message((String)"inspection.unused.symbol.check.fields", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{UnusedSymbolLocalInspection.modifierSelector("myFieldVisibility")}), OptPane.checkbox((String)"METHOD", (String)JavaBundle.message((String)"inspection.unused.symbol.check.methods", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{UnusedSymbolLocalInspection.modifierSelector("myMethodVisibility"), OptPane.checkbox((String)"myIgnoreAccessors", (String)JavaBundle.message((String)"inspection.unused.symbol.check.accessors", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])}), OptPane.checkbox((String)"PARAMETER", (String)JavaBundle.message((String)"inspection.unused.symbol.check.parameters", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{UnusedSymbolLocalInspection.modifierSelector("myParameterVisibility"), OptPane.checkbox((String)"myCheckParameterExcludingHierarchy", (String)JavaBundle.message((String)"inspection.unused.symbol.check.parameters.excluding.hierarchy", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])}), OptPane.checkbox((String)"LOCAL_VARIABLE", (String)JavaBundle.message((String)"inspection.unused.symbol.check.localvars", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnusedSymbolLocalInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    private static OptDropdown modifierSelector(@Language(value="jvm-field-name") @NotNull String bindId) {
        if (bindId == null) {
            UnusedSymbolLocalInspection.$$$reportNull$$$0(3);
        }
        return OptPane.dropdown((String)bindId, (String)"", List.of(AccessModifier.values()), AccessModifier::toPsiModifier, AccessModifier::toString);
    }

    @PsiModifier.ModifierConstant
    @Nullable
    public String getClassVisibility() {
        if (!this.CLASS) {
            return null;
        }
        return this.myClassVisibility;
    }

    @PsiModifier.ModifierConstant
    @Nullable
    public String getFieldVisibility() {
        if (!this.FIELD) {
            return null;
        }
        return this.myFieldVisibility;
    }

    @PsiModifier.ModifierConstant
    @Nullable
    public String getMethodVisibility() {
        if (!this.METHOD) {
            return null;
        }
        return this.myMethodVisibility;
    }

    @PsiModifier.ModifierConstant
    @Nullable
    public String getParameterVisibility() {
        if (!this.PARAMETER) {
            return null;
        }
        return this.myParameterVisibility;
    }

    private boolean shouldCheckParameterExcludingHierarchy() {
        return this.myCheckParameterExcludingHierarchy;
    }

    @PsiModifier.ModifierConstant
    @Nullable
    public String getInnerClassVisibility() {
        if (!this.INNER_CLASS) {
            return null;
        }
        return this.myInnerClassVisibility;
    }

    @TestOnly
    public void setClassVisibility(String classVisibility) {
        this.myClassVisibility = classVisibility;
    }

    @TestOnly
    public void setParameterVisibility(String parameterVisibility) {
        this.REPORT_PARAMETER_FOR_PUBLIC_METHODS = "public".equals(parameterVisibility);
        this.myParameterVisibility = parameterVisibility;
    }

    @TestOnly
    public void setCheckParameterExcludingHierarchy(boolean checkParameterExcludingHierarchy) {
        this.myCheckParameterExcludingHierarchy = checkParameterExcludingHierarchy;
    }

    public boolean isIgnoreAccessors() {
        return this.myIgnoreAccessors;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.declaration.redundancy", (Object[])new Object[0]);
        if (string == null) {
            UnusedSymbolLocalInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "unused";
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    @NonNls
    public String getID() {
        return "unused";
    }

    public String getAlternativeID() {
        return "UnusedDeclaration";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            UnusedSymbolLocalInspection.$$$reportNull$$$0(5);
        }
        UnusedSymbolLocalInspection.writeVisibility(node, this.myClassVisibility, "klass");
        UnusedSymbolLocalInspection.writeVisibility(node, this.myInnerClassVisibility, "inner_class");
        UnusedSymbolLocalInspection.writeVisibility(node, this.myFieldVisibility, "field");
        UnusedSymbolLocalInspection.writeVisibility(node, this.myMethodVisibility, "method");
        UnusedSymbolLocalInspection.writeVisibility(node, "parameter", this.myParameterVisibility, this.getParameterDefaultVisibility());
        if (this.myIgnoreAccessors) {
            node.setAttribute("ignoreAccessors", Boolean.toString(true));
        }
        if (!this.INNER_CLASS) {
            node.setAttribute("INNER_CLASS", Boolean.toString(false));
        }
        node.setAttribute("checkParameterExcludingHierarchy", Boolean.toString(this.myCheckParameterExcludingHierarchy));
        super.writeSettings(node);
    }

    private static void writeVisibility(Element node, String visibility, String type) {
        UnusedSymbolLocalInspection.writeVisibility(node, type, visibility, "public");
    }

    private static void writeVisibility(Element node, String type, String visibility, String defaultVisibility) {
        if (!defaultVisibility.equals(visibility)) {
            node.setAttribute(type, visibility);
        }
    }

    private String getParameterDefaultVisibility() {
        return this.REPORT_PARAMETER_FOR_PUBLIC_METHODS ? "public" : "private";
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            UnusedSymbolLocalInspection.$$$reportNull$$$0(6);
        }
        super.readSettings(node);
        this.myClassVisibility = UnusedSymbolLocalInspection.readVisibility(node, "klass");
        this.myInnerClassVisibility = UnusedSymbolLocalInspection.readVisibility(node, "inner_class");
        this.myFieldVisibility = UnusedSymbolLocalInspection.readVisibility(node, "field");
        this.myMethodVisibility = UnusedSymbolLocalInspection.readVisibility(node, "method");
        this.myParameterVisibility = UnusedSymbolLocalInspection.readVisibility(node, "parameter", this.getParameterDefaultVisibility());
        String ignoreAccessors = node.getAttributeValue("ignoreAccessors");
        this.myIgnoreAccessors = Boolean.parseBoolean(ignoreAccessors);
        String innerClassEnabled = node.getAttributeValue("INNER_CLASS");
        this.INNER_CLASS = innerClassEnabled == null || Boolean.parseBoolean(innerClassEnabled);
        String checkParameterExcludingHierarchy = node.getAttributeValue("checkParameterExcludingHierarchy");
        this.myCheckParameterExcludingHierarchy = Boolean.parseBoolean(checkParameterExcludingHierarchy);
    }

    private static String readVisibility(@NotNull Element node, String type) {
        if (node == null) {
            UnusedSymbolLocalInspection.$$$reportNull$$$0(7);
        }
        return UnusedSymbolLocalInspection.readVisibility(node, type, "public");
    }

    private static String readVisibility(@NotNull Element node, String type, String defaultVisibility) {
        String visibility;
        if (node == null) {
            UnusedSymbolLocalInspection.$$$reportNull$$$0(8);
        }
        if ((visibility = node.getAttributeValue(type)) == null) {
            return defaultVisibility;
        }
        return visibility;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/unusedSymbol/UnusedSymbolLocalInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindId";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/unusedSymbol/UnusedSymbolLocalInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toLocalQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "modifierSelector";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readVisibility";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4 -> new IllegalStateException(string);
        };
    }

    private static class OrderedLocalQuickFixBackedByIntentionAction
    extends LocalQuickFixBackedByIntentionAction
    implements PriorityAction {
        @NotNull
        private final PriorityAction.Priority myPriority;

        private OrderedLocalQuickFixBackedByIntentionAction(@NotNull IntentionAction action) {
            PriorityAction.Priority priority;
            if (action == null) {
                OrderedLocalQuickFixBackedByIntentionAction.$$$reportNull$$$0(0);
            }
            super(action);
            if (action instanceof PriorityAction) {
                PriorityAction priorityAction = (PriorityAction)action;
                priority = priorityAction.getPriority();
            } else {
                priority = PriorityAction.Priority.NORMAL;
            }
            this.myPriority = priority;
        }

        @NotNull
        public PriorityAction.Priority getPriority() {
            PriorityAction.Priority priority = this.myPriority;
            if (priority == null) {
                OrderedLocalQuickFixBackedByIntentionAction.$$$reportNull$$$0(1);
            }
            return priority;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/unusedSymbol/UnusedSymbolLocalInspection$OrderedLocalQuickFixBackedByIntentionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/unusedSymbol/UnusedSymbolLocalInspection$OrderedLocalQuickFixBackedByIntentionAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

