/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LambdaGenerationUtil {
    @Contract(value="null -> false")
    public static boolean canBeUncheckedLambda(@Nullable PsiElement lambdaCandidate) {
        return LambdaGenerationUtil.canBeUncheckedLambda(lambdaCandidate, var -> false);
    }

    @Contract(value="null, _ -> false")
    public static boolean canBeUncheckedLambda(@Nullable PsiElement lambdaCandidate, @NotNull Predicate<? super PsiVariable> variableAllowedPredicate) {
        if (variableAllowedPredicate == null) {
            LambdaGenerationUtil.$$$reportNull$$$0(0);
        }
        if (!(lambdaCandidate instanceof PsiExpression) && !(lambdaCandidate instanceof PsiStatement)) {
            return false;
        }
        if (!ExceptionUtil.getThrownCheckedExceptions((PsiElement[])new PsiElement[]{lambdaCandidate}).isEmpty()) {
            return false;
        }
        CanBeLambdaBodyVisitor visitor2 = new CanBeLambdaBodyVisitor(lambdaCandidate, variableAllowedPredicate);
        lambdaCandidate.accept((PsiElementVisitor)visitor2);
        return visitor2.canBeLambdaBody();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableAllowedPredicate", "com/intellij/codeInspection/util/LambdaGenerationUtil", "canBeUncheckedLambda"));
    }

    private static class CanBeLambdaBodyVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myCanBeLambdaBody = true;
        private final PsiElement myRoot;
        private final Predicate<? super PsiVariable> myVariableAllowedPredicate;

        CanBeLambdaBodyVisitor(PsiElement root, Predicate<? super PsiVariable> variableAllowedPredicate) {
            this.myRoot = root;
            this.myVariableAllowedPredicate = variableAllowedPredicate;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                CanBeLambdaBodyVisitor.$$$reportNull$$$0(0);
            }
            if (!this.myCanBeLambdaBody) {
                return;
            }
            super.visitElement(element);
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                CanBeLambdaBodyVisitor.$$$reportNull$$$0(1);
            }
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
            if (expression == null) {
                CanBeLambdaBodyVisitor.$$$reportNull$$$0(2);
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                CanBeLambdaBodyVisitor.$$$reportNull$$$0(3);
            }
            if (!this.myCanBeLambdaBody) {
                return;
            }
            super.visitReferenceExpression(expression);
            PsiElement element = expression.resolve();
            if (element instanceof PsiVariable && !this.isAllowedInLambda(expression, (PsiVariable)element)) {
                this.myCanBeLambdaBody = false;
            }
        }

        private boolean isAllowedInLambda(PsiReferenceExpression expression, PsiVariable variable) {
            if (this.myVariableAllowedPredicate.test((PsiVariable)variable)) {
                return true;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)this.myRoot, (PsiElement)variable, (boolean)true)) {
                return true;
            }
            if (variable instanceof PsiField) {
                return !variable.hasModifierProperty("final") || !PsiUtil.isAccessedForWriting((PsiExpression)expression);
            }
            return !PsiUtil.isAccessedForWriting((PsiExpression)expression) && ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)this.myRoot);
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
            PsiStatement exitedStatement;
            if (statement == null) {
                CanBeLambdaBodyVisitor.$$$reportNull$$$0(4);
            }
            if ((exitedStatement = statement.findExitedStatement()) == null || !PsiTreeUtil.isAncestor((PsiElement)this.myRoot, (PsiElement)exitedStatement, (boolean)false)) {
                this.myCanBeLambdaBody = false;
            }
            super.visitBreakStatement(statement);
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
            PsiStatement continuedStatement;
            if (statement == null) {
                CanBeLambdaBodyVisitor.$$$reportNull$$$0(5);
            }
            if ((continuedStatement = statement.findContinuedStatement()) == null || !PsiTreeUtil.isAncestor((PsiElement)this.myRoot, (PsiElement)continuedStatement, (boolean)false)) {
                this.myCanBeLambdaBody = false;
            }
            super.visitContinueStatement(statement);
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                CanBeLambdaBodyVisitor.$$$reportNull$$$0(6);
            }
            this.myCanBeLambdaBody = false;
        }

        public boolean canBeLambdaBody() {
            return this.myCanBeLambdaBody;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/util/LambdaGenerationUtil$CanBeLambdaBodyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLambdaExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBreakStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitContinueStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReturnStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

