/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.wrongPackageStatement;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.SingleFileSourcesTracker;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class AdjustPackageNameFix
extends ModCommandQuickFix {
    private final String myName;

    public AdjustPackageNameFix(String targetPackage) {
        this.myName = targetPackage;
    }

    @NotNull
    public String getName() {
        String string = QuickFixBundle.message("adjust.package.text", this.myName);
        if (string == null) {
            AdjustPackageNameFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("adjust.package.family", new Object[0]);
        if (string == null) {
            AdjustPackageNameFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public final ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        PsiFile origFile;
        PsiDirectory directory;
        if (project == null) {
            AdjustPackageNameFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            AdjustPackageNameFix.$$$reportNull$$$0(3);
        }
        if ((directory = (origFile = (element = descriptor.getStartElement()).getContainingFile()).getContainingDirectory()) == null) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                AdjustPackageNameFix.$$$reportNull$$$0(4);
            }
            return modCommand;
        }
        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)element, (e, updater) -> AdjustPackageNameFix.applyFix(e, origFile, directory));
        if (modCommand == null) {
            AdjustPackageNameFix.$$$reportNull$$$0(5);
        }
        return modCommand;
    }

    public static void applyFix(@NotNull PsiElement element, @NotNull PsiFile origFile, @NotNull PsiDirectory directory) {
        if (element == null) {
            AdjustPackageNameFix.$$$reportNull$$$0(6);
        }
        if (origFile == null) {
            AdjustPackageNameFix.$$$reportNull$$$0(7);
        }
        if (directory == null) {
            AdjustPackageNameFix.$$$reportNull$$$0(8);
        }
        PsiFile file = element.getContainingFile();
        PsiPackage myTargetPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (myTargetPackage == null) {
            return;
        }
        String myTargetPackageName = myTargetPackage.getQualifiedName();
        SingleFileSourcesTracker singleFileSourcesTracker = SingleFileSourcesTracker.getInstance((Project)file.getProject());
        String singleFileSourcePackageName = singleFileSourcesTracker.getPackageNameForSingleFileSource(origFile.getVirtualFile());
        if (singleFileSourcePackageName != null) {
            myTargetPackageName = singleFileSourcePackageName;
        }
        PsiPackageStatement statement = ((PsiJavaFile)file).getPackageStatement();
        if (myTargetPackageName.isEmpty()) {
            if (statement != null) {
                statement.delete();
            }
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)file.getProject());
            PsiPackageStatement packageStatement = factory.createPackageStatement(myTargetPackageName);
            if (statement != null) {
                new CommentTracker().replaceAndRestoreComments((PsiElement)statement.getPackageReference(), (PsiElement)packageStatement.getPackageReference());
            } else {
                file.addAfter((PsiElement)packageStatement, null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/wrongPackageStatement/AdjustPackageNameFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/wrongPackageStatement/AdjustPackageNameFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

