/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.analysis.impl.bytecode;

import com.intellij.java.analysis.bytecode.JvmBytecodeDeclarationProcessor;
import com.intellij.java.analysis.bytecode.JvmBytecodeReferenceProcessor;
import com.intellij.java.analysis.bytecode.JvmClassBytecodeDeclaration;
import com.intellij.java.analysis.bytecode.JvmFieldBytecodeDeclaration;
import com.intellij.java.analysis.bytecode.JvmMethodBytecodeDeclaration;
import com.intellij.java.analysis.impl.bytecode.ClassAncestorResolver;
import com.intellij.java.analysis.impl.bytecode.JvmClassBytecodeDeclarationImpl;
import com.intellij.java.analysis.impl.bytecode.JvmFieldBytecodeDeclarationImpl;
import com.intellij.java.analysis.impl.bytecode.JvmMethodBytecodeDeclarationImpl;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.signature.SignatureReader;
import org.jetbrains.org.objectweb.asm.signature.SignatureVisitor;

final class ClassFileAnalysisVisitor
extends ClassVisitor {
    private static final Label LABEL = new Label();
    private final AnnotationDependencyVisitor myAnnotationVisitor = new AnnotationDependencyVisitor();
    private final DependencySignatureVisitor mySignatureVisitor = new DependencySignatureVisitor();
    private final DependencyFieldVisitor myFieldVisitor = new DependencyFieldVisitor();
    @Nullable
    private final JvmBytecodeDeclarationProcessor myDeclarationProcessor;
    @Nullable
    private final JvmBytecodeReferenceProcessor myReferenceProcessor;
    @Nullable
    private final ClassAncestorResolver myImplicitAncestorReferencesResolver;
    private JvmClassBytecodeDeclaration myCurrentClass;
    private final Map<String, JvmClassBytecodeDeclaration> myClassDeclarations = new HashMap<String, JvmClassBytecodeDeclaration>();

    ClassFileAnalysisVisitor(@Nullable JvmBytecodeDeclarationProcessor declarationProcessor, @Nullable JvmBytecodeReferenceProcessor referenceProcessor, @Nullable ClassAncestorResolver implicitAncestorReferencesResolver) {
        super(589824);
        this.myDeclarationProcessor = declarationProcessor;
        this.myReferenceProcessor = referenceProcessor;
        this.myImplicitAncestorReferencesResolver = implicitAncestorReferencesResolver;
    }

    void processFileContent(byte @NotNull [] classFileContent) {
        if (classFileContent == null) {
            ClassFileAnalysisVisitor.$$$reportNull$$$0(0);
        }
        ClassReader cr = new ClassReader(this, classFileContent){

            protected Label readLabel(int offset, Label[] labels) {
                if (offset >= labels.length) {
                    return LABEL;
                }
                return super.readLabel(offset, labels);
            }
        };
        cr.accept((ClassVisitor)this, 4);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myCurrentClass = this.getOrCreateClassDeclaration(name);
        if (this.myDeclarationProcessor != null) {
            this.myDeclarationProcessor.processClass(this.myCurrentClass);
        }
        if (signature == null) {
            this.addName(superName);
            this.addNames(interfaces);
        } else {
            this.addSignature(signature);
        }
        this.processImplicitSuperclassReferences(this.myCurrentClass);
    }

    private void processImplicitSuperclassReferences(JvmClassBytecodeDeclaration referencedClass) {
        if (this.myReferenceProcessor != null && this.myImplicitAncestorReferencesResolver != null) {
            for (String superclass : this.myImplicitAncestorReferencesResolver.getAllAncestors(referencedClass.getBinaryClassName())) {
                this.myReferenceProcessor.processClassReference(this.getOrCreateClassDeclaration(superclass), this.myCurrentClass);
            }
        }
    }

    @NotNull
    private JvmClassBytecodeDeclaration getOrCreateClassDeclaration(@NotNull String name) {
        if (name == null) {
            ClassFileAnalysisVisitor.$$$reportNull$$$0(1);
        }
        JvmClassBytecodeDeclaration jvmClassBytecodeDeclaration = this.myClassDeclarations.computeIfAbsent(name, JvmClassBytecodeDeclarationImpl::new);
        if (jvmClassBytecodeDeclaration == null) {
            ClassFileAnalysisVisitor.$$$reportNull$$$0(2);
        }
        return jvmClassBytecodeDeclaration;
    }

    private void processMethodReference(JvmClassBytecodeDeclaration targetClass, String methodName, String methodDescriptor) {
        if (this.myReferenceProcessor != null && targetClass != null && !targetClass.equals((Object)this.myCurrentClass)) {
            this.myReferenceProcessor.processMethodReference((JvmMethodBytecodeDeclaration)new JvmMethodBytecodeDeclarationImpl(targetClass, methodName, methodDescriptor), this.myCurrentClass);
        }
    }

    private void processFieldReference(JvmClassBytecodeDeclaration targetClass, String fieldName, String fieldDescriptor) {
        if (this.myReferenceProcessor != null && targetClass != null && !targetClass.equals((Object)this.myCurrentClass)) {
            this.myReferenceProcessor.processFieldReference((JvmFieldBytecodeDeclaration)new JvmFieldBytecodeDeclarationImpl(targetClass, fieldName, fieldDescriptor), this.myCurrentClass);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.addDesc(desc);
        return this.myAnnotationVisitor;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.addDesc(desc);
        return this.myAnnotationVisitor;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.myDeclarationProcessor != null) {
            this.myDeclarationProcessor.processField((JvmFieldBytecodeDeclaration)new JvmFieldBytecodeDeclarationImpl(this.myCurrentClass, name, desc));
        }
        if (signature == null) {
            this.addDesc(desc);
        } else {
            this.addTypeSignature(signature);
        }
        if (value instanceof Type) {
            this.addType((Type)value);
        }
        return this.myFieldVisitor;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.myDeclarationProcessor != null) {
            this.myDeclarationProcessor.processMethod((JvmMethodBytecodeDeclaration)new JvmMethodBytecodeDeclarationImpl(this.myCurrentClass, name, desc));
        }
        if ((access & 0x1000) == 0) {
            if (signature == null) {
                this.addMethodDesc(desc);
            } else {
                this.addSignature(signature);
            }
            this.addNames(exceptions);
        }
        if ((access & 0x400) != 0) {
            return null;
        }
        return new DependencyMethodVisitor();
    }

    private JvmClassBytecodeDeclaration addName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        JvmClassBytecodeDeclaration declaration = this.getOrCreateClassDeclaration(name);
        if (this.myReferenceProcessor != null && !declaration.equals((Object)this.myCurrentClass)) {
            this.myReferenceProcessor.processClassReference(declaration, this.myCurrentClass);
        }
        return declaration;
    }

    private void addNames(String[] names) {
        for (int i = 0; names != null && i < names.length; ++i) {
            this.addName(names[i]);
        }
    }

    private void addDesc(String desc) {
        this.addType(Type.getType((String)desc));
    }

    private void addHandle(Handle h) {
        JvmClassBytecodeDeclaration targetClass = this.addName(h.getOwner());
        int tag = h.getTag();
        String desc = h.getDesc();
        if (tag == 5 || tag == 6 || tag == 7 || tag == 8 || tag == 9) {
            this.addMethodDesc(desc);
            this.processMethodReference(targetClass, h.getName(), desc);
        } else if (tag == 1 || tag == 3 || tag == 2 || tag == 4) {
            this.processFieldReference(targetClass, h.getName(), desc);
            this.addDesc(desc);
        } else {
            this.addDesc(desc);
        }
    }

    private void addMethodDesc(String desc) {
        Type[] types;
        this.addType(Type.getReturnType((String)desc));
        for (Type type : types = Type.getArgumentTypes((String)desc)) {
            this.addType(type);
        }
    }

    private void addType(Type t) {
        switch (t.getSort()) {
            case 9: {
                this.addType(t.getElementType());
                break;
            }
            case 10: {
                this.addName(t.getClassName().replace('.', '/'));
                break;
            }
            case 11: {
                this.addMethodDesc(t.getDescriptor());
            }
        }
    }

    private void addSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).accept((SignatureVisitor)this.mySignatureVisitor);
        }
    }

    private void addTypeSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).acceptType((SignatureVisitor)this.mySignatureVisitor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFileContent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/analysis/impl/bytecode/ClassFileAnalysisVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/analysis/impl/bytecode/ClassFileAnalysisVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateClassDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processFileContent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateClassDeclaration";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private final class AnnotationDependencyVisitor
    extends AnnotationVisitor {
        AnnotationDependencyVisitor() {
            super(589824);
        }

        public void visit(String name, Object value) {
            if (value instanceof Type) {
                ClassFileAnalysisVisitor.this.addType((Type)value);
            }
        }

        public void visitEnum(String name, String desc, String value) {
            ClassFileAnalysisVisitor.this.addDesc(desc);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            ClassFileAnalysisVisitor.this.addDesc(desc);
            return this;
        }

        public AnnotationVisitor visitArray(String name) {
            return this;
        }
    }

    private final class DependencySignatureVisitor
    extends SignatureVisitor {
        DependencySignatureVisitor() {
            super(589824);
        }

        public void visitClassType(String name) {
            ClassFileAnalysisVisitor.this.addName(name);
        }

        public void visitInnerClassType(String name) {
            ClassFileAnalysisVisitor.this.addName(name);
        }
    }

    private final class DependencyFieldVisitor
    extends FieldVisitor {
        DependencyFieldVisitor() {
            super(589824);
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            ClassFileAnalysisVisitor.this.addDesc(desc);
            return ClassFileAnalysisVisitor.this.myAnnotationVisitor;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            ClassFileAnalysisVisitor.this.addDesc(desc);
            return ClassFileAnalysisVisitor.this.myAnnotationVisitor;
        }
    }

    private final class DependencyMethodVisitor
    extends MethodVisitor {
        private Label myFirstLabel;

        DependencyMethodVisitor() {
            super(589824);
            this.myFirstLabel = null;
        }

        public void visitLabel(Label label) {
            if (this.myFirstLabel == null) {
                this.myFirstLabel = label;
            }
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return ClassFileAnalysisVisitor.this.myAnnotationVisitor;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            ClassFileAnalysisVisitor.this.addDesc(desc);
            return ClassFileAnalysisVisitor.this.myAnnotationVisitor;
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            ClassFileAnalysisVisitor.this.addDesc(desc);
            return ClassFileAnalysisVisitor.this.myAnnotationVisitor;
        }

        public void visitTypeInsn(int opcode, String desc) {
            if (187 == opcode) {
                return;
            }
            if (desc.charAt(0) == '[') {
                ClassFileAnalysisVisitor.this.addDesc(desc);
            } else {
                ClassFileAnalysisVisitor.this.addName(desc);
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            JvmClassBytecodeDeclaration targetClass = ClassFileAnalysisVisitor.this.addName(owner);
            ClassFileAnalysisVisitor.this.addDesc(desc);
            ClassFileAnalysisVisitor.this.processFieldReference(targetClass, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            JvmClassBytecodeDeclaration targetClass = ClassFileAnalysisVisitor.this.addName(owner);
            ClassFileAnalysisVisitor.this.addMethodDesc(desc);
            ClassFileAnalysisVisitor.this.processMethodReference(targetClass, name, desc);
            ClassFileAnalysisVisitor.this.processImplicitSuperclassReferences(targetClass);
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                ClassFileAnalysisVisitor.this.addType((Type)cst);
            }
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            ClassFileAnalysisVisitor.this.addDesc(desc);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            ClassFileAnalysisVisitor.this.addName(type);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (this.myFirstLabel == start) {
                return;
            }
            ClassFileAnalysisVisitor.this.addTypeSignature(signature == null ? desc : signature);
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            ClassFileAnalysisVisitor.this.addDesc(desc);
            for (Object arg : bsmArgs) {
                if (!(arg instanceof Handle)) continue;
                ClassFileAnalysisVisitor.this.addHandle((Handle)arg);
            }
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            ClassFileAnalysisVisitor.this.addDesc(desc);
            return ClassFileAnalysisVisitor.this.myAnnotationVisitor;
        }

        public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            ClassFileAnalysisVisitor.this.addDesc(desc);
            return ClassFileAnalysisVisitor.this.myAnnotationVisitor;
        }

        public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            ClassFileAnalysisVisitor.this.addDesc(desc);
            return ClassFileAnalysisVisitor.this.myAnnotationVisitor;
        }

        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
            ClassFileAnalysisVisitor.this.addDesc(desc);
            return ClassFileAnalysisVisitor.this.myAnnotationVisitor;
        }
    }
}

