/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Chunk;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/roots/JavaProjectDependenciesAnalyzer;", "", "<init>", "()V", "findExportedDependenciesReachableViaThisDependencyOnly", "", "Lcom/intellij/openapi/roots/OrderEntry;", "module", "Lcom/intellij/openapi/module/Module;", "dependency", "rootModelProvider", "Lcom/intellij/openapi/roots/RootModelProvider;", "removeDuplicatingDependencies", "", "originalDependencies", "", "intellij.java.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nJavaProjectDependenciesAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaProjectDependenciesAnalyzer.kt\ncom/intellij/openapi/roots/JavaProjectDependenciesAnalyzer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public final class JavaProjectDependenciesAnalyzer {
    @NotNull
    public static final JavaProjectDependenciesAnalyzer INSTANCE = new JavaProjectDependenciesAnalyzer();

    private JavaProjectDependenciesAnalyzer() {
    }

    @JvmStatic
    @NotNull
    public static final Map<OrderEntry, OrderEntry> findExportedDependenciesReachableViaThisDependencyOnly(@NotNull Module module, @NotNull Module dependency, @NotNull RootModelProvider rootModelProvider) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)rootModelProvider, (String)"rootModelProvider");
        ModuleOrderEntry moduleOrderEntry = OrderEntryUtil.findModuleOrderEntry((ModuleRootModel)rootModelProvider.getRootModel(module), (Module)dependency);
        if (moduleOrderEntry == null) {
            throw new IllegalArgumentException("Cannot find dependency from " + module + " to " + dependency);
        }
        ModuleOrderEntry moduleOrderEntry2 = moduleOrderEntry;
        Condition withoutThisDependency = arg_0 -> JavaProjectDependenciesAnalyzer.findExportedDependenciesReachableViaThisDependencyOnly$lambda$0(module, dependency, arg_0);
        OrderEnumerator orderEnumerator = rootModelProvider.getRootModel(module).orderEntries().satisfying(withoutThisDependency).using(rootModelProvider).compileOnly().recursively().exportedOnly();
        Intrinsics.checkNotNullExpressionValue((Object)orderEnumerator, (String)"exportedOnly(...)");
        OrderEnumerator enumerator = orderEnumerator;
        if (moduleOrderEntry2.getScope().isForProductionCompile()) {
            OrderEnumerator orderEnumerator2 = enumerator.productionOnly();
            Intrinsics.checkNotNullExpressionValue((Object)orderEnumerator2, (String)"productionOnly(...)");
            enumerator = orderEnumerator2;
        }
        LinkedHashSet reachableModules = new LinkedHashSet();
        LinkedHashSet reachableLibraries = new LinkedHashSet();
        enumerator.forEach(arg_0 -> JavaProjectDependenciesAnalyzer.findExportedDependenciesReachableViaThisDependencyOnly$lambda$2(arg_0 -> JavaProjectDependenciesAnalyzer.findExportedDependenciesReachableViaThisDependencyOnly$lambda$1(reachableModules, reachableLibraries, arg_0), arg_0));
        LinkedHashMap result = new LinkedHashMap();
        rootModelProvider.getRootModel(dependency).orderEntries().using(rootModelProvider).exportedOnly().withoutSdk().withoutModuleSourceEntries().forEach(arg_0 -> JavaProjectDependenciesAnalyzer.findExportedDependenciesReachableViaThisDependencyOnly$lambda$4(arg_0 -> JavaProjectDependenciesAnalyzer.findExportedDependenciesReachableViaThisDependencyOnly$lambda$3(reachableModules, result, rootModelProvider, reachableLibraries, arg_0), arg_0));
        return result;
    }

    @NotNull
    public final List<Module> removeDuplicatingDependencies(@NotNull Collection<? extends Module> originalDependencies) {
        Intrinsics.checkNotNullParameter(originalDependencies, (String)"originalDependencies");
        List dependencies = CollectionsKt.distinct((Iterable)originalDependencies);
        MultiMap multiMap = MultiMap.createLinkedSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createLinkedSet(...)");
        MultiMap moduleToDominatingDependency = multiMap;
        for (Module dependency : dependencies) {
            ModuleRootManager.getInstance((Module)dependency).orderEntries().exportedOnly().recursively().compileOnly().runtimeOnly().productionOnly().forEachModule(arg_0 -> JavaProjectDependenciesAnalyzer.removeDuplicatingDependencies$lambda$1(arg_0 -> JavaProjectDependenciesAnalyzer.removeDuplicatingDependencies$lambda$0(moduleToDominatingDependency, dependency, arg_0), arg_0));
        }
        Graph graph = GraphGenerator.generate((InboundSemiGraph)((InboundSemiGraph)new InboundSemiGraph<Module>((List<? extends Module>)dependencies, (MultiMap<Module, Module>)moduleToDominatingDependency){
            final /* synthetic */ List<Module> $dependencies;
            final /* synthetic */ MultiMap<Module, Module> $moduleToDominatingDependency;
            {
                this.$dependencies = $dependencies;
                this.$moduleToDominatingDependency = $moduleToDominatingDependency;
            }

            public Collection<Module> getNodes() {
                return this.$dependencies;
            }

            public Iterator<Module> getIn(Module n) {
                Intrinsics.checkNotNullParameter((Object)n, (String)"n");
                return this.$moduleToDominatingDependency.get((Object)n).iterator();
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)graph, (String)"generate(...)");
        Graph dominationGraph2 = graph;
        Graph graph2 = GraphAlgorithms.getInstance().computeSCCGraph(dominationGraph2);
        Intrinsics.checkNotNullExpressionValue((Object)graph2, (String)"computeSCCGraph(...)");
        Graph sccGraph = graph2;
        HashSet toRemove = new HashSet();
        for (Chunk scc : sccGraph.getNodes()) {
            if (sccGraph.getIn((Object)scc).hasNext()) {
                toRemove.addAll(scc.getNodes());
                continue;
            }
            if (scc.getNodes().size() <= 1) continue;
            Set set = scc.getNodes();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getNodes(...)");
            toRemove.addAll(CollectionsKt.drop((Iterable)CollectionsKt.toList((Iterable)set), (int)1));
        }
        return CollectionsKt.minus((Iterable)dependencies, (Iterable)toRemove);
    }

    private static final boolean findExportedDependenciesReachableViaThisDependencyOnly$lambda$3$0(LinkedHashSet $reachableModules, Module $depModule, LinkedHashSet $reachableLibraries, LinkedHashMap $result, OrderEntry $direct, OrderEntry transitive) {
        if ((transitive instanceof ModuleSourceOrderEntry && !$reachableModules.contains(((ModuleSourceOrderEntry)transitive).getOwnerModule()) && !Intrinsics.areEqual((Object)$depModule, (Object)((ModuleSourceOrderEntry)transitive).getOwnerModule()) || transitive instanceof LibraryOrderEntry && ((LibraryOrderEntry)transitive).getLibrary() != null && !CollectionsKt.contains((Iterable)$reachableLibraries, (Object)((LibraryOrderEntry)transitive).getLibrary())) && !((Map)$result).containsKey(transitive)) {
            ((Map)$result).put(transitive, $direct);
        }
        return true;
    }

    private static final boolean findExportedDependenciesReachableViaThisDependencyOnly$lambda$3$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean findExportedDependenciesReachableViaThisDependencyOnly$lambda$0(Module $module, Module $dependency, OrderEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return !(entry instanceof ModuleOrderEntry) || !Intrinsics.areEqual((Object)entry.getOwnerModule(), (Object)$module) || !Intrinsics.areEqual((Object)$dependency, (Object)((ModuleOrderEntry)entry).getModule());
    }

    private static final boolean findExportedDependenciesReachableViaThisDependencyOnly$lambda$1(LinkedHashSet $reachableModules, LinkedHashSet $reachableLibraries, OrderEntry entry) {
        block2: {
            OrderEntry orderEntry;
            block3: {
                block1: {
                    orderEntry = entry;
                    if (!(orderEntry instanceof ModuleSourceOrderEntry)) break block1;
                    $reachableModules.add(((ModuleSourceOrderEntry)entry).getOwnerModule());
                    break block2;
                }
                if (!(orderEntry instanceof ModuleOrderEntry)) break block3;
                Module module = ((ModuleOrderEntry)entry).getModule();
                if (module == null) break block2;
                Module it = module;
                boolean bl = false;
                $reachableModules.add(it);
                break block2;
            }
            if (!(orderEntry instanceof LibraryOrderEntry)) break block2;
            Library library = ((LibraryOrderEntry)entry).getLibrary();
            if (library != null) {
                Library it = library;
                boolean bl = false;
                $reachableLibraries.add(it);
            }
        }
        return true;
    }

    private static final boolean findExportedDependenciesReachableViaThisDependencyOnly$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean findExportedDependenciesReachableViaThisDependencyOnly$lambda$3(LinkedHashSet $reachableModules, LinkedHashMap $result, RootModelProvider $rootModelProvider, LinkedHashSet $reachableLibraries, OrderEntry direct) {
        if (direct instanceof ModuleOrderEntry) {
            Module depModule = ((ModuleOrderEntry)direct).getModule();
            if (depModule != null && !$reachableModules.contains(depModule)) {
                ((Map)$result).put(direct, direct);
                $rootModelProvider.getRootModel(depModule).orderEntries().using($rootModelProvider).exportedOnly().withoutSdk().recursively().forEach(arg_0 -> JavaProjectDependenciesAnalyzer.findExportedDependenciesReachableViaThisDependencyOnly$lambda$3$1(arg_0 -> JavaProjectDependenciesAnalyzer.findExportedDependenciesReachableViaThisDependencyOnly$lambda$3$0($reachableModules, depModule, $reachableLibraries, $result, direct, arg_0), arg_0));
            }
        } else if (direct instanceof LibraryOrderEntry && ((LibraryOrderEntry)direct).getLibrary() != null && !CollectionsKt.contains((Iterable)$reachableLibraries, (Object)((LibraryOrderEntry)direct).getLibrary())) {
            ((Map)$result).put(direct, direct);
        }
        return true;
    }

    private static final boolean findExportedDependenciesReachableViaThisDependencyOnly$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeDuplicatingDependencies$lambda$0(MultiMap $moduleToDominatingDependency, Module $dependency, Module it) {
        $moduleToDominatingDependency.putValue((Object)it, (Object)$dependency);
        return true;
    }

    private static final boolean removeDuplicatingDependencies$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

