/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.FilePropertyPusherBase;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.JavaLanguageLevelPusherCustomizer;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.roots.impl.VirtualFileJavaLanguageLevelListener;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FilePropertyKey;
import com.intellij.psi.FilePropertyKeyImpl;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaLanguageLevelPusher
extends FilePropertyPusherBase<LanguageLevel> {
    private static final FilePropertyKey<LanguageLevel> KEY = FilePropertyKeyImpl.createPersistentEnumKey((String)"LANGUAGE_LEVEL", (String)"language_level_persistence", (int)4, LanguageLevel.class);

    public static void pushLanguageLevel(@NotNull Project project) {
        if (project == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(0);
        }
        JavaLanguageLevelPusher pusher = (JavaLanguageLevelPusher)((Object)EP_NAME.findExtension(JavaLanguageLevelPusher.class));
        PushedFilePropertiesUpdater.getInstance((Project)project).pushAll(new FilePropertyPusher[]{pusher});
    }

    @NotNull
    public FilePropertyKey<LanguageLevel> getFilePropertyKey() {
        FilePropertyKey<LanguageLevel> filePropertyKey = KEY;
        if (filePropertyKey == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(1);
        }
        return filePropertyKey;
    }

    public boolean pushDirectoriesOnly() {
        return false;
    }

    public boolean acceptsFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(2);
        }
        if (project == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(3);
        }
        return file.equals(ProjectFileIndex.getInstance((Project)project).getSourceRootForFile(file));
    }

    @NotNull
    public LanguageLevel getDefaultValue() {
        LanguageLevel languageLevel = LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(4);
        }
        return languageLevel;
    }

    public LanguageLevel getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(5);
        }
        return JavaLanguageLevelPusherCustomizer.getImmediateValueImpl(project, file);
    }

    public LanguageLevel getImmediateValue(@NotNull Module module) {
        if (module == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(6);
        }
        return LanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(7);
        }
        if (project == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(8);
        }
        return ProjectFileIndex.getInstance((Project)project).isInSourceContent(file);
    }

    public void propertyChanged(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull LanguageLevel actualProperty) {
        if (project == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(9);
        }
        if (fileOrDir == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(10);
        }
        if (actualProperty == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(11);
        }
        VirtualFileJavaLanguageLevelListener publisher = (VirtualFileJavaLanguageLevelListener)project.getMessageBus().syncPublisher(VirtualFileJavaLanguageLevelListener.TOPIC);
        for (VirtualFile child : fileOrDir.getChildren()) {
            if (child.isDirectory() || !JavaLanguageLevelPusher.isJavaLike(child.getFileType())) continue;
            PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(child);
            publisher.levelChanged(child, actualProperty);
        }
    }

    private static boolean isJavaLike(FileType type) {
        return type instanceof LanguageFileType && ((LanguageFileType)type).getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    @NlsContexts.DetailedDescription
    @Nullable
    public String getInconsistencyLanguageLevelMessage(@NotNull String message, @NotNull LanguageLevel level, @NotNull PsiFile file) {
        if (message == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(12);
        }
        if (level == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(13);
        }
        if (file == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(14);
        }
        return JavaLanguageLevelPusherCustomizer.getInconsistencyLanguageLevelMessageImpl(message, level, file);
    }

    @Nullable
    public static LanguageLevel getPushedLanguageLevel(@NotNull VirtualFile file) {
        if (file == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(15);
        }
        return (LanguageLevel)ObjectUtils.coalesce((Object)((LanguageLevel)KEY.getPersistentValue(file.getParent())), (Object)((LanguageLevel)KEY.getPersistentValue(file)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher";
                break;
            }
            case 2: 
            case 7: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualProperty";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePropertyKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pushLanguageLevel";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getInconsistencyLanguageLevelMessage";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPushedLanguageLevel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

