/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaReflectionReferenceUtil {
    public static final String JAVA_LANG_INVOKE_METHOD_HANDLES_LOOKUP = "java.lang.invoke.MethodHandles.Lookup";
    public static final String JAVA_LANG_INVOKE_METHOD_TYPE = "java.lang.invoke.MethodType";
    public static final String JAVA_LANG_CONSTANT_CLASS_DESC = "java.lang.constant.ClassDesc";
    public static final String METHOD_TYPE = "methodType";
    public static final String GENERIC_METHOD_TYPE = "genericMethodType";
    private static final CallMatcher LIST_FACTORY = CallMatcher.anyOf(CallMatcher.staticCall("java.util.List", "of"), CallMatcher.staticCall("java.util.Arrays", "asList"));
    private static final CallMatcher.Simple METHOD_TYPE_MATCHER = CallMatcher.staticCall("java.lang.invoke.MethodType", "methodType");
    public static final CallMatcher METHOD_TYPE_WITH_METHOD_TYPE_MATCHER = METHOD_TYPE_MATCHER.parameterTypes("java.lang.Class", "java.lang.invoke.MethodType");
    public static final CallMatcher METHOD_TYPE_WITH_LIST_MATCHER = METHOD_TYPE_MATCHER.parameterTypes("java.lang.Class", "java.util.List");
    public static final CallMatcher METHOD_TYPE_WITH_CLASSES_MATCHER = CallMatcher.anyOf(METHOD_TYPE_MATCHER.parameterCount(3), METHOD_TYPE_MATCHER.parameterCount(1), METHOD_TYPE_MATCHER.parameterTypes("java.lang.Class", "java.lang.Class"));
    public static final CallMatcher METHOD_TYPE_WITH_ARRAY_MATCHER = METHOD_TYPE_MATCHER.parameterTypes("java.lang.Class", "java.lang.Class<?>[]");
    public static final CallMatcher GENERIC_METHOD_TYPE_MATCHER = CallMatcher.staticCall("java.lang.invoke.MethodType", "genericMethodType");
    private static final CallMapper<ReflectiveSignature> SIGNATURE_MAPPER = new CallMapper<Function<PsiMethodCallExpression, ReflectiveSignature>>().register(METHOD_TYPE_WITH_CLASSES_MATCHER, call -> JavaReflectionReferenceUtil.composeMethodSignatureFromTypes(call.getArgumentList().getExpressions())).register(METHOD_TYPE_WITH_LIST_MATCHER, call -> JavaReflectionReferenceUtil.composeMethodSignatureFromReturnTypeAndList(call.getArgumentList().getExpressions())).register(METHOD_TYPE_WITH_ARRAY_MATCHER, call -> JavaReflectionReferenceUtil.composeMethodSignatureFromReturnTypeAndArray(call.getArgumentList().getExpressions())).register(METHOD_TYPE_WITH_METHOD_TYPE_MATCHER, call -> JavaReflectionReferenceUtil.composeMethodSignatureFromReturnTypeAndMethodType(call.getArgumentList().getExpressions())).register(GENERIC_METHOD_TYPE_MATCHER, call -> JavaReflectionReferenceUtil.composeGenericMethodSignature(call.getArgumentList().getExpressions()));
    public static final String FIND_VIRTUAL = "findVirtual";
    public static final String FIND_STATIC = "findStatic";
    public static final String FIND_SPECIAL = "findSpecial";
    public static final String FIND_GETTER = "findGetter";
    public static final String FIND_SETTER = "findSetter";
    public static final String FIND_STATIC_GETTER = "findStaticGetter";
    public static final String FIND_STATIC_SETTER = "findStaticSetter";
    public static final String FIND_VAR_HANDLE = "findVarHandle";
    public static final String FIND_STATIC_VAR_HANDLE = "findStaticVarHandle";
    public static final String FIND_CONSTRUCTOR = "findConstructor";
    public static final String FIND_CLASS = "findClass";
    public static final String[] HANDLE_FACTORY_METHOD_NAMES = new String[]{"findVirtual", "findStatic", "findSpecial", "findGetter", "findSetter", "findStaticGetter", "findStaticSetter", "findVarHandle", "findStaticVarHandle"};
    public static final String GET_FIELD = "getField";
    public static final String GET_DECLARED_FIELD = "getDeclaredField";
    public static final String GET_METHOD = "getMethod";
    public static final String GET_DECLARED_METHOD = "getDeclaredMethod";
    public static final String GET_CONSTRUCTOR = "getConstructor";
    public static final String GET_DECLARED_CONSTRUCTOR = "getDeclaredConstructor";
    public static final String JAVA_LANG_CLASS_LOADER = "java.lang.ClassLoader";
    public static final String FOR_NAME = "forName";
    public static final String LOAD_CLASS = "loadClass";
    public static final String GET_CLASS = "getClass";
    public static final String NEW_INSTANCE = "newInstance";
    public static final String TYPE = "TYPE";
    public static final String NEW_UPDATER = "newUpdater";
    public static final String ATOMIC_LONG_FIELD_UPDATER = "java.util.concurrent.atomic.AtomicLongFieldUpdater";
    public static final String ATOMIC_INTEGER_FIELD_UPDATER = "java.util.concurrent.atomic.AtomicIntegerFieldUpdater";
    public static final String ATOMIC_REFERENCE_FIELD_UPDATER = "java.util.concurrent.atomic.AtomicReferenceFieldUpdater";
    private static final RecursionGuard<PsiElement> ourGuard = RecursionManager.createGuard((String)"JavaLangClassMemberReference");

    @Contract(value="null -> null")
    public static ReflectiveType getReflectiveType(@Nullable PsiExpression context) {
        ReflectiveType result;
        PsiExpression definition;
        PsiType variable;
        PsiReferenceExpression reference;
        Object className;
        PsiElement method;
        if ((context = PsiUtil.skipParenthesizedExprDown((PsiExpression)context)) == null) {
            return null;
        }
        if (context instanceof PsiClassObjectAccessExpression) {
            PsiTypeElement operand = ((PsiClassObjectAccessExpression)context).getOperand();
            return ReflectiveType.create(operand.getType(), true);
        }
        if (context instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)context;
            String methodReferenceName = methodCall.getMethodExpression().getReferenceName();
            if (FOR_NAME.equals(methodReferenceName)) {
                PsiExpression argument;
                PsiExpression[] expressions;
                method = methodCall.resolveMethod();
                if (method != null && JavaReflectionReferenceUtil.isJavaLangClass(method.getContainingClass()) && (expressions = methodCall.getArgumentList().getExpressions()).length == 1 && (className = JavaReflectionReferenceUtil.computeConstantExpression(argument = JavaReflectionReferenceUtil.findDefinition(PsiUtil.skipParenthesizedExprDown((PsiExpression)expressions[0])), String.class)) != null) {
                    return ReflectiveType.create(JavaReflectionReferenceUtil.findClass((String)className, (PsiElement)context), true);
                }
            } else if (GET_CLASS.equals(methodReferenceName) && methodCall.getArgumentList().isEmpty() && (method = methodCall.resolveMethod()) != null && JavaReflectionReferenceUtil.isJavaLangObject(method.getContainingClass())) {
                PsiExpression definition2;
                PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)methodCall.getMethodExpression().getQualifierExpression());
                if (qualifier instanceof PsiReferenceExpression && (definition2 = JavaReflectionReferenceUtil.findVariableDefinition((PsiReferenceExpression)qualifier)) != null) {
                    return JavaReflectionReferenceUtil.getClassInstanceType(definition2);
                }
                if (qualifier != null) {
                    return JavaReflectionReferenceUtil.getClassInstanceType(qualifier);
                }
            }
        }
        if (context instanceof PsiReferenceExpression && (method = (reference = (PsiReferenceExpression)context).resolve()) instanceof PsiVariable && JavaReflectionReferenceUtil.isJavaLangClass(PsiTypesUtil.getPsiClass((PsiType)(variable = (PsiVariable)method).getType())) && (definition = JavaReflectionReferenceUtil.findVariableDefinition(reference, (PsiVariable)variable)) != null && (result = (ReflectiveType)ourGuard.doPreventingRecursion((Object)variable, false, () -> JavaReflectionReferenceUtil.getReflectiveType(definition))) != null) {
            return result;
        }
        variable = context.getType();
        if (variable instanceof PsiClassType) {
            PsiType typeArgument;
            PsiType erasure;
            PsiClass argumentClass;
            PsiTypeParameter[] parameters;
            PsiField field;
            PsiReferenceExpression ref;
            PsiClassType type = (PsiClassType)variable;
            PsiClassType.ClassResolveResult resolveResult = type.resolveGenerics();
            PsiClass resolvedElement = resolveResult.getElement();
            if (!JavaReflectionReferenceUtil.isJavaLangClass(resolvedElement)) {
                return null;
            }
            if (context instanceof PsiReferenceExpression && TYPE.equals((ref = (PsiReferenceExpression)context).getReferenceName()) && (className = ref.resolve()) instanceof PsiField && (field = (PsiField)className).hasModifierProperty("final") && field.hasModifierProperty("static")) {
                PsiPrimitiveType unboxedType;
                PsiType[] classTypeArguments = type.getParameters();
                PsiPrimitiveType psiPrimitiveType = unboxedType = classTypeArguments.length == 1 ? PsiPrimitiveType.getUnboxedType((PsiType)classTypeArguments[0]) : null;
                if (unboxedType != null && field.getContainingClass() == PsiUtil.resolveClassInClassTypeOnly((PsiType)classTypeArguments[0])) {
                    return ReflectiveType.create((PsiType)unboxedType, true);
                }
            }
            if ((parameters = resolvedElement.getTypeParameters()).length == 1 && (argumentClass = PsiTypesUtil.getPsiClass((PsiType)(erasure = TypeConversionUtil.erasure((PsiType)(typeArgument = resolveResult.getSubstitutor().substitute(parameters[0])))))) != null && !JavaReflectionReferenceUtil.isJavaLangObject(argumentClass)) {
                return ReflectiveType.create(argumentClass, false);
            }
        }
        return null;
    }

    @Nullable
    private static ReflectiveType getClassInstanceType(@Nullable PsiExpression expression) {
        PsiMethod method;
        PsiMethodCallExpression methodCall;
        String methodReferenceName;
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) == null) {
            return null;
        }
        if (expression instanceof PsiMethodCallExpression && NEW_INSTANCE.equals(methodReferenceName = (methodCall = (PsiMethodCallExpression)expression).getMethodExpression().getReferenceName()) && (method = methodCall.resolveMethod()) != null) {
            PsiExpression typeExpression;
            PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
            if (arguments.length == 0 && JavaReflectionReferenceUtil.isClassWithName(method.getContainingClass(), "java.lang.Class")) {
                PsiExpression qualifier = methodCall.getMethodExpression().getQualifierExpression();
                if (qualifier != null) {
                    return (ReflectiveType)ourGuard.doPreventingRecursion((Object)qualifier, false, () -> JavaReflectionReferenceUtil.getReflectiveType(qualifier));
                }
            } else if (arguments.length > 1 && JavaReflectionReferenceUtil.isClassWithName(method.getContainingClass(), "java.lang.reflect.Array") && (typeExpression = arguments[0]) != null) {
                ReflectiveType itemType = (ReflectiveType)ourGuard.doPreventingRecursion((Object)typeExpression, false, () -> JavaReflectionReferenceUtil.getReflectiveType(typeExpression));
                return ReflectiveType.arrayOf(itemType);
            }
        }
        return ReflectiveType.create(expression.getType(), false);
    }

    @Contract(value="null,_->null")
    @Nullable
    public static <T> T computeConstantExpression(@Nullable PsiExpression expression, @NotNull Class<T> expectedType) {
        if (expectedType == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(0);
        }
        expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
        Object computed = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)expression, (boolean)false);
        return (T)ObjectUtils.tryCast((Object)computed, expectedType);
    }

    @Nullable
    public static ReflectiveClass getReflectiveClass(PsiExpression context) {
        ReflectiveType reflectiveType = JavaReflectionReferenceUtil.getReflectiveType(context);
        return reflectiveType != null ? reflectiveType.getReflectiveClass() : null;
    }

    @Nullable
    public static PsiExpression findDefinition(@Nullable PsiExpression expression) {
        int preventEndlessLoop = 5;
        while (expression instanceof PsiReferenceExpression) {
            if (--preventEndlessLoop == 0) {
                return null;
            }
            expression = JavaReflectionReferenceUtil.findVariableDefinition((PsiReferenceExpression)expression);
        }
        return expression;
    }

    @Nullable
    private static PsiExpression findVariableDefinition(@NotNull PsiReferenceExpression referenceExpression) {
        PsiElement resolved;
        if (referenceExpression == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(1);
        }
        return (resolved = referenceExpression.resolve()) instanceof PsiVariable ? JavaReflectionReferenceUtil.findVariableDefinition(referenceExpression, (PsiVariable)resolved) : null;
    }

    @Nullable
    private static PsiExpression findVariableDefinition(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiVariable variable) {
        if (referenceExpression == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(2);
        }
        if (variable == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(3);
        }
        if (variable.hasModifierProperty("final")) {
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                return initializer;
            }
            if (variable instanceof PsiField) {
                return JavaReflectionReferenceUtil.findFinalFieldDefinition(referenceExpression, (PsiField)variable);
            }
        }
        return DeclarationSearchUtils.findDefinition(referenceExpression, variable);
    }

    @Nullable
    private static PsiExpression findFinalFieldDefinition(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiField field) {
        if (referenceExpression == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(4);
        }
        if (field == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(5);
        }
        if (!field.hasModifierProperty("final")) {
            return null;
        }
        PsiClass psiClass = (PsiClass)ObjectUtils.tryCast((Object)field.getParent(), PsiClass.class);
        if (psiClass != null) {
            boolean isStatic = field.hasModifierProperty("static");
            List initializers = ContainerUtil.filter((Object[])psiClass.getInitializers(), initializer -> initializer.hasModifierProperty("static") == isStatic);
            for (PsiClassInitializer initializer2 : initializers) {
                PsiExpression assignedExpression = JavaReflectionReferenceUtil.getAssignedExpression((PsiMember)initializer2, field);
                if (assignedExpression == null) continue;
                return assignedExpression;
            }
            if (!isStatic) {
                PsiMethod[] constructors = psiClass.getConstructors();
                if (constructors.length == 1) {
                    return JavaReflectionReferenceUtil.getAssignedExpression((PsiMember)constructors[0], field);
                }
                for (PsiMethod constructor : constructors) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)constructor, (PsiElement)referenceExpression, (boolean)true)) continue;
                    return JavaReflectionReferenceUtil.getAssignedExpression((PsiMember)constructor, field);
                }
            }
        }
        return null;
    }

    @Nullable
    private static PsiExpression getAssignedExpression(@NotNull PsiMember maybeContainsAssignment, @NotNull PsiField field) {
        PsiAssignmentExpression assignment;
        if (maybeContainsAssignment == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(6);
        }
        if (field == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(7);
        }
        return (assignment = (PsiAssignmentExpression)SyntaxTraverser.psiTraverser((PsiElement)maybeContainsAssignment).filter(PsiAssignmentExpression.class).find(expression -> ExpressionUtils.isReferenceTo(expression.getLExpression(), (PsiVariable)field))) != null ? assignment.getRExpression() : null;
    }

    private static PsiClass findClass(@NotNull String qualifiedName, @NotNull PsiElement context) {
        if (qualifiedName == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(8);
        }
        if (context == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(9);
        }
        Project project = context.getProject();
        return JavaPsiFacade.getInstance((Project)project).findClass(qualifiedName, GlobalSearchScope.allScope((Project)project));
    }

    @Contract(value="null -> false")
    static boolean isJavaLangClass(@Nullable PsiClass aClass) {
        return JavaReflectionReferenceUtil.isClassWithName(aClass, "java.lang.Class");
    }

    @Contract(value="null -> false")
    static boolean isJavaLangObject(@Nullable PsiClass aClass) {
        return JavaReflectionReferenceUtil.isClassWithName(aClass, "java.lang.Object");
    }

    @Contract(value="null, _ -> false")
    public static boolean isClassWithName(@Nullable PsiClass aClass, @NotNull String name) {
        if (name == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(10);
        }
        return aClass != null && name.equals(aClass.getQualifiedName());
    }

    @ApiStatus.Internal
    @Contract(value="null -> false")
    public static boolean isRegularMethod(@Nullable PsiMethod method) {
        return method != null && !method.isConstructor();
    }

    @ApiStatus.Internal
    public static boolean isPublic(@NotNull PsiMember member) {
        if (member == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(11);
        }
        return member.hasModifierProperty("public");
    }

    @ApiStatus.Internal
    public static boolean isAtomicallyUpdateable(@NotNull PsiField field) {
        if (field == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(12);
        }
        if (field.hasModifierProperty("static") || !field.hasModifierProperty("volatile")) {
            return false;
        }
        PsiType type = field.getType();
        return !(type instanceof PsiPrimitiveType) || PsiTypes.intType().equals((Object)type) || PsiTypes.longType().equals((Object)type);
    }

    @ApiStatus.Internal
    @Nullable
    public static String getParameterTypesText(@NotNull PsiMethod method) {
        if (method == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(13);
        }
        StringJoiner joiner = new StringJoiner(", ");
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            String typeText = JavaReflectionReferenceUtil.getTypeText(parameter.getType());
            joiner.add(typeText + ".class");
        }
        return joiner.toString();
    }

    @ApiStatus.Internal
    public static void shortenArgumentsClassReferences(@NotNull InsertionContext context) {
        PsiElement parameter;
        PsiExpressionList parameterList;
        if (context == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(14);
        }
        if ((parameterList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)(parameter = PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset())), PsiExpressionList.class)) != null && parameterList.getParent() instanceof PsiMethodCallExpression) {
            JavaCodeStyleManager.getInstance((Project)context.getProject()).shortenClassReferences((PsiElement)parameterList);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static LookupElement withPriority(@NotNull LookupElement lookupElement, boolean hasPriority) {
        if (lookupElement == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(15);
        }
        LookupElement lookupElement2 = hasPriority ? lookupElement : PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)-1.0);
        if (lookupElement2 == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(16);
        }
        return lookupElement2;
    }

    @ApiStatus.Internal
    @Nullable
    public static LookupElement withPriority(@Nullable LookupElement lookupElement, int priority) {
        return priority == 0 || lookupElement == null ? lookupElement : PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)priority);
    }

    @ApiStatus.Internal
    public static int getMethodSortOrder(@NotNull PsiMethod method) {
        if (method == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(17);
        }
        return JavaReflectionReferenceUtil.isJavaLangObject(method.getContainingClass()) ? 1 : (JavaReflectionReferenceUtil.isPublic((PsiMember)method) ? -1 : 0);
    }

    @ApiStatus.Internal
    @Nullable
    public static String getMemberType(@Nullable PsiElement element) {
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
        return methodCall != null ? methodCall.getMethodExpression().getReferenceName() : null;
    }

    @ApiStatus.Internal
    @Nullable
    public static LookupElement lookupMethod(@NotNull PsiMethod method, @Nullable InsertHandler<LookupElement> insertHandler) {
        ReflectiveSignature signature;
        if (method == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(18);
        }
        return (signature = JavaReflectionReferenceUtil.getMethodSignature(method)) != null ? LookupElementBuilder.create((Object)signature, (String)method.getName()).withIcon(signature.getIcon()).withTailText(signature.getShortArgumentTypes()).withInsertHandler(insertHandler) : null;
    }

    @ApiStatus.Internal
    public static void replaceText(@NotNull InsertionContext context, @NotNull String text) {
        if (context == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(19);
        }
        if (text == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(20);
        }
        PsiElement newElement = PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset());
        PsiElement params = newElement.getParent().getParent();
        int end = params.getTextRange().getEndOffset() - 1;
        int start = Math.min(newElement.getTextRange().getEndOffset(), end);
        context.getDocument().replaceString(start, end, (CharSequence)text);
        context.commitDocument();
        JavaReflectionReferenceUtil.shortenArgumentsClassReferences(context);
    }

    @NotNull
    public static String getTypeText(@NotNull PsiType type) {
        if (type == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(21);
        }
        ReflectiveType reflectiveType = ReflectiveType.create(type, false);
        String string = reflectiveType.getQualifiedName();
        if (string == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Nullable
    public static String getTypeText(@Nullable PsiExpression argument) {
        ReflectiveType reflectiveType = JavaReflectionReferenceUtil.getReflectiveType(argument);
        return reflectiveType != null ? reflectiveType.getQualifiedName() : null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static ReflectiveSignature getMethodSignature(@Nullable PsiMethod method) {
        if (method != null) {
            ArrayList<String> types = new ArrayList<String>();
            PsiType returnType = method.getReturnType();
            types.add(JavaReflectionReferenceUtil.getTypeText((PsiType)(returnType != null ? returnType : PsiTypes.voidType())));
            for (PsiParameter parameter : method.getParameterList().getParameters()) {
                types.add(JavaReflectionReferenceUtil.getTypeText(parameter.getType()));
            }
            Icon icon = method.getIcon(1);
            return ReflectiveSignature.create(icon, types);
        }
        return null;
    }

    @NotNull
    public static String getMethodTypeExpressionText(@NotNull ReflectiveSignature signature) {
        if (signature == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(23);
        }
        String types = signature.getText(true, type -> type + ".class");
        String string = "java.lang.invoke.MethodType.methodType" + types;
        if (string == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    public static boolean isCallToMethod(@NotNull PsiMethodCallExpression methodCall, @NotNull String className, @NotNull String methodName) {
        if (methodCall == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(25);
        }
        if (className == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(26);
        }
        if (methodName == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(27);
        }
        return MethodCallUtils.isCallToMethod(methodCall, className, null, methodName, (PsiType[])null);
    }

    @Nullable
    public static List<PsiExpression> getVarargs(@Nullable PsiExpression maybeArray) {
        if (ExpressionUtils.isNullLiteral(maybeArray)) {
            return Collections.emptyList();
        }
        if (JavaReflectionReferenceUtil.isVarargAsArray(maybeArray)) {
            PsiExpression argumentsDefinition = JavaReflectionReferenceUtil.findDefinition(maybeArray);
            if (argumentsDefinition instanceof PsiArrayInitializerExpression) {
                return Arrays.asList(((PsiArrayInitializerExpression)argumentsDefinition).getInitializers());
            }
            if (argumentsDefinition instanceof PsiNewExpression) {
                Integer itemCount;
                PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)argumentsDefinition).getArrayInitializer();
                if (arrayInitializer != null) {
                    return Arrays.asList(arrayInitializer.getInitializers());
                }
                PsiExpression[] dimensions = ((PsiNewExpression)argumentsDefinition).getArrayDimensions();
                if (dimensions.length == 1 && (itemCount = JavaReflectionReferenceUtil.computeConstantExpression(JavaReflectionReferenceUtil.findDefinition(dimensions[0]), Integer.class)) != null && itemCount >= 0 && itemCount < 256) {
                    return Collections.nCopies(itemCount, null);
                }
            }
        }
        return null;
    }

    @Nullable
    public static List<PsiExpression> getListComponents(@Nullable PsiExpression maybeList) {
        if (LIST_FACTORY.matches(maybeList = PsiUtil.skipParenthesizedExprDown((PsiExpression)maybeList)) && maybeList instanceof PsiMethodCallExpression) {
            List<PsiExpression> varargs;
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)maybeList;
            PsiExpression[] expressions = callExpression.getArgumentList().getExpressions();
            if (expressions.length == 0) {
                return Collections.emptyList();
            }
            PsiExpression firstArgument = PsiUtil.skipParenthesizedExprDown((PsiExpression)expressions[0]);
            if (MethodCallUtils.isVarArgCall((PsiCall)callExpression) && (varargs = JavaReflectionReferenceUtil.getVarargs(firstArgument)) != null) {
                return varargs;
            }
            if (JavaReflectionReferenceUtil.isVarargAsArray(firstArgument)) {
                return null;
            }
            return Arrays.asList(expressions);
        }
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isVarargAsArray(@Nullable PsiExpression maybeArray) {
        PsiType type = maybeArray != null ? maybeArray.getType() : null;
        return type instanceof PsiArrayType && type.getArrayDimensions() == 1 && type.getDeepComponentType() instanceof PsiClassType;
    }

    @Nullable
    public static ReflectiveSignature composeMethodSignature(@Nullable PsiExpression methodTypeExpression) {
        return JavaReflectionReferenceUtil.composeMethodSignature(methodTypeExpression, true);
    }

    @Nullable
    private static ReflectiveSignature composeMethodSignature(@Nullable PsiExpression methodTypeExpression, boolean allowRecursion) {
        PsiExpression typeDefinition = JavaReflectionReferenceUtil.findDefinition(PsiUtil.skipParenthesizedExprDown((PsiExpression)methodTypeExpression));
        if (METHOD_TYPE_WITH_METHOD_TYPE_MATCHER.matches(typeDefinition) && !allowRecursion) {
            return null;
        }
        if (typeDefinition instanceof PsiMethodCallExpression) {
            return SIGNATURE_MAPPER.mapFirst((PsiMethodCallExpression)typeDefinition);
        }
        return null;
    }

    @Nullable
    private static ReflectiveSignature composeMethodSignatureFromReturnTypeAndMethodType(PsiExpression @NotNull [] arguments) {
        String text;
        ReflectiveSignature signature;
        PsiExpression methodType;
        if (arguments == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(28);
        }
        if (arguments.length == 2 && (methodType = JavaReflectionReferenceUtil.findInnermostMethodType(arguments[1])) != null && (signature = JavaReflectionReferenceUtil.composeMethodSignature(methodType, false)) != null && (text = JavaReflectionReferenceUtil.getTypeText(arguments[0])) != null) {
            return signature.withReturnType(text);
        }
        return null;
    }

    @Nullable
    public static PsiExpression findInnermostMethodType(@Nullable PsiExpression methodType) {
        methodType = JavaReflectionReferenceUtil.findDefinition(methodType);
        int preventEndlessLoop = 5;
        while (METHOD_TYPE_WITH_METHOD_TYPE_MATCHER.matches(methodType)) {
            if (--preventEndlessLoop == 0) {
                return null;
            }
            if (!((methodType = PsiUtil.skipParenthesizedExprDown((PsiExpression)methodType)) instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)methodType;
            PsiExpression[] expressions = call.getArgumentList().getExpressions();
            if (expressions.length != 2) {
                return null;
            }
            methodType = JavaReflectionReferenceUtil.findDefinition(expressions[1]);
        }
        return METHOD_TYPE_MATCHER.matches(methodType) ? methodType : null;
    }

    @Nullable
    private static ReflectiveSignature composeMethodSignatureFromReturnTypeAndList(PsiExpression @NotNull [] arguments) {
        PsiExpression list;
        List<PsiExpression> components;
        PsiExpression returnType;
        if (arguments == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(29);
        }
        if (arguments.length == 2 && (returnType = JavaReflectionReferenceUtil.findDefinition(arguments[0])) != null && (components = JavaReflectionReferenceUtil.getListComponents(list = arguments[1])) != null) {
            List signature = ContainerUtil.prepend(components, (Object[])new PsiExpression[]{returnType});
            return ReflectiveSignature.create(ContainerUtil.map((Collection)signature, typeExpression -> JavaReflectionReferenceUtil.getTypeText(typeExpression)));
        }
        return null;
    }

    @Nullable
    private static ReflectiveSignature composeMethodSignatureFromReturnTypeAndArray(PsiExpression @NotNull [] arguments) {
        PsiExpression array;
        List<PsiExpression> components;
        PsiExpression returnType;
        if (arguments == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(30);
        }
        if (arguments.length == 2 && (returnType = JavaReflectionReferenceUtil.findDefinition(arguments[0])) != null && (components = JavaReflectionReferenceUtil.getVarargs(array = arguments[1])) != null) {
            List signature = ContainerUtil.prepend(components, (Object[])new PsiExpression[]{returnType});
            return ReflectiveSignature.create(ContainerUtil.map((Collection)signature, typeExpression -> JavaReflectionReferenceUtil.getTypeText(typeExpression)));
        }
        return null;
    }

    @Nullable
    private static ReflectiveSignature composeMethodSignatureFromTypes(PsiExpression @NotNull [] returnAndParameterTypes) {
        if (returnAndParameterTypes == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(31);
        }
        List typeTexts = ContainerUtil.map((Object[])returnAndParameterTypes, JavaReflectionReferenceUtil::getTypeText);
        return ReflectiveSignature.create(typeTexts);
    }

    @Nullable
    public static Pair.NonNull<Integer, Boolean> getGenericSignature(PsiExpression @NotNull [] genericSignatureShape) {
        Boolean finalArray;
        if (genericSignatureShape == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(32);
        }
        if (genericSignatureShape.length == 0 || genericSignatureShape.length > 2) {
            return null;
        }
        Integer objectArgCount = JavaReflectionReferenceUtil.computeConstantExpression(genericSignatureShape[0], Integer.class);
        Boolean bl = finalArray = genericSignatureShape.length > 1 ? JavaReflectionReferenceUtil.computeConstantExpression(genericSignatureShape[1], Boolean.class) : Boolean.valueOf(false);
        if (objectArgCount == null || objectArgCount < 0 || objectArgCount > 255) {
            return null;
        }
        if (finalArray == null || finalArray.booleanValue() && objectArgCount > 254) {
            return null;
        }
        return Pair.createNonNull((Object)objectArgCount, (Object)finalArray);
    }

    @Nullable
    private static ReflectiveSignature composeGenericMethodSignature(PsiExpression @NotNull [] genericSignatureShape) {
        Pair.NonNull<Integer, Boolean> signature;
        if (genericSignatureShape == null) {
            JavaReflectionReferenceUtil.$$$reportNull$$$0(33);
        }
        if ((signature = JavaReflectionReferenceUtil.getGenericSignature(genericSignatureShape)) == null) {
            return null;
        }
        int objectArgCount = (Integer)signature.getFirst();
        boolean finalArray = (Boolean)signature.getSecond();
        ArrayList<String> typeNames = new ArrayList<String>();
        typeNames.add("java.lang.Object");
        for (int i = 0; i < objectArgCount; ++i) {
            typeNames.add("java.lang.Object");
        }
        if (finalArray) {
            typeNames.add("java.lang.Object[]");
        }
        return ReflectiveSignature.create(typeNames);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 22, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeContainsAssignment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 9: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 13: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElement";
                break;
            }
            case 16: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnAndParameterTypes";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericSignatureShape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "withPriority";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodTypeExpressionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeConstantExpression";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findVariableDefinition";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findFinalFieldDefinition";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAssignedExpression";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = FIND_CLASS;
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isClassWithName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isPublic";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAtomicallyUpdateable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypesText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "shortenArgumentsClassReferences";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "withPriority";
                break;
            }
            case 16: 
            case 22: 
            case 24: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSortOrder";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lookupMethod";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "replaceText";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getMethodTypeExpressionText";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isCallToMethod";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "composeMethodSignatureFromReturnTypeAndMethodType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "composeMethodSignatureFromReturnTypeAndList";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "composeMethodSignatureFromReturnTypeAndArray";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "composeMethodSignatureFromTypes";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getGenericSignature";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "composeGenericMethodSignature";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 22, 24 -> new IllegalStateException(string);
        };
    }

    public static final class ReflectiveType {
        final PsiType myType;
        final boolean myIsExact;

        private ReflectiveType(@NotNull PsiType erasedType, boolean isExact) {
            if (erasedType == null) {
                ReflectiveType.$$$reportNull$$$0(0);
            }
            this.myType = erasedType;
            this.myIsExact = isExact;
        }

        @NotNull
        public String getQualifiedName() {
            String string = this.myType.getCanonicalText();
            if (string == null) {
                ReflectiveType.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String toString() {
            return this.myType.getCanonicalText();
        }

        public boolean isEqualTo(@Nullable PsiType otherType) {
            return otherType != null && this.myType.equals(ReflectiveType.erasure(otherType));
        }

        public boolean isAssignableFrom(@NotNull PsiType type) {
            if (type == null) {
                ReflectiveType.$$$reportNull$$$0(2);
            }
            return this.myType.isAssignableFrom(type);
        }

        public boolean isPrimitive() {
            return this.myType instanceof PsiPrimitiveType;
        }

        @NotNull
        public PsiType getType() {
            PsiType psiType = this.myType;
            if (psiType == null) {
                ReflectiveType.$$$reportNull$$$0(3);
            }
            return psiType;
        }

        public boolean isExact() {
            return this.myIsExact;
        }

        @Nullable
        public ReflectiveClass getReflectiveClass() {
            PsiClass psiClass = this.getPsiClass();
            if (psiClass != null) {
                return new ReflectiveClass(psiClass, this.myIsExact);
            }
            return null;
        }

        @Nullable
        public ReflectiveType getArrayComponentType() {
            if (this.myType instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)this.myType).getComponentType();
                return new ReflectiveType(componentType, this.myIsExact);
            }
            return null;
        }

        @Nullable
        public PsiClass getPsiClass() {
            return PsiTypesUtil.getPsiClass((PsiType)this.myType);
        }

        @Contract(value="!null,_ -> !null; null,_ -> null")
        @Nullable
        public static ReflectiveType create(@Nullable PsiType originalType, boolean isExact) {
            if (originalType != null) {
                return new ReflectiveType(ReflectiveType.erasure(originalType), isExact);
            }
            return null;
        }

        @Contract(value="!null,_ -> !null; null,_ -> null")
        @Nullable
        public static ReflectiveType create(@Nullable PsiClass psiClass, boolean isExact) {
            if (psiClass != null) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
                return new ReflectiveType((PsiType)factory.createType(psiClass), isExact);
            }
            return null;
        }

        @Contract(value="!null -> !null; null -> null")
        @Nullable
        public static ReflectiveType arrayOf(@Nullable ReflectiveType itemType) {
            if (itemType != null) {
                return new ReflectiveType((PsiType)itemType.myType.createArrayType(), itemType.myIsExact);
            }
            return null;
        }

        @NotNull
        private static PsiType erasure(@NotNull PsiType type) {
            PsiType erasure;
            if (type == null) {
                ReflectiveType.$$$reportNull$$$0(4);
            }
            if ((erasure = TypeConversionUtil.erasure((PsiType)type)) instanceof PsiEllipsisType) {
                PsiType psiType = ((PsiEllipsisType)erasure).toArrayType();
                if (psiType == null) {
                    ReflectiveType.$$$reportNull$$$0(5);
                }
                return psiType;
            }
            PsiType psiType = erasure;
            if (psiType == null) {
                ReflectiveType.$$$reportNull$$$0(6);
            }
            return psiType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "erasedType";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveType";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifiedName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "erasure";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAssignableFrom";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "erasure";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    public static class ReflectiveClass {
        final PsiClass myPsiClass;
        final boolean myIsExact;

        public ReflectiveClass(@NotNull PsiClass psiClass, boolean isExact) {
            if (psiClass == null) {
                ReflectiveClass.$$$reportNull$$$0(0);
            }
            this.myPsiClass = psiClass;
            this.myIsExact = isExact;
        }

        @NotNull
        public PsiClass getPsiClass() {
            PsiClass psiClass = this.myPsiClass;
            if (psiClass == null) {
                ReflectiveClass.$$$reportNull$$$0(1);
            }
            return psiClass;
        }

        public boolean isExact() {
            return this.myIsExact || this.myPsiClass.hasModifierProperty("final");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsiClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static final class ReflectiveSignature
    implements Comparable<ReflectiveSignature> {
        public static final ReflectiveSignature NO_ARGUMENT_CONSTRUCTOR_SIGNATURE = new ReflectiveSignature(null, "void", ArrayUtilRt.EMPTY_STRING_ARRAY);
        private final Icon myIcon;
        @NotNull
        private final String myReturnType;
        private final String @NotNull [] myArgumentTypes;

        @Nullable
        public static ReflectiveSignature create(@NotNull List<String> typeTexts) {
            if (typeTexts == null) {
                ReflectiveSignature.$$$reportNull$$$0(0);
            }
            return ReflectiveSignature.create(null, typeTexts);
        }

        @Nullable
        public static ReflectiveSignature create(@Nullable Icon icon, @NotNull List<String> typeTexts) {
            if (typeTexts == null) {
                ReflectiveSignature.$$$reportNull$$$0(1);
            }
            if (!typeTexts.isEmpty() && !typeTexts.contains(null)) {
                String[] argumentTypes = ArrayUtilRt.toStringArray(typeTexts.subList(1, typeTexts.size()));
                return new ReflectiveSignature(icon, typeTexts.get(0), argumentTypes);
            }
            return null;
        }

        private ReflectiveSignature(@Nullable Icon icon, @NotNull String returnType, String @NotNull [] argumentTypes) {
            if (returnType == null) {
                ReflectiveSignature.$$$reportNull$$$0(2);
            }
            if (argumentTypes == null) {
                ReflectiveSignature.$$$reportNull$$$0(3);
            }
            this.myIcon = icon;
            this.myReturnType = returnType;
            this.myArgumentTypes = argumentTypes;
        }

        public String getText(boolean withReturnType, @NotNull Function<? super String, String> transformation) {
            if (transformation == null) {
                ReflectiveSignature.$$$reportNull$$$0(4);
            }
            return this.getText(withReturnType, true, transformation);
        }

        public String getText(boolean withReturnType, boolean withParentheses, @NotNull Function<? super String, String> transformation) {
            if (transformation == null) {
                ReflectiveSignature.$$$reportNull$$$0(5);
            }
            StringJoiner joiner = new StringJoiner(", ", withParentheses ? "(" : "", withParentheses ? ")" : "");
            if (withReturnType) {
                joiner.add(transformation.apply(this.myReturnType));
            }
            for (String argumentType : this.myArgumentTypes) {
                joiner.add(transformation.apply(argumentType));
            }
            return joiner.toString();
        }

        @NotNull
        public String getShortReturnType() {
            String string = PsiNameHelper.getShortClassName((String)this.myReturnType);
            if (string == null) {
                ReflectiveSignature.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public String getShortArgumentTypes() {
            String string = this.getText(false, PsiNameHelper::getShortClassName);
            if (string == null) {
                ReflectiveSignature.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon != null ? this.myIcon : IconManager.getInstance().getPlatformIcon(PlatformIcons.Method);
            if (icon == null) {
                ReflectiveSignature.$$$reportNull$$$0(8);
            }
            return icon;
        }

        public ReflectiveSignature withReturnType(@NotNull String returnType) {
            if (returnType == null) {
                ReflectiveSignature.$$$reportNull$$$0(9);
            }
            return new ReflectiveSignature(this.myIcon, returnType, this.myArgumentTypes);
        }

        @Override
        public int compareTo(@NotNull ReflectiveSignature other) {
            int c;
            if (other == null) {
                ReflectiveSignature.$$$reportNull$$$0(10);
            }
            if ((c = this.myArgumentTypes.length - other.myArgumentTypes.length) != 0) {
                return c;
            }
            c = ArrayUtil.lexicographicCompare((String[])this.myArgumentTypes, (String[])other.myArgumentTypes);
            if (c != 0) {
                return c;
            }
            return this.myReturnType.compareTo(other.myReturnType);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ReflectiveSignature)) return false;
            ReflectiveSignature other = (ReflectiveSignature)o;
            if (!Objects.equals(this.myReturnType, other.myReturnType)) return false;
            if (!Arrays.equals(this.myArgumentTypes, other.myArgumentTypes)) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.myReturnType, Arrays.hashCode(this.myArgumentTypes));
        }

        public String toString() {
            return this.myReturnType + " " + Arrays.toString(this.myArgumentTypes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeTexts";
                    break;
                }
                case 2: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argumentTypes";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transformation";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveSignature";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveSignature";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShortReturnType";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShortArgumentTypes";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "withReturnType";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    }
}

