/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.DefaultPropertyAccessorDetector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PropertyAccessorDetector {
    public static final ExtensionPointName<PropertyAccessorDetector> EP_NAME = ExtensionPointName.create((String)"com.intellij.propertyAccessorDetector");

    @Nullable
    public static PropertyAccessorInfo detectFrom(@NotNull PsiMethod method) {
        if (method == null) {
            PropertyAccessorDetector.$$$reportNull$$$0(0);
        }
        for (PropertyAccessorDetector detector : EP_NAME.getExtensionList()) {
            PropertyAccessorInfo accessorInfo = detector.detectPropertyAccessor(method);
            if (accessorInfo == null) continue;
            return accessorInfo;
        }
        return DefaultPropertyAccessorDetector.getDefaultAccessorInfo(method);
    }

    @Nullable
    public PropertyAccessorInfo detectPropertyAccessor(@NotNull PsiMethod var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/util/PropertyAccessorDetector", "detectFrom"));
    }

    public record PropertyAccessorInfo(@NotNull String propertyName, @NotNull PsiType propertyType, @NotNull PropertyKind kind) {
        @NotNull
        private final String propertyName;
        @NotNull
        private final PsiType propertyType;
        @NotNull
        private final PropertyKind kind;

        public PropertyAccessorInfo(@NotNull String propertyName, @NotNull PsiType propertyType, @NotNull PropertyKind kind) {
            if (propertyName == null) {
                PropertyAccessorInfo.$$$reportNull$$$0(0);
            }
            if (propertyType == null) {
                PropertyAccessorInfo.$$$reportNull$$$0(1);
            }
            if (kind == null) {
                PropertyAccessorInfo.$$$reportNull$$$0(2);
            }
        }

        public boolean isKindOf(PropertyKind other) {
            return this.kind == other;
        }

        @NotNull
        public String propertyName() {
            String string = this.propertyName;
            if (string == null) {
                PropertyAccessorInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public PsiType propertyType() {
            PsiType psiType = this.propertyType;
            if (psiType == null) {
                PropertyAccessorInfo.$$$reportNull$$$0(4);
            }
            return psiType;
        }

        @NotNull
        public PropertyKind kind() {
            PropertyKind propertyKind = this.kind;
            if (propertyKind == null) {
                PropertyAccessorInfo.$$$reportNull$$$0(5);
            }
            return propertyKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/util/PropertyAccessorDetector$PropertyAccessorInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/util/PropertyAccessorDetector$PropertyAccessorInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "propertyName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "propertyType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

