/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModifierListUtil {
    private ModifierListUtil() {
    }

    @Nullable
    public static PsiModifierList createSortedModifierList(@NotNull PsiModifierList modifierList, @Nullable Comparator<? super PsiAnnotation> customAnnotationComparator, boolean allowAnnotationTypeBeInAnyAllowedPlace) {
        if (modifierList == null) {
            ModifierListUtil.$$$reportNull$$$0(0);
        }
        @NonNls String text = String.join((CharSequence)" ", ModifierListUtil.getSortedModifiers(modifierList, customAnnotationComparator, allowAnnotationTypeBeInAnyAllowedPlace));
        return ModifierListUtil.createNewModifierList(modifierList, text);
    }

    @Nullable
    private static PsiModifierList createNewModifierList(@NotNull PsiModifierList oldModifierList, @NotNull String newModifiersText) {
        if (oldModifierList == null) {
            ModifierListUtil.$$$reportNull$$$0(1);
        }
        if (newModifiersText == null) {
            ModifierListUtil.$$$reportNull$$$0(2);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)oldModifierList.getProject());
        PsiElement parent = oldModifierList.getParent();
        if (parent instanceof PsiRequiresStatement) {
            String text = ("requires " + newModifiersText + " x;").trim();
            PsiRequiresStatement statement = (PsiRequiresStatement)factory.createModuleStatementFromText(text, (PsiElement)oldModifierList);
            return statement.getModifierList();
        }
        if (parent instanceof PsiClass) {
            String text = (newModifiersText + " class X {}").trim();
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)factory.createStatementFromText(text, (PsiElement)oldModifierList);
            return ((PsiClass)declarationStatement.getDeclaredElements()[0]).getModifierList();
        }
        String text = (newModifiersText + " void x() {}").trim();
        PsiMethod method = factory.createMethodFromText(text, (PsiElement)oldModifierList);
        return method.getModifierList();
    }

    public static boolean isMethodWithVoidReturnType(@NotNull PsiElement element) {
        if (element == null) {
            ModifierListUtil.$$$reportNull$$$0(3);
        }
        return element instanceof PsiMethod && PsiTypes.voidType().equals((Object)((PsiMethod)element).getReturnType());
    }

    public static List<String> getSortedModifiers(@NotNull PsiModifierList modifierList, @Nullable Comparator<? super PsiAnnotation> customAnnotationComparator, boolean allowAnnotationTypeBeInAnyAllowedPlace) {
        if (modifierList == null) {
            ModifierListUtil.$$$reportNull$$$0(4);
        }
        SmartList modifiers = new SmartList();
        SmartList typeAnnotations = new SmartList();
        SmartList annotations = new SmartList();
        for (PsiElement child : modifierList.getChildren()) {
            if (child instanceof PsiJavaToken) {
                modifiers.add(child.getText());
                continue;
            }
            if (!(child instanceof PsiAnnotation)) continue;
            PsiAnnotation annotation = (PsiAnnotation)child;
            if (PsiImplUtil.isTypeAnnotation((PsiElement)child) && !ModifierListUtil.isMethodWithVoidReturnType(modifierList.getParent())) {
                Set annotationTargets;
                PsiAnnotation.TargetType[] targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)annotation.getOwner());
                PsiClass annotationClass = annotation.resolveAnnotationType();
                EnumSet<PsiAnnotation.TargetType> annotationAllowedTypes = EnumSet.noneOf(PsiAnnotation.TargetType.class);
                if (annotationClass != null && (annotationTargets = AnnotationTargetUtil.getAnnotationTargets((PsiClass)annotationClass)) != null) {
                    annotationAllowedTypes.addAll(annotationTargets);
                }
                annotationAllowedTypes.removeAll(Arrays.stream(targets).collect(Collectors.toSet()));
                if (ModifierListUtil.isTypeAnnotationAlwaysUseWithType((PsiElement)annotation) || allowAnnotationTypeBeInAnyAllowedPlace && !modifiers.isEmpty() || AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{targets[0]}) == PsiAnnotation.TargetType.UNKNOWN || annotationAllowedTypes.size() == 1 && annotationAllowedTypes.contains(PsiAnnotation.TargetType.TYPE_USE)) {
                    typeAnnotations.add(annotation);
                    continue;
                }
            }
            annotations.add(annotation);
        }
        modifiers.sort(new ModifierComparator());
        SmartList result = new SmartList();
        if (customAnnotationComparator != null) {
            annotations.sort(customAnnotationComparator);
            typeAnnotations.sort(customAnnotationComparator);
        }
        result.addAll(ContainerUtil.map((Collection)annotations, a -> a.getText()));
        result.addAll(modifiers);
        result.addAll(ContainerUtil.map((Collection)typeAnnotations, a -> a.getText()));
        return result;
    }

    public static boolean isTypeAnnotationAlwaysUseWithType(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ModifierListUtil.$$$reportNull$$$0(5);
        }
        return JavaCodeStyleSettings.getInstance((PsiFile)psiElement.getContainingFile()).GENERATE_USE_TYPE_ANNOTATION_BEFORE_TYPE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldModifierList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newModifiersText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/util/ModifierListUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createSortedModifierList";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewModifierList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodWithVoidReturnType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSortedModifiers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isTypeAnnotationAlwaysUseWithType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ModifierComparator
    implements Comparator<String> {
        @NonNls
        private static final String[] s_modifierOrder = new String[]{"public", "protected", "private", "abstract", "default", "static", "final", "transient", "volatile", "synchronized", "native", "strictfp", "transitive", "sealed", "non-sealed"};

        @Override
        public int compare(String modifier1, String modifier2) {
            if (modifier1.equals(modifier2)) {
                return 0;
            }
            for (String modifier : s_modifierOrder) {
                if (modifier.equals(modifier1)) {
                    return -1;
                }
                if (!modifier.equals(modifier2)) continue;
                return 1;
            }
            return modifier1.compareTo(modifier2);
        }
    }
}

