/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.duplicates.ComplexityHolder;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtractableExpressionPart {
    final PsiExpression myUsage;
    final PsiVariable myVariable;
    final Object myValue;
    final PsiType myType;

    private ExtractableExpressionPart(@NotNull PsiExpression usage, PsiVariable variable, Object value, @NotNull PsiType type) {
        if (usage == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(0);
        }
        if (type == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(1);
        }
        this.myUsage = usage;
        this.myVariable = variable;
        this.myValue = value;
        this.myType = type;
    }

    @Nullable
    static PsiType commonType(@NotNull ExtractableExpressionPart part1, @NotNull ExtractableExpressionPart part2) {
        if (part1 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(2);
        }
        if (part2 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(3);
        }
        return ExtractableExpressionPart.commonType(part1.myType, part2.myType);
    }

    @Nullable
    private static PsiType commonType(@NotNull PsiType type1, @NotNull PsiType type2) {
        if (type1 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(4);
        }
        if (type2 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(5);
        }
        if (type1.isAssignableFrom(type2)) {
            return type1;
        }
        if (type2.isAssignableFrom(type1)) {
            return type2;
        }
        return null;
    }

    @NotNull
    ExtractableExpressionPart copy() {
        return new ExtractableExpressionPart(this.myUsage, this.myVariable, this.myValue, this.myType);
    }

    public boolean isEquivalent(@NotNull ExtractableExpressionPart part) {
        if (part == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(6);
        }
        if (this.myVariable != null && this.myVariable.equals((Object)part.myVariable)) {
            return true;
        }
        if (this.myValue != null && this.myValue.equals(part.myValue)) {
            return true;
        }
        PsiExpression usage1 = PsiUtil.skipParenthesizedExprDown((PsiExpression)this.myUsage);
        PsiExpression usage2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)part.myUsage);
        return usage1 != null && usage2 != null && JavaPsiEquivalenceUtil.areExpressionsEquivalent((PsiExpression)usage1, (PsiExpression)usage2);
    }

    @Nullable
    static ExtractableExpressionPart match(@NotNull PsiExpression expression, @NotNull List<? extends PsiElement> scope, @Nullable ComplexityHolder complexityHolder) {
        if (expression == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(8);
        }
        if (expression instanceof PsiReferenceExpression) {
            return ExtractableExpressionPart.matchVariable((PsiReferenceExpression)expression, scope);
        }
        boolean isConstant = PsiUtil.isConstantExpression((PsiExpression)expression);
        if (isConstant && PsiTreeUtil.findChildOfType((PsiElement)expression, PsiJavaCodeReferenceElement.class) == null) {
            return ExtractableExpressionPart.matchConstant(expression);
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
        if (parent instanceof PsiExpressionStatement || parent instanceof PsiExpressionList && parent.getParent() instanceof PsiExpressionListStatement) {
            return null;
        }
        if (complexityHolder != null && (isConstant || complexityHolder.isAcceptableExpression(expression))) {
            return ExtractableExpressionPart.matchExpression(expression);
        }
        return null;
    }

    @Nullable
    private static ExtractableExpressionPart matchConstant(@NotNull PsiExpression expression) {
        PsiType type;
        PsiConstantEvaluationHelper constantHelper;
        Object value;
        if (expression == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(9);
        }
        if ((value = (constantHelper = JavaPsiFacade.getInstance((Project)expression.getProject()).getConstantEvaluationHelper()).computeConstantExpression((PsiElement)expression, false)) != null && (type = expression.getType()) != null) {
            return new ExtractableExpressionPart(expression, null, value, type);
        }
        return null;
    }

    @Nullable
    static ExtractableExpressionPart matchVariable(@NotNull PsiReferenceExpression expression, @Nullable List<? extends PsiElement> scope) {
        PsiElement resolved;
        if (expression == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(10);
        }
        if ((resolved = expression.resolve()) instanceof PsiField && ExtractableExpressionPart.isModification(expression)) {
            return null;
        }
        if (resolved instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)resolved;
            if (scope == null || !DuplicatesFinder.isUnder(resolved, scope)) {
                return new ExtractableExpressionPart((PsiExpression)expression, variable, null, variable.getType());
            }
        }
        return null;
    }

    private static boolean isModification(@NotNull PsiReferenceExpression expression) {
        PsiUnaryExpression unary;
        IElementType tokenType;
        PsiAssignmentExpression assignment;
        PsiElement parent;
        if (expression == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(11);
        }
        return (parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent())) instanceof PsiAssignmentExpression ? PsiTreeUtil.isAncestor((PsiElement)(assignment = (PsiAssignmentExpression)parent).getLExpression(), (PsiElement)expression, (boolean)false) : parent instanceof PsiUnaryExpression && ((tokenType = (unary = (PsiUnaryExpression)parent).getOperationTokenType()).equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) && PsiTreeUtil.isAncestor((PsiElement)unary.getOperand(), (PsiElement)expression, (boolean)false);
    }

    @Nullable
    private static ExtractableExpressionPart matchExpression(@NotNull PsiExpression expression) {
        PsiType type;
        if (expression == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(12);
        }
        if ((type = expression.getType()) != null && !PsiTypes.voidType().equals((Object)type)) {
            return new ExtractableExpressionPart(expression, null, null, type);
        }
        return null;
    }

    @NotNull
    public PsiExpression getUsage() {
        PsiExpression psiExpression = this.myUsage;
        if (psiExpression == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(13);
        }
        return psiExpression;
    }

    @NotNull
    public static ExtractableExpressionPart fromUsage(@NotNull PsiExpression usage, @NotNull PsiType type) {
        PsiType usageType;
        if (usage == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(14);
        }
        if (type == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(15);
        }
        assert ((usageType = usage.getType()) == null || type.isAssignableFrom(usageType)) : "expected " + type.getCanonicalText() + ", got " + usageType.getCanonicalText();
        return new ExtractableExpressionPart(usage, null, null, type);
    }

    public String toString() {
        return this.myUsage.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/duplicates/ExtractableExpressionPart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/duplicates/ExtractableExpressionPart";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "commonType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matchConstant";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "matchVariable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isModification";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "matchExpression";
                break;
            }
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fromUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }
}

