/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseInspectionVisitor
extends JavaElementVisitor {
    private BaseInspection inspection = null;
    private boolean onTheFly = false;
    private ProblemsHolder holder = null;

    final void setInspection(@NotNull BaseInspection inspection) {
        if (inspection == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(0);
        }
        this.inspection = inspection;
    }

    final void setOnTheFly(boolean onTheFly) {
        this.onTheFly = onTheFly;
    }

    public final boolean isOnTheFly() {
        return this.onTheFly;
    }

    protected final void registerNewExpressionError(@NotNull PsiNewExpression expression, Object ... infos) {
        PsiKeyword sibling;
        PsiJavaCodeReferenceElement classReference;
        if (expression == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(1);
        }
        if ((classReference = expression.getClassOrAnonymousClassReference()) != null) {
            this.registerError((PsiElement)classReference, infos);
        } else if (expression.getType() instanceof PsiArrayType && (sibling = (PsiKeyword)PsiTreeUtil.getNextSiblingOfType((PsiElement)expression.getFirstChild(), PsiKeyword.class)) != null) {
            this.registerError((PsiElement)sibling, infos);
        }
    }

    protected final void registerMethodCallError(@NotNull PsiMethodCallExpression expression, Object ... infos) {
        PsiReferenceExpression methodExpression;
        PsiElement nameToken;
        if (expression == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(2);
        }
        if ((nameToken = (methodExpression = expression.getMethodExpression()).getReferenceNameElement()) == null) {
            return;
        }
        this.registerError(nameToken, infos);
    }

    protected final void registerStatementError(@NotNull PsiStatement statement, Object ... infos) {
        PsiElement statementToken;
        if (statement == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(3);
        }
        if ((statementToken = statement.getFirstChild()) == null || statementToken.getTextLength() == 0) {
            return;
        }
        this.registerError(statementToken, infos);
    }

    protected final void registerModuleError(@NotNull PsiJavaModule module, Object ... infos) {
        if (module == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(4);
        }
        this.registerError((PsiElement)module.getNameIdentifier(), infos);
    }

    protected final void registerClassError(@NotNull PsiClass aClass, Object ... infos) {
        PsiIdentifier nameIdentifier;
        if (aClass == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(5);
        }
        if (aClass instanceof PsiEnumConstantInitializer) {
            PsiEnumConstantInitializer enumConstantInitializer = (PsiEnumConstantInitializer)aClass;
            PsiEnumConstant enumConstant = enumConstantInitializer.getEnumConstant();
            nameIdentifier = enumConstant.getNameIdentifier();
        } else if (aClass instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            nameIdentifier = anonymousClass.getBaseClassReference();
        } else {
            nameIdentifier = aClass.getNameIdentifier();
        }
        if (nameIdentifier == null) {
            return;
        }
        if (!nameIdentifier.isPhysical()) {
            this.registerError(nameIdentifier.getNavigationElement(), infos);
            return;
        }
        this.registerError((PsiElement)nameIdentifier, infos);
    }

    protected final void registerMethodError(@NotNull PsiMethod method, Object ... infos) {
        PsiIdentifier nameIdentifier;
        if (method == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(6);
        }
        if ((nameIdentifier = method.getNameIdentifier()) == null) {
            return;
        }
        this.registerError((PsiElement)nameIdentifier, infos);
    }

    protected final void registerVariableError(@NotNull PsiVariable variable, Object ... infos) {
        PsiIdentifier nameIdentifier;
        if (variable == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(7);
        }
        if ((nameIdentifier = variable.getNameIdentifier()) == null) {
            return;
        }
        this.registerError((PsiElement)nameIdentifier, infos);
    }

    protected final void registerTypeParameterError(@NotNull PsiTypeParameter typeParameter, Object ... infos) {
        PsiIdentifier nameIdentifier;
        if (typeParameter == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(8);
        }
        if ((nameIdentifier = typeParameter.getNameIdentifier()) == null) {
            return;
        }
        this.registerError((PsiElement)nameIdentifier, infos);
    }

    protected final void registerFieldError(@NotNull PsiField field, Object ... infos) {
        if (field == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(9);
        }
        this.registerError((PsiElement)field.getNameIdentifier(), infos);
    }

    protected final void registerModifierError(@NotNull String modifier, @NotNull PsiModifierListOwner parameter, Object ... infos) {
        if (modifier == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(10);
        }
        if (parameter == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(11);
        }
        this.registerModifierError(modifier, parameter, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, infos);
    }

    protected final void registerModifierError(@NotNull String modifier, @NotNull PsiModifierListOwner parameter, ProblemHighlightType highlightType, Object ... infos) {
        PsiElement[] children;
        PsiModifierList modifiers;
        if (modifier == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(12);
        }
        if (parameter == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(13);
        }
        if ((modifiers = parameter.getModifierList()) == null) {
            return;
        }
        for (PsiElement child : children = modifiers.getChildren()) {
            String text = child.getText();
            if (!modifier.equals(text)) continue;
            this.registerError(child, highlightType, infos);
        }
    }

    protected final void registerClassInitializerError(@NotNull PsiClassInitializer initializer, Object ... infos) {
        PsiCodeBlock body;
        PsiJavaToken lBrace;
        if (initializer == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(14);
        }
        if ((lBrace = (body = initializer.getBody()).getLBrace()) == null) {
            this.registerError((PsiElement)initializer, infos);
        } else {
            this.registerError((PsiElement)lBrace, infos);
        }
    }

    protected final void registerError(@NotNull PsiElement location, Object ... infos) {
        if (location == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(15);
        }
        this.registerError(location, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, infos);
    }

    protected final void registerError(@NotNull PsiElement location, ProblemHighlightType highlightType, Object ... infos) {
        if (location == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(16);
        }
        assert (location.getTextLength() != 0 || location instanceof PsiFile);
        LocalQuickFix[] fixes = this.createAndInitFixes(infos);
        String description = this.inspection.buildErrorString(infos);
        this.holder.registerProblem(location, description, highlightType, fixes);
    }

    protected final void registerPossibleProblem(@Nullable PsiElement element) {
        if (element != null) {
            this.holder.registerPossibleProblem(element);
        }
    }

    protected final void registerErrorAtOffset(@NotNull PsiElement location, int offset, int length, Object ... infos) {
        if (location == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(17);
        }
        this.registerErrorAtOffset(location, offset, length, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, infos);
    }

    protected final void registerErrorAtOffset(@NotNull PsiElement location, int offset, int length, ProblemHighlightType highlightType, Object ... infos) {
        if (location == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(18);
        }
        LocalQuickFix[] fixes = this.createAndInitFixes(infos);
        String description = this.inspection.buildErrorString(infos);
        TextRange range = new TextRange(offset, offset + length);
        this.holder.registerProblem(location, description, highlightType, range, fixes);
    }

    protected final void registerErrorAtRange(@NotNull PsiElement startLocation, @NotNull PsiElement endLocation, Object ... infos) {
        if (startLocation == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(19);
        }
        if (endLocation == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(20);
        }
        if (startLocation.getTextLength() == 0 && startLocation == endLocation) {
            return;
        }
        LocalQuickFix[] fixes = this.createAndInitFixes(infos);
        String description = this.inspection.buildErrorString(infos);
        ProblemDescriptor problemDescriptor = this.holder.getManager().createProblemDescriptor(startLocation, endLocation, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.onTheFly, fixes);
        this.holder.registerProblem(problemDescriptor);
    }

    private LocalQuickFix @NotNull [] createAndInitFixes(Object[] infos) {
        LocalQuickFix[] fixes;
        for (LocalQuickFix fix : fixes = this.createFixes(infos)) {
            if (!(fix instanceof InspectionGadgetsFix)) continue;
            InspectionGadgetsFix igFix = (InspectionGadgetsFix)fix;
            igFix.setOnTheFly(this.onTheFly);
        }
        if (fixes == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(21);
        }
        return fixes;
    }

    private LocalQuickFix @NotNull [] createFixes(Object ... infos) {
        if (!this.onTheFly && this.inspection.buildQuickFixesOnlyForOnTheFlyErrors()) {
            if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
                BaseInspectionVisitor.$$$reportNull$$$0(22);
            }
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] fixes = this.inspection.buildFixes(infos);
        if (fixes.length > 0) {
            if (fixes == null) {
                BaseInspectionVisitor.$$$reportNull$$$0(23);
            }
            return fixes;
        }
        LocalQuickFix fix = this.inspection.buildFix(infos);
        if (fix == null) {
            if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
                BaseInspectionVisitor.$$$reportNull$$$0(24);
            }
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
        if (localQuickFixArray == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(25);
        }
        return localQuickFixArray;
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        if (expression == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(26);
        }
        this.visitExpression((PsiExpression)expression);
    }

    public final void setProblemsHolder(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(27);
        }
        this.holder = holder;
    }

    public PsiFile getCurrentFile() {
        return this.holder.getFile();
    }

    protected boolean isVisibleHighlight(@NotNull PsiElement element) {
        if (element == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(28);
        }
        return !this.isOnTheFly() || !InspectionProjectProfileManager.isInformationLevel((String)this.inspection.getShortName(), (PsiElement)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21, 22, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 1: 
            case 2: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startLocation";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endLocation";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/BaseInspectionVisitor";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/BaseInspectionVisitor";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndInitFixes";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setInspection";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerNewExpressionError";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerMethodCallError";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerStatementError";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerModuleError";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerClassError";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerMethodError";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerVariableError";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerTypeParameterError";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerFieldError";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerModifierError";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerClassInitializerError";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "registerError";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "registerErrorAtOffset";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "registerErrorAtRange";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceExpression";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setProblemsHolder";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isVisibleHighlight";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 21, 22, 23, 24, 25 -> new IllegalStateException(string);
        };
    }
}

