/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PackageGlobalInspection
extends BaseGlobalInspection {
    private final JobDescriptor myJobDescriptor = new JobDescriptor("");

    public boolean isGraphNeeded() {
        return false;
    }

    public final void runInspection(@NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (scope == null) {
            PackageGlobalInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            PackageGlobalInspection.$$$reportNull$$$0(1);
        }
        if (globalContext == null) {
            PackageGlobalInspection.$$$reportNull$$$0(2);
        }
        if (problemDescriptionsProcessor == null) {
            PackageGlobalInspection.$$$reportNull$$$0(3);
        }
        if (((RefManagerImpl)globalContext.getRefManager()).isDeclarationsFound()) {
            super.runInspection(scope, manager, globalContext, problemDescriptionsProcessor);
        } else {
            AnalysisScope analysisScope = globalContext.getRefManager().getScope();
            assert (analysisScope != null);
            this.myJobDescriptor.setTotalAmount(analysisScope.getFileCount());
            HashSet packages = new HashSet();
            IntRef current = new IntRef();
            analysisScope.accept(file -> {
                current.inc();
                if (file.isDirectory()) {
                    return true;
                }
                String packageName = (String)ReadAction.nonBlocking(() -> {
                    if (!scope.contains(file)) {
                        return null;
                    }
                    PsiFile element = PsiManager.getInstance((Project)scope.getProject()).findFile(file);
                    if (!(element instanceof PsiClassOwner)) {
                        return null;
                    }
                    PsiClassOwner classOwner = (PsiClassOwner)element;
                    return classOwner.getPackageName();
                }).executeSynchronously();
                if (packageName == null) {
                    return true;
                }
                do {
                    if (!packages.add(packageName)) {
                        return true;
                    }
                    this.myJobDescriptor.setDoneAmount(current.get());
                    globalContext.incrementJobDoneAmount(this.myJobDescriptor, InspectionGadgetsBundle.message("progress.text.analyzing.package.0", packageName));
                    RefPackage aPackage = (RefPackage)globalContext.getRefManager().getReference("package", packageName);
                    if (aPackage == null) {
                        return true;
                    }
                    CommonProblemDescriptor[] descriptors = this.checkPackage(aPackage, scope, manager, globalContext);
                    if (descriptors == null) continue;
                    problemDescriptionsProcessor.addProblemElement((RefEntity)aPackage, descriptors);
                } while (!(packageName = StringUtil.getPackageName((String)packageName)).isEmpty());
                return true;
            });
        }
    }

    public JobDescriptor @Nullable [] getAdditionalJobs(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            PackageGlobalInspection.$$$reportNull$$$0(4);
        }
        return new JobDescriptor[]{this.myJobDescriptor};
    }

    public final CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            PackageGlobalInspection.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            PackageGlobalInspection.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            PackageGlobalInspection.$$$reportNull$$$0(7);
        }
        if (globalContext == null) {
            PackageGlobalInspection.$$$reportNull$$$0(8);
        }
        throw new AssertionError();
    }

    public final CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        if (refEntity == null) {
            PackageGlobalInspection.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            PackageGlobalInspection.$$$reportNull$$$0(10);
        }
        if (manager == null) {
            PackageGlobalInspection.$$$reportNull$$$0(11);
        }
        if (globalContext == null) {
            PackageGlobalInspection.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            PackageGlobalInspection.$$$reportNull$$$0(13);
        }
        if (refEntity instanceof RefPackage) {
            return this.checkPackage((RefPackage)refEntity, scope, manager, globalContext);
        }
        return null;
    }

    public abstract CommonProblemDescriptor @Nullable [] checkPackage(@NotNull RefPackage var1, @NotNull AnalysisScope var2, @NotNull InspectionManager var3, @NotNull GlobalInspectionContext var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/PackageGlobalInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAdditionalJobs";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "checkElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

