/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFragment;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiReplacementUtil {
    public static void replaceFragment(@NotNull PsiFragment fragment, @NotNull @NonNls String newFragmentText) {
        if (fragment == null) {
            PsiReplacementUtil.$$$reportNull$$$0(0);
        }
        if (newFragmentText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(1);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)fragment.getProject());
        PsiFragment newFragment = factory.createStringTemplateFragment(newFragmentText, fragment.getTokenType(), (PsiElement)fragment);
        fragment.replace((PsiElement)newFragment);
    }

    public static void replaceExpression(@NotNull PsiExpression expression, @NotNull @NonNls String newExpressionText) {
        if (expression == null) {
            PsiReplacementUtil.$$$reportNull$$$0(2);
        }
        if (newExpressionText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(3);
        }
        Project project = expression.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression newExpression = factory.createExpressionFromText(newExpressionText, (PsiElement)expression);
        PsiElement replacementExpression = expression.replace((PsiElement)newExpression);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        styleManager.reformat(replacementExpression);
    }

    public static void replaceExpression(@NotNull PsiExpression expression, @NotNull @NonNls String newExpressionText, CommentTracker tracker) {
        if (expression == null) {
            PsiReplacementUtil.$$$reportNull$$$0(4);
        }
        if (newExpressionText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(5);
        }
        Project project = expression.getProject();
        PsiElement replacementExpression = tracker.replaceAndRestoreComments((PsiElement)expression, newExpressionText);
        CodeStyleManager.getInstance((Project)project).reformat(replacementExpression);
    }

    public static PsiElement replaceExpressionAndShorten(@NotNull PsiExpression expression, @NotNull @NonNls String newExpressionText) {
        if (expression == null) {
            PsiReplacementUtil.$$$reportNull$$$0(6);
        }
        if (newExpressionText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(7);
        }
        Project project = expression.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression newExpression = factory.createExpressionFromText(newExpressionText, (PsiElement)expression);
        PsiElement replacementExp = expression.replace((PsiElement)newExpression);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        javaCodeStyleManager.shortenClassReferences(replacementExp);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        return styleManager.reformat(replacementExp);
    }

    public static PsiElement replaceExpressionAndShorten(@NotNull PsiExpression expression, @NotNull @NonNls String newExpressionText, CommentTracker tracker) {
        if (expression == null) {
            PsiReplacementUtil.$$$reportNull$$$0(8);
        }
        if (newExpressionText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(9);
        }
        Project project = expression.getProject();
        PsiElement replacementExp = tracker.replaceAndRestoreComments((PsiElement)expression, newExpressionText);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        javaCodeStyleManager.shortenClassReferences(replacementExp);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        return styleManager.reformat(replacementExp);
    }

    public static PsiElement replaceStatement(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText) {
        if (statement == null) {
            PsiReplacementUtil.$$$reportNull$$$0(10);
        }
        if (newStatementText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(11);
        }
        Project project = statement.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiStatement newStatement = factory.createStatementFromText(newStatementText, (PsiElement)statement);
        PsiElement replacementExp = statement.replace((PsiElement)newStatement);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        return styleManager.reformat(replacementExp);
    }

    public static PsiElement replaceStatement(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText, CommentTracker commentTracker) {
        if (statement == null) {
            PsiReplacementUtil.$$$reportNull$$$0(12);
        }
        if (newStatementText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(13);
        }
        Project project = statement.getProject();
        PsiElement replacementExp = commentTracker.replaceAndRestoreComments((PsiElement)statement, newStatementText);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        return styleManager.reformat(replacementExp);
    }

    public static void replaceStatementAndShortenClassNames(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText) {
        if (statement == null) {
            PsiReplacementUtil.$$$reportNull$$$0(14);
        }
        if (newStatementText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(15);
        }
        PsiReplacementUtil.replaceStatementAndShortenClassNames(statement, newStatementText, null);
    }

    public static PsiElement replaceStatementAndShortenClassNames(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText, @Nullable CommentTracker tracker) {
        PsiStatement newStatement;
        if (statement == null) {
            PsiReplacementUtil.$$$reportNull$$$0(16);
        }
        if (newStatementText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(17);
        }
        Project project = statement.getProject();
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        JavaCodeStyleManager javaStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        if (tracker != null) {
            newStatement = (PsiStatement)tracker.replaceAndRestoreComments((PsiElement)statement, newStatementText);
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            newStatement = (PsiStatement)statement.replace((PsiElement)factory.createStatementFromText(newStatementText, (PsiElement)statement));
        }
        return styleManager.reformat(javaStyleManager.shortenClassReferences((PsiElement)newStatement));
    }

    public static void replaceExpressionWithReferenceTo(@NotNull PsiExpression expression, @NotNull PsiMember target) {
        if (expression == null) {
            PsiReplacementUtil.$$$reportNull$$$0(18);
        }
        if (target == null) {
            PsiReplacementUtil.$$$reportNull$$$0(19);
        }
        Project project = expression.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiReferenceExpression newExpression = (PsiReferenceExpression)factory.createExpressionFromText("xxx", (PsiElement)expression);
        CommentTracker tracker = new CommentTracker();
        PsiReferenceExpression replacementExpression = (PsiReferenceExpression)tracker.replaceAndRestoreComments((PsiElement)expression, (PsiElement)newExpression);
        PsiElement element = replacementExpression.bindToElement((PsiElement)target);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
        styleManager.shortenClassReferences(element);
    }

    @NotNull
    public static String getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement) {
        if (element == null) {
            PsiReplacementUtil.$$$reportNull$$$0(20);
        }
        StringBuilder out = new StringBuilder();
        PsiReplacementUtil.getElementText(element, elementToReplace, replacement, out);
        String string = out.toString();
        if (string == null) {
            PsiReplacementUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static void getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement, @NotNull StringBuilder out) {
        if (element == null) {
            PsiReplacementUtil.$$$reportNull$$$0(22);
        }
        if (out == null) {
            PsiReplacementUtil.$$$reportNull$$$0(23);
        }
        if (element.equals((Object)elementToReplace)) {
            out.append(replacement);
            return;
        }
        PsiElement[] children = element.getChildren();
        if (children.length == 0) {
            out.append(element.getText());
            return;
        }
        for (PsiElement child : children) {
            PsiReplacementUtil.getElementText(child, elementToReplace, replacement, out);
        }
    }

    @NotNull
    public static PsiAssignmentExpression replaceOperatorAssignmentWithAssignmentExpression(@NotNull PsiAssignmentExpression assignmentExpression) {
        if (assignmentExpression == null) {
            PsiReplacementUtil.$$$reportNull$$$0(24);
        }
        CommentTracker tracker = new CommentTracker();
        PsiJavaToken sign = assignmentExpression.getOperationSign();
        PsiExpression lhs = assignmentExpression.getLExpression();
        PsiExpression rhs = assignmentExpression.getRExpression();
        String operator = sign.getText();
        String newOperator = operator.substring(0, operator.length() - 1);
        String lhsText = tracker.text((PsiElement)lhs);
        String rhsText = rhs == null ? "" : tracker.text((PsiElement)rhs);
        boolean parentheses = ParenthesesUtils.areParenthesesNeeded(sign, rhs);
        String cast = PsiReplacementUtil.getCastString(lhs, rhs);
        StringBuilder newExpression = new StringBuilder(lhsText);
        newExpression.append('=').append(cast);
        if (!cast.isEmpty()) {
            newExpression.append('(');
        }
        newExpression.append(lhsText).append(newOperator);
        if (parentheses) {
            newExpression.append('(').append(rhsText).append(')');
        } else {
            newExpression.append(rhsText);
        }
        if (!cast.isEmpty()) {
            newExpression.append(')');
        }
        Project project = assignmentExpression.getProject();
        PsiElement replacementExpression = tracker.replaceAndRestoreComments((PsiElement)assignmentExpression, newExpression.toString());
        PsiAssignmentExpression psiAssignmentExpression = (PsiAssignmentExpression)CodeStyleManager.getInstance((Project)project).reformat(replacementExpression);
        if (psiAssignmentExpression == null) {
            PsiReplacementUtil.$$$reportNull$$$0(25);
        }
        return psiAssignmentExpression;
    }

    private static String getCastString(PsiExpression lhs, PsiExpression rhs) {
        if (lhs == null || rhs == null) {
            return "";
        }
        PsiType lType = lhs.getType();
        PsiType rType = rhs.getType();
        if (TypeConversionUtil.isNumericType((PsiType)rType)) {
            rType = TypeConversionUtil.binaryNumericPromotion((PsiType)lType, (PsiType)rType);
        }
        if (lType == null || rType == null || TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)rType) || !TypeConversionUtil.areTypesConvertible((PsiType)lType, (PsiType)rType)) {
            return "";
        }
        return "(" + lType.getCanonicalText() + ")";
    }

    public static void replaceExpressionWithNegatedExpression(@NotNull PsiExpression expression, @NotNull String newExpression, CommentTracker tracker) {
        Object expString;
        if (expression == null) {
            PsiReplacementUtil.$$$reportNull$$$0(26);
        }
        if (newExpression == null) {
            PsiReplacementUtil.$$$reportNull$$$0(27);
        }
        PsiExpression expressionToReplace = expression;
        if (BoolUtils.isNegated(expression)) {
            expressionToReplace = BoolUtils.findNegation(expressionToReplace);
            expString = newExpression;
        } else {
            PsiElement parent = expressionToReplace.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                expressionToReplace = (PsiExpression)parent;
                parent = parent.getParent();
            }
            expString = "!(" + newExpression + ")";
        }
        assert (expressionToReplace != null);
        PsiReplacementUtil.replaceExpression(expressionToReplace, (String)expString, tracker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFragmentText";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpressionText";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStatementText";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/PsiReplacementUtil";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/PsiReplacementUtil";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementText";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceOperatorAssignmentWithAssignmentExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceFragment";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpressionAndShorten";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatement";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatementAndShortenClassNames";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpressionWithReferenceTo";
                break;
            }
            case 20: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getElementText";
                break;
            }
            case 21: 
            case 25: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "replaceOperatorAssignmentWithAssignmentExpression";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpressionWithNegatedExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 21, 25 -> new IllegalStateException(string);
        };
    }
}

