/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PropertyUtilBase;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public final class BooleanParameterInspection
extends BaseInspection {
    public boolean onlyReportMultiple = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        int booleanParameterCount = (Integer)infos[1];
        if (booleanParameterCount == 1) {
            String string = method.isConstructor() ? InspectionGadgetsBundle.message("boolean.parameter.constructor.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("boolean.parameter.problem.descriptor", new Object[0]);
            if (string == null) {
                BooleanParameterInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = method.isConstructor() ? InspectionGadgetsBundle.message("boolean.parameters.constructor.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("boolean.parameters.problem.descriptor", new Object[0]);
        if (string == null) {
            BooleanParameterInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"onlyReportMultiple", (String)InspectionGadgetsBundle.message("boolean.parameter.only.report.multiple.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            BooleanParameterInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new BooleanParameterVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/abstraction/BooleanParameterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class BooleanParameterVisitor
    extends BaseInspectionVisitor {
        private BooleanParameterVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                BooleanParameterVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (!method.hasModifierProperty("public")) {
                return;
            }
            if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)method) || LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            int count = 0;
            for (PsiParameter parameter : parameters) {
                PsiType type = parameter.getType();
                if (PsiTypes.booleanType().equals((Object)type) && !MethodCallUtils.isUsedAsSuperConstructorCallArgument(parameter, true) && ++count > 1) break;
            }
            if (count == 0 || BooleanParameterInspection.this.onlyReportMultiple && count == 1) {
                return;
            }
            this.registerMethodError(method, method, count);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/abstraction/BooleanParameterInspection$BooleanParameterVisitor", "visitMethod"));
        }
    }
}

