/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.WeakestTypeFinder;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class DeclareCollectionAsInterfaceInspection
extends BaseInspection {
    public boolean ignoreLocalVariables = false;
    public boolean ignorePrivateMethodsAndFields = false;

    @NotNull
    public String getID() {
        return "CollectionDeclaredAsConcreteClass";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String type = (String)infos[0];
        String string = InspectionGadgetsBundle.message("collection.declared.by.class.problem.descriptor", type);
        if (string == null) {
            DeclareCollectionAsInterfaceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreLocalVariables", (String)InspectionGadgetsBundle.message("collection.declared.by.class.ignore.locals.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignorePrivateMethodsAndFields", (String)InspectionGadgetsBundle.message("collection.declared.by.class.ignore.private.members.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            DeclareCollectionAsInterfaceInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new DeclareCollectionAsInterfaceFix((String)infos[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new DeclareCollectionAsInterfaceVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/abstraction/DeclareCollectionAsInterfaceInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class DeclareCollectionAsInterfaceFix
    extends PsiUpdateModCommandQuickFix {
        private final String typeString;

        DeclareCollectionAsInterfaceFix(@NotNull String typeString) {
            if (typeString == null) {
                DeclareCollectionAsInterfaceFix.$$$reportNull$$$0(0);
            }
            this.typeString = typeString;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("declare.collection.as.interface.quickfix", this.typeString);
            if (string == null) {
                DeclareCollectionAsInterfaceFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("declare.collection.as.interface.fix.family.name", new Object[0]);
            if (string == null) {
                DeclareCollectionAsInterfaceFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement grandParent;
            PsiElement parent;
            if (project == null) {
                DeclareCollectionAsInterfaceFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                DeclareCollectionAsInterfaceFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                DeclareCollectionAsInterfaceFix.$$$reportNull$$$0(5);
            }
            if (!((parent = element.getParent()) instanceof PsiJavaCodeReferenceElement)) {
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)parent;
            StringBuilder newElementText = new StringBuilder(this.typeString);
            PsiReferenceParameterList parameterList = referenceElement.getParameterList();
            if (parameterList != null) {
                newElementText.append(parameterList.getText());
            }
            if (!((grandParent = parent.getParent()) instanceof PsiTypeElement)) {
                return;
            }
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(new CommentTracker().replaceAndRestoreComments(grandParent, newElementText.toString()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeString";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/abstraction/DeclareCollectionAsInterfaceInspection$DeclareCollectionAsInterfaceFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/abstraction/DeclareCollectionAsInterfaceInspection$DeclareCollectionAsInterfaceFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private class DeclareCollectionAsInterfaceVisitor
    extends BaseInspectionVisitor {
        private DeclareCollectionAsInterfaceVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            PsiType type;
            if (variable == null) {
                DeclareCollectionAsInterfaceVisitor.$$$reportNull$$$0(0);
            }
            if (this.isOnTheFly() && DeclarationSearchUtils.isTooExpensiveToSearch((PsiNamedElement)variable, false)) {
                this.registerPossibleProblem((PsiElement)variable.getNameIdentifier());
                return;
            }
            if (DeclareCollectionAsInterfaceInspection.this.ignoreLocalVariables && variable instanceof PsiLocalVariable) {
                return;
            }
            if (DeclareCollectionAsInterfaceInspection.this.ignorePrivateMethodsAndFields && variable instanceof PsiField && variable.hasModifierProperty("private")) {
                return;
            }
            if (variable instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)variable;
                PsiElement scope = parameter.getDeclarationScope();
                if (scope instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)scope;
                    if (DeclareCollectionAsInterfaceInspection.this.ignorePrivateMethodsAndFields && method.hasModifierProperty("private")) {
                        return;
                    }
                } else if (DeclareCollectionAsInterfaceInspection.this.ignoreLocalVariables) {
                    return;
                }
            }
            if (!CollectionUtils.isConcreteCollectionClass(type = variable.getType()) || LibraryUtil.isOverrideOfLibraryMethodParameter(variable)) {
                return;
            }
            this.checkToWeaken(type, variable.getTypeElement(), (PsiElement)variable);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                DeclareCollectionAsInterfaceVisitor.$$$reportNull$$$0(1);
            }
            super.visitMethod(method);
            if (DeclareCollectionAsInterfaceInspection.this.ignorePrivateMethodsAndFields && method.hasModifierProperty("private")) {
                return;
            }
            if (this.isOnTheFly() && DeclarationSearchUtils.isTooExpensiveToSearch((PsiNamedElement)method, false)) {
                this.registerPossibleProblem((PsiElement)method.getNameIdentifier());
                return;
            }
            PsiType type = method.getReturnType();
            if (!CollectionUtils.isConcreteCollectionClass(type) || LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            this.checkToWeaken(type, method.getReturnTypeElement(), (PsiElement)method);
        }

        private void checkToWeaken(PsiType type, PsiTypeElement typeElement, PsiElement variable) {
            String qualifiedName;
            if (typeElement == null) {
                return;
            }
            PsiJavaCodeReferenceElement reference = typeElement.getInnermostComponentReferenceElement();
            if (reference == null) {
                return;
            }
            PsiElement nameElement = reference.getReferenceNameElement();
            if (nameElement == null) {
                return;
            }
            Collection<PsiClass> weaklings = WeakestTypeFinder.calculateWeakestClassesNecessary(variable, false);
            if (weaklings.isEmpty()) {
                return;
            }
            PsiClassType javaLangObject = PsiType.getJavaLangObject((PsiManager)nameElement.getManager(), (GlobalSearchScope)nameElement.getResolveScope());
            ArrayList<PsiClass> weaklingList = new ArrayList<PsiClass>(weaklings);
            PsiClass objectClass = javaLangObject.resolve();
            weaklingList.remove(objectClass);
            String string = qualifiedName = weaklingList.isEmpty() ? CollectionUtils.getInterfaceForClass(type.getCanonicalText()) : ((PsiClass)weaklingList.get(0)).getQualifiedName();
            if (qualifiedName != null) {
                this.registerError(nameElement, qualifiedName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/abstraction/DeclareCollectionAsInterfaceInspection$DeclareCollectionAsInterfaceVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVariable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

