/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import org.jetbrains.annotations.NotNull;

public final class MethodOnlyUsedFromInnerClassInspection
extends BaseInspection {
    public boolean ignoreMethodsAccessedFromAnonymousClass = false;
    public boolean ignoreStaticMethodsFromNonStaticInnerClass = false;
    public boolean onlyReportStaticMethods = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String name;
        PsiClass containingClass = (PsiClass)infos[0];
        int ordinal = ClassUtils.getTypeOrdinal(containingClass);
        String string = name = containingClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)containingClass).getBaseClassReference().getText() : containingClass.getName();
        int innerClassType = containingClass instanceof PsiAnonymousClass ? 3 : (PsiUtil.isLocalClass((PsiClass)containingClass) ? 2 : 1);
        String string2 = InspectionGadgetsBundle.message("method.only.used.from.inner.class.problem.descriptor", innerClassType, ordinal, name);
        if (string2 == null) {
            MethodOnlyUsedFromInnerClassInspection.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreMethodsAccessedFromAnonymousClass", (String)InspectionGadgetsBundle.message("method.only.used.from.inner.class.ignore.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"onlyReportStaticMethods", (String)InspectionGadgetsBundle.message("only.report.static.methods", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            MethodOnlyUsedFromInnerClassInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new MethodOnlyUsedFromInnerClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/abstraction/MethodOnlyUsedFromInnerClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MethodOnlyUsedFromInnerClassVisitor
    extends BaseInspectionVisitor {
        private MethodOnlyUsedFromInnerClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiElement parent;
            if (method == null) {
                MethodOnlyUsedFromInnerClassVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (!method.hasModifierProperty("private") || method.isConstructor()) {
                return;
            }
            if (MethodOnlyUsedFromInnerClassInspection.this.onlyReportStaticMethods && !method.hasModifierProperty("static")) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (DeclarationSearchUtils.isTooExpensiveToSearch((PsiNamedElement)method, false)) {
                this.registerPossibleProblem((PsiElement)method.getNameIdentifier());
                return;
            }
            MethodReferenceFinder processor = new MethodReferenceFinder(method);
            PsiClass innerClass = processor.getOnlyAccessInnerClass();
            if (innerClass == null) {
                return;
            }
            if (method.hasModifierProperty("static") && !PsiUtil.isAvailable((JavaFeature)JavaFeature.INNER_STATICS, (PsiElement)method) && ((parent = innerClass.getParent()) instanceof PsiClass && !innerClass.hasModifierProperty("static") || PsiUtil.isLocalClass((PsiClass)innerClass))) {
                return;
            }
            if (MethodOnlyUsedFromInnerClassInspection.this.ignoreMethodsAccessedFromAnonymousClass && PsiUtil.isLocalOrAnonymousClass((PsiClass)innerClass)) {
                return;
            }
            this.registerMethodError(method, innerClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/abstraction/MethodOnlyUsedFromInnerClassInspection$MethodOnlyUsedFromInnerClassVisitor", "visitMethod"));
        }
    }

    private static class MethodReferenceFinder
    implements Processor<PsiReference> {
        private final PsiClass methodClass;
        private final PsiMethod method;
        private PsiClass myContainingClass;

        MethodReferenceFinder(@NotNull PsiMethod method) {
            if (method == null) {
                MethodReferenceFinder.$$$reportNull$$$0(0);
            }
            this.myContainingClass = null;
            this.method = method;
            this.methodClass = method.getContainingClass();
        }

        public boolean process(PsiReference reference) {
            PsiElement element = reference.getElement();
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            if (this.method.equals((Object)containingMethod)) {
                return true;
            }
            PsiClass containingClass = PsiUtil.getContainingClass((PsiElement)element);
            if (containingClass == null) {
                return false;
            }
            if (this.myContainingClass != null ? !this.myContainingClass.equals((Object)containingClass) : !PsiTreeUtil.isAncestor((PsiElement)this.methodClass, (PsiElement)containingClass, (boolean)true)) {
                return false;
            }
            this.myContainingClass = containingClass;
            return true;
        }

        public PsiClass getOnlyAccessInnerClass() {
            return ReferencesSearch.search((PsiElement)this.method).forEach((Processor)this) ? this.myContainingClass : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/abstraction/MethodOnlyUsedFromInnerClassInspection$MethodReferenceFinder", "<init>"));
        }
    }
}

