/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class OverlyStrongTypeCastInspection
extends BaseInspection {
    public boolean ignoreInMatchingInstanceof = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType expectedType = (PsiType)infos[0];
        String typeText = expectedType.getPresentableText();
        String string = InspectionGadgetsBundle.message("overly.strong.type.cast.problem.descriptor", typeText);
        if (string == null) {
            OverlyStrongTypeCastInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreInMatchingInstanceof", (String)InspectionGadgetsBundle.message("overly.strong.type.cast.ignore.in.matching.instanceof.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            OverlyStrongTypeCastInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new OverlyStrongCastFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new OverlyStrongTypeCastVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/abstraction/OverlyStrongTypeCastInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class OverlyStrongCastFix
    extends PsiUpdateModCommandQuickFix {
        private OverlyStrongCastFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("overly.strong.type.cast.weaken.quickfix", new Object[0]);
            if (string == null) {
                OverlyStrongCastFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement castTypeElement, @NotNull ModPsiUpdater updater) {
            PsiTypeCastExpression expression;
            if (project == null) {
                OverlyStrongCastFix.$$$reportNull$$$0(1);
            }
            if (castTypeElement == null) {
                OverlyStrongCastFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                OverlyStrongCastFix.$$$reportNull$$$0(3);
            }
            if ((expression = (PsiTypeCastExpression)castTypeElement.getParent()) == null) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression, true);
            if (expectedType == null) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            @NonNls String newExpression = "(" + expectedType.getCanonicalText() + ")" + commentTracker.text((PsiElement)operand);
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)expression, newExpression, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/abstraction/OverlyStrongTypeCastInspection$OverlyStrongCastFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "castTypeElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/abstraction/OverlyStrongTypeCastInspection$OverlyStrongCastFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class OverlyStrongTypeCastVisitor
    extends BaseInspectionVisitor {
        private OverlyStrongTypeCastVisitor() {
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            PsiArrayType arrayType;
            PsiType componentType;
            if (expression == null) {
                OverlyStrongTypeCastVisitor.$$$reportNull$$$0(0);
            }
            super.visitTypeCastExpression(expression);
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiType operandType = operand.getType();
            if (operandType == null) {
                return;
            }
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression, true);
            if (expectedType == null || expectedType.equals(type)) {
                return;
            }
            PsiClass resolved = PsiUtil.resolveClassInType((PsiType)expectedType);
            if (resolved != null && !resolved.isPhysical()) {
                return;
            }
            if (expectedType.isAssignableFrom(operandType) && !MethodCallUtils.isNecessaryForSurroundingMethodCall((PsiExpression)expression, operand)) {
                return;
            }
            if (TypeUtils.isTypeParameter(expectedType)) {
                return;
            }
            if (expectedType instanceof PsiArrayType && TypeUtils.isTypeParameter(componentType = (arrayType = (PsiArrayType)expectedType).getDeepComponentType())) {
                return;
            }
            if (type instanceof PsiPrimitiveType || expectedType instanceof PsiPrimitiveType) {
                return;
            }
            if (PsiPrimitiveType.getUnboxedType((PsiType)type) != null || PsiPrimitiveType.getUnboxedType((PsiType)expectedType) != null) {
                return;
            }
            if (expectedType instanceof PsiClassType) {
                PsiClassType classType;
                PsiClassType rawType;
                PsiClassType expectedClassType = (PsiClassType)expectedType;
                PsiClassType expectedRawType = expectedClassType.rawType();
                if (type.equals(expectedRawType)) {
                    return;
                }
                if (type instanceof PsiClassType && (rawType = (classType = (PsiClassType)type).rawType()).equals((Object)expectedRawType)) {
                    return;
                }
                if (type instanceof PsiArrayType) {
                    return;
                }
            }
            if (OverlyStrongTypeCastInspection.this.ignoreInMatchingInstanceof && InstanceOfUtils.hasAgreeingInstanceof(expression)) {
                return;
            }
            PsiTypeElement castTypeElement = expression.getCastType();
            if (castTypeElement == null) {
                return;
            }
            if (operand instanceof PsiFunctionalExpression) {
                if (!LambdaUtil.isFunctionalType((PsiType)expectedType)) {
                    return;
                }
                PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)expectedType);
                if (interfaceReturnType instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)interfaceReturnType) != null) {
                    return;
                }
            }
            this.registerError((PsiElement)castTypeElement, expectedType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/abstraction/OverlyStrongTypeCastInspection$OverlyStrongTypeCastVisitor", "visitTypeCastExpression"));
        }
    }
}

