/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.AddAnnotationModCommandAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public final class AssignmentToNullInspection
extends BaseInspection {
    public boolean ignoreAssignmentsToFields = false;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assignment.to.null.problem.descriptor", new Object[0]);
        if (string == null) {
            AssignmentToNullInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        Object info = infos[0];
        if (!(info instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)info;
        if (TypeUtils.isOptional(referenceExpression.getType())) {
            return null;
        }
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiVariable)) {
            return null;
        }
        PsiVariable variable = (PsiVariable)target;
        if (NullableNotNullManager.isNotNull((PsiModifierListOwner)variable)) {
            return null;
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)target.getProject());
        String annotation = manager.getDefaultAnnotation(Nullability.NULLABLE, (PsiElement)variable);
        if (JavaPsiFacade.getInstance((Project)variable.getProject()).findClass(annotation, variable.getResolveScope()) == null) {
            return null;
        }
        return LocalQuickFix.from((ModCommandAction)new AddAnnotationModCommandAction(annotation, (PsiModifierListOwner)variable, new String[0]));
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreAssignmentsToFields", (String)InspectionGadgetsBundle.message("assignment.to.null.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            AssignmentToNullInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentToNullVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/assignment/AssignmentToNullInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class AssignmentToNullVisitor
    extends BaseInspectionVisitor {
        private AssignmentToNullVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression value) {
            if (value == null) {
                AssignmentToNullVisitor.$$$reportNull$$$0(0);
            }
            super.visitLiteralExpression(value);
            String text = value.getText();
            if (!"null".equals(text)) {
                return;
            }
            PsiElement parent = value.getParent();
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiConditionalExpression || parent instanceof PsiTypeCastExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getLExpression());
            if (lhs == null || this.isReferenceToNullableVariable(lhs)) {
                return;
            }
            this.registerError((PsiElement)lhs, lhs);
        }

        private boolean isReferenceToNullableVariable(PsiExpression lhs) {
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement element = referenceExpression.resolve();
            if (!(element instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)element;
            if (AssignmentToNullInspection.this.ignoreAssignmentsToFields && variable instanceof PsiField) {
                return true;
            }
            return NullableNotNullManager.isNullable((PsiModifierListOwner)variable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/siyeh/ig/assignment/AssignmentToNullInspection$AssignmentToNullVisitor", "visitLiteralExpression"));
        }
    }
}

