/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class AssignmentToSuperclassFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)infos[0];
        PsiClass superclass = (PsiClass)infos[1];
        String string = InspectionGadgetsBundle.message("assignment.to.superclass.field.problem.descriptor", referenceExpression.getReferenceName(), superclass.getName());
        if (string == null) {
            AssignmentToSuperclassFieldInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentToSuperclassFieldVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/AssignmentToSuperclassFieldInspection", "buildErrorString"));
    }

    private static class AssignmentToSuperclassFieldVisitor
    extends BaseInspectionVisitor {
        private AssignmentToSuperclassFieldVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                AssignmentToSuperclassFieldVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(expression);
            PsiExpression lhs = expression.getLExpression();
            this.checkSuperclassField(lhs);
        }

        public void visitUnaryExpression(@NotNull PsiUnaryExpression expression) {
            if (expression == null) {
                AssignmentToSuperclassFieldVisitor.$$$reportNull$$$0(1);
            }
            super.visitUnaryExpression(expression);
            PsiExpression operand = expression.getOperand();
            this.checkSuperclassField(operand);
        }

        private void checkSuperclassField(PsiExpression expression) {
            if (!(expression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiExpression qualifierExpression = referenceExpression.getQualifierExpression();
            if (qualifierExpression != null && !(qualifierExpression instanceof PsiThisExpression) && !(qualifierExpression instanceof PsiSuperExpression)) {
                return;
            }
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            PsiClass fieldClass = field.getContainingClass();
            if (fieldClass == null) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            if (method == null || !method.isConstructor()) {
                return;
            }
            PsiClass assignmentClass = method.getContainingClass();
            String name = fieldClass.getQualifiedName();
            if (name == null || !InheritanceUtil.isInheritor((PsiClass)assignmentClass, (boolean)true, (String)name)) {
                return;
            }
            this.registerError((PsiElement)expression, referenceExpression, fieldClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/assignment/AssignmentToSuperclassFieldInspection$AssignmentToSuperclassFieldVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

