/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public final class ReplaceAssignmentWithOperatorAssignmentInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreLazyOperators = true;
    public boolean ignoreObscureOperators = false;

    @NotNull
    public String getID() {
        return "AssignmentReplaceableWithOperatorAssignment";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression lhs = (PsiExpression)infos[0];
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)infos[1];
        String string = InspectionGadgetsBundle.message("assignment.replaceable.with.operator.assignment.problem.descriptor", ReplaceAssignmentWithOperatorAssignmentInspection.calculateReplacementExpression(lhs, polyadicExpression, new CommentTracker()));
        if (string == null) {
            ReplaceAssignmentWithOperatorAssignmentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreLazyOperators", (String)InspectionGadgetsBundle.message("assignment.replaceable.with.operator.assignment.ignore.conditional.operators.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreObscureOperators", (String)InspectionGadgetsBundle.message("assignment.replaceable.with.operator.assignment.ignore.obscure.operators.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ReplaceAssignmentWithOperatorAssignmentInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    static String calculateReplacementExpression(PsiExpression lhs, PsiPolyadicExpression polyadicExpression, CommentTracker ct) {
        PsiExpression[] operands = polyadicExpression.getOperands();
        PsiJavaToken sign = polyadicExpression.getTokenBeforeOperand(operands[1]);
        String signText = sign.getText();
        if ("&&".equals(signText)) {
            signText = "&";
        } else if ("||".equals(signText)) {
            signText = "|";
        }
        StringBuilder text = new StringBuilder(ct.text((PsiElement)lhs));
        text.append(' ');
        text.append(signText);
        text.append("= ");
        boolean addToken = false;
        for (int i = 1; i < operands.length; ++i) {
            PsiExpression operand = operands[i];
            if (addToken) {
                PsiJavaToken token = polyadicExpression.getTokenBeforeOperand(operand);
                text.append(' ');
                if (token != null) {
                    text.append(token.getText());
                }
                text.append(' ');
            } else {
                addToken = true;
            }
            text.append(ct.text((PsiElement)operand));
        }
        return text.toString();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new ReplaceAssignmentWithOperatorAssignmentFix((PsiPolyadicExpression)infos[1]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ReplaceAssignmentWithOperatorAssignmentVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class ReplaceAssignmentWithOperatorAssignmentFix
    extends PsiUpdateModCommandQuickFix {
        @IntentionName
        private final String m_name;

        private ReplaceAssignmentWithOperatorAssignmentFix(PsiPolyadicExpression expression) {
            PsiJavaToken sign = expression.getTokenBeforeOperand(expression.getOperands()[1]);
            String signText = sign.getText();
            if ("&&".equals(signText)) {
                signText = "&";
            } else if ("||".equals(signText)) {
                signText = "|";
            }
            this.m_name = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"=", signText + "="});
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.simplify", (Object[])new Object[0]);
            if (string == null) {
                ReplaceAssignmentWithOperatorAssignmentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                ReplaceAssignmentWithOperatorAssignmentFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ReplaceAssignmentWithOperatorAssignmentFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceAssignmentWithOperatorAssignmentFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceAssignmentWithOperatorAssignmentFix.$$$reportNull$$$0(4);
            }
            if (!(element instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression expression = (PsiAssignmentExpression)element;
            PsiExpression lhs = expression.getLExpression();
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getRExpression());
            if (rhs instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)rhs;
                PsiType castType = typeCastExpression.getType();
                if (castType == null || !castType.equals(lhs.getType())) {
                    return;
                }
                rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)typeCastExpression.getOperand());
            }
            if (!(rhs instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)rhs;
            CommentTracker ct = new CommentTracker();
            String newExpression = ReplaceAssignmentWithOperatorAssignmentInspection.calculateReplacementExpression(lhs, polyadicExpression, ct);
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpression, ct);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private class ReplaceAssignmentWithOperatorAssignmentVisitor
    extends BaseInspectionVisitor {
        private ReplaceAssignmentWithOperatorAssignmentVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            if (assignment == null) {
                ReplaceAssignmentWithOperatorAssignmentVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(assignment);
            IElementType assignmentTokenType = assignment.getOperationTokenType();
            if (!assignmentTokenType.equals(JavaTokenType.EQ)) {
                return;
            }
            PsiExpression lhs = assignment.getLExpression();
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression());
            if (rhs instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)rhs;
                PsiType castType = typeCastExpression.getType();
                if (castType == null || !castType.equals(lhs.getType())) {
                    return;
                }
                rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)typeCastExpression.getOperand());
            }
            if (!(rhs instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)rhs;
            PsiExpression[] operands = polyadicExpression.getOperands();
            if (operands.length < 2) {
                return;
            }
            if (operands.length > 2 && !ParenthesesUtils.isAssociativeOperation(polyadicExpression)) {
                return;
            }
            for (PsiExpression operand : operands) {
                if (operand != null) continue;
                return;
            }
            IElementType expressionTokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.EQEQ.equals(expressionTokenType) || JavaTokenType.NE.equals(expressionTokenType)) {
                return;
            }
            if (ReplaceAssignmentWithOperatorAssignmentInspection.this.ignoreLazyOperators && (JavaTokenType.ANDAND.equals(expressionTokenType) || JavaTokenType.OROR.equals(expressionTokenType))) {
                return;
            }
            if (ReplaceAssignmentWithOperatorAssignmentInspection.this.ignoreObscureOperators && (JavaTokenType.XOR.equals(expressionTokenType) || JavaTokenType.PERC.equals(expressionTokenType))) {
                return;
            }
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(lhs, operands[0])) {
                return;
            }
            this.registerError((PsiElement)assignment, lhs, polyadicExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentVisitor", "visitAssignmentExpression"));
        }
    }
}

