/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ArrayEqualsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("equals.called.on.array.problem.descriptor", new Object[0]);
        if (string == null) {
            ArrayEqualsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        PsiType componentType;
        PsiArrayType type = (PsiArrayType)infos[0];
        if (type != null && (componentType = type.getComponentType()) instanceof PsiArrayType) {
            return new ArrayEqualsFix(true);
        }
        return new ArrayEqualsFix(false);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayEqualsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ArrayEqualsInspection", "buildErrorString"));
    }

    private static class ArrayEqualsFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean deepEquals;

        ArrayEqualsFix(boolean deepEquals) {
            this.deepEquals = deepEquals;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.deepEquals ? "Arrays.deepEquals()" : "Arrays.equals()"});
            if (string == null) {
                ArrayEqualsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"Arrays.equals()"});
            if (string == null) {
                ArrayEqualsFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ArrayEqualsFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ArrayEqualsFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ArrayEqualsFix.$$$reportNull$$$0(4);
            }
            PsiIdentifier name = (PsiIdentifier)element;
            PsiReferenceExpression expression = (PsiReferenceExpression)name.getParent();
            assert (expression != null);
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression.getParent();
            PsiExpression qualifier = expression.getQualifierExpression();
            assert (qualifier != null);
            CommentTracker commentTracker = new CommentTracker();
            String qualifierText = commentTracker.text((PsiElement)qualifier);
            assert (call != null);
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            String argumentText = commentTracker.text((PsiElement)arguments[0]);
            @NonNls StringBuilder newExpressionText = new StringBuilder();
            if (this.deepEquals) {
                newExpressionText.append("java.util.Arrays.deepEquals(");
            } else {
                newExpressionText.append("java.util.Arrays.equals(");
            }
            newExpressionText.append(qualifierText);
            newExpressionText.append(", ");
            newExpressionText.append(argumentText);
            newExpressionText.append(')');
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)call, newExpressionText.toString(), commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/ArrayEqualsInspection$ArrayEqualsFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/ArrayEqualsInspection$ArrayEqualsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ArrayEqualsVisitor
    extends BaseInspectionVisitor {
        private ArrayEqualsVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                ArrayEqualsVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (argument == null) {
                return;
            }
            PsiType argumentType = argument.getType();
            if (!(argumentType instanceof PsiArrayType)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType qualifierType = qualifier.getType();
            if (!(qualifierType instanceof PsiArrayType)) {
                return;
            }
            this.registerMethodCallError(expression, qualifierType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/ArrayEqualsInspection$ArrayEqualsVisitor", "visitMethodCallExpression"));
        }
    }
}

