/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class ArrayObjectsEqualsInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Kind kind = (Kind)((Object)infos[0]);
        String string = kind.toString();
        if (string == null) {
            ArrayObjectsEqualsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        Kind kind = (Kind)((Object)infos[0]);
        return new ArrayEqualsHashCodeFix(kind);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayObjectsEqualsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ArrayObjectsEqualsInspection", "buildErrorString"));
    }

    static enum Kind {
        TO_EQUALS("equals", "array.equals.problem.descriptor"),
        TO_DEEP_EQUALS("deepEquals", "array.equals.problem.descriptor"),
        TO_DEEP_HASH_CODE("deepHashCode", "array.hashcode.problem.descriptor");

        private final String myNewMethodName;
        @PropertyKey(resourceBundle="messages.InspectionGadgetsBundle")
        private final @PropertyKey(resourceBundle="messages.InspectionGadgetsBundle") String myMessage;

        private Kind(String newMethodName, String message) {
            this.myNewMethodName = newMethodName;
            this.myMessage = message;
        }

        @InspectionMessage
        public String toString() {
            return InspectionGadgetsBundle.message(this.myMessage, "Arrays." + this.myNewMethodName + "()");
        }

        public String getNewMethodName() {
            return this.myNewMethodName;
        }
    }

    private static class ArrayEqualsHashCodeFix
    extends PsiUpdateModCommandQuickFix {
        private final Kind myKind;

        ArrayEqualsHashCodeFix(Kind kind) {
            this.myKind = kind;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"Arrays." + this.myKind.myNewMethodName + "()"});
            if (string == null) {
                ArrayEqualsHashCodeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                ArrayEqualsHashCodeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiElement element;
            if (project == null) {
                ArrayEqualsHashCodeFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                ArrayEqualsHashCodeFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ArrayEqualsHashCodeFix.$$$reportNull$$$0(4);
            }
            if (!((element = startElement.getParent().getParent()) instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
            CommentTracker commentTracker = new CommentTracker();
            String newExpression = "java.util.Arrays." + this.myKind.getNewMethodName() + commentTracker.text((PsiElement)methodCallExpression.getArgumentList());
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, newExpression, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/ArrayObjectsEqualsInspection$ArrayEqualsHashCodeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/ArrayObjectsEqualsInspection$ArrayEqualsHashCodeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ArrayObjectsEqualsVisitor
    extends BaseInspectionVisitor {
        private ArrayObjectsEqualsVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiMethod method;
            if (expression == null) {
                ArrayObjectsEqualsVisitor.$$$reportNull$$$0(0);
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] expressions = argumentList.getExpressions();
            if (!(expressions.length == 1 && "hashCode".equals(methodName) || expressions.length == 2 && "equals".equals(methodName))) {
                return;
            }
            PsiExpression argument1 = expressions[0];
            PsiType type1 = argument1.getType();
            if (!(type1 instanceof PsiArrayType)) {
                return;
            }
            int dimensions = type1.getArrayDimensions();
            if (expressions.length == 2) {
                PsiExpression argument2 = expressions[1];
                PsiType type2 = argument2.getType();
                if (!(type2 instanceof PsiArrayType)) {
                    return;
                }
                if (dimensions != type2.getArrayDimensions()) {
                    return;
                }
            }
            if ((method = expression.resolveMethod()) == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            Kind kind = ArrayObjectsEqualsVisitor.getKind(containingClass.getQualifiedName(), methodName, dimensions);
            if (kind == null) {
                return;
            }
            this.registerMethodCallError(expression, new Object[]{kind});
        }

        private static Kind getKind(String className, String methodName, int dimensions) {
            boolean isJavaUtilObjects = "java.util.Objects".equals(className);
            boolean isJavaUtilArrays = "java.util.Arrays".equals(className);
            boolean isEquals = "equals".equals(methodName);
            boolean isHashCode = "hashCode".equals(methodName);
            if (isJavaUtilObjects && isEquals) {
                return dimensions > 1 ? Kind.TO_DEEP_EQUALS : Kind.TO_EQUALS;
            }
            if (isJavaUtilArrays && dimensions > 1) {
                if (isEquals) {
                    return Kind.TO_DEEP_EQUALS;
                }
                if (isHashCode) {
                    return Kind.TO_DEEP_HASH_CODE;
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/ArrayObjectsEqualsInspection$ArrayObjectsEqualsVisitor", "visitMethodCallExpression"));
        }
    }
}

