/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import org.jetbrains.annotations.NotNull;

public final class CastConflictsWithInstanceofInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String castExpressionType = ((PsiTypeElement)infos[1]).getText();
        String instanceofType = ((PsiTypeElement)infos[2]).getText();
        String string = InspectionGadgetsBundle.message("cast.conflicts.with.instanceof.problem.descriptor", castExpressionType, instanceofType);
        if (string == null) {
            CastConflictsWithInstanceofInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix @NotNull [] buildFixes(Object ... infos) {
        String castExpressionType = ((PsiTypeElement)infos[1]).getText();
        String instanceofType = ((PsiTypeElement)infos[2]).getText();
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ReplaceCastFix(instanceofType, castExpressionType), new ReplaceInstanceofFix(instanceofType, castExpressionType)};
        if (localQuickFixArray == null) {
            CastConflictsWithInstanceofInspection.$$$reportNull$$$0(1);
        }
        return localQuickFixArray;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new CastConflictsWithInstanceofVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/CastConflictsWithInstanceofInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ReplaceCastFix
    extends ReplaceFix {
        private final String myInstanceofType;
        private final String myCastType;

        ReplaceCastFix(String instanceofType, String castType) {
            this.myInstanceofType = instanceofType;
            this.myCastType = castType;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("cast.conflicts.with.instanceof.quickfix1", this.myCastType, this.myInstanceofType);
            if (string == null) {
                ReplaceCastFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("replace.cast.fix.family.name", new Object[0]);
            if (string == null) {
                ReplaceCastFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected PsiElement replace(PsiTypeElement castTypeElement, PsiTypeElement instanceofTypeElement) {
            return castTypeElement.replace((PsiElement)instanceofTypeElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/bugs/CastConflictsWithInstanceofInspection$ReplaceCastFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class ReplaceInstanceofFix
    extends ReplaceFix {
        private final String myInstanceofType;
        private final String myCastType;

        ReplaceInstanceofFix(String instanceofType, String castType) {
            this.myInstanceofType = instanceofType;
            this.myCastType = castType;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("replace.instanceof.fix.family.name", new Object[0]);
            if (string == null) {
                ReplaceInstanceofFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("cast.conflicts.with.instanceof.quickfix2", this.myInstanceofType, this.myCastType);
            if (string == null) {
                ReplaceInstanceofFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected PsiElement replace(PsiTypeElement castTypeElement, PsiTypeElement instanceofTypeElement) {
            return instanceofTypeElement.replace((PsiElement)castTypeElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/bugs/CastConflictsWithInstanceofInspection$ReplaceInstanceofFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class CastConflictsWithInstanceofVisitor
    extends BaseInspectionVisitor {
        private CastConflictsWithInstanceofVisitor() {
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            if (expression == null) {
                CastConflictsWithInstanceofVisitor.$$$reportNull$$$0(0);
            }
            super.visitTypeCastExpression(expression);
            PsiTypeElement castType = expression.getCastType();
            if (castType == null) {
                return;
            }
            PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getOperand());
            if (!(operand instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand;
            PsiType castType1 = castType.getType();
            PsiInstanceOfExpression conflictingInstanceof = InstanceOfUtils.getConflictingInstanceof(castType1, referenceExpression, (PsiElement)expression);
            if (conflictingInstanceof == null) {
                return;
            }
            PsiTypeElement instanceofTypeElement = conflictingInstanceof.getCheckType();
            if (instanceofTypeElement == null) {
                return;
            }
            PsiType psiType = TypeConstraint.fromDfType(CommonDataflow.getDfType(operand)).getPsiType(operand.getProject());
            if (psiType != null && castType1.isAssignableFrom(psiType)) {
                return;
            }
            this.registerError((PsiElement)expression, referenceExpression, castType, instanceofTypeElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/CastConflictsWithInstanceofInspection$CastConflictsWithInstanceofVisitor", "visitTypeCastExpression"));
        }
    }

    private static abstract class ReplaceFix
    extends PsiUpdateModCommandQuickFix {
        protected ReplaceFix() {
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiReferenceExpression reference;
            PsiTypeElement castTypeElement;
            if (project == null) {
                ReplaceFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                ReplaceFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                ReplaceFix.$$$reportNull$$$0(2);
            }
            if (element instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)element;
                castTypeElement = typeCastExpression.getCastType();
                PsiExpression operand = typeCastExpression.getOperand();
                if (!(operand instanceof PsiReferenceExpression)) {
                    return;
                }
                reference = (PsiReferenceExpression)operand;
            } else if (element instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiClassObjectAccessExpression)) {
                    return;
                }
                PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)qualifier;
                castTypeElement = classObjectAccessExpression.getOperand();
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                PsiExpression[] arguments = argumentList.getExpressions();
                if (arguments.length != 1) {
                    return;
                }
                PsiExpression argument = arguments[0];
                if (!(argument instanceof PsiReferenceExpression)) {
                    return;
                }
                reference = (PsiReferenceExpression)argument;
            } else {
                return;
            }
            if (castTypeElement == null) {
                return;
            }
            PsiInstanceOfExpression conflictingInstanceof = InstanceOfUtils.getConflictingInstanceof(castTypeElement.getType(), reference, element);
            if (conflictingInstanceof == null) {
                return;
            }
            PsiTypeElement instanceofTypeElement = conflictingInstanceof.getCheckType();
            if (instanceofTypeElement == null) {
                return;
            }
            PsiElement newElement = this.replace(castTypeElement, instanceofTypeElement);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            codeStyleManager.shortenClassReferences(newElement);
        }

        protected abstract PsiElement replace(PsiTypeElement var1, PsiTypeElement var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "updater";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/bugs/CastConflictsWithInstanceofInspection$ReplaceFix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

