/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.BaseEqualsVisitor;
import com.siyeh.ig.psiutils.InconvertibleTypesChecker;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class EqualsBetweenInconvertibleTypesInspection
extends BaseInspection {
    public boolean WARN_IF_NO_MUTUAL_SUBCLASS_FOUND = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"WARN_IF_NO_MUTUAL_SUBCLASS_FOUND", (String)InspectionGadgetsBundle.message("equals.between.inconvertible.types.mutual.subclass.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            EqualsBetweenInconvertibleTypesInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType comparedType = (PsiType)infos[0];
        PsiType comparisonType = (PsiType)infos[1];
        boolean convertible = (Boolean)infos[2];
        if (convertible) {
            String string = InspectionGadgetsBundle.message("equals.between.inconvertible.types.no.mutual.subclass.problem.descriptor", comparedType.getPresentableText(), comparisonType.getPresentableText());
            if (string == null) {
                EqualsBetweenInconvertibleTypesInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("equals.between.inconvertible.types.problem.descriptor", comparedType.getPresentableText(), comparisonType.getPresentableText());
        if (string == null) {
            EqualsBetweenInconvertibleTypesInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsBetweenInconvertibleTypesVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/EqualsBetweenInconvertibleTypesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class EqualsBetweenInconvertibleTypesVisitor
    extends BaseEqualsVisitor {
        private EqualsBetweenInconvertibleTypesVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                EqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.EQEQ) && !tokenType.equals(JavaTokenType.NE)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiType lhsType = lhs.getType();
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiType rhsType = rhs.getType();
            if (lhsType == null || rhsType == null || TypeConversionUtil.isPrimitiveAndNotNull((PsiType)lhsType) || TypeConversionUtil.isPrimitiveAndNotNull((PsiType)rhsType) || !TypeUtils.areConvertible(lhsType, rhsType)) {
                return;
            }
            if (LambdaUtil.notInferredType((PsiType)lhsType) || LambdaUtil.notInferredType((PsiType)rhsType)) {
                return;
            }
            InconvertibleTypesChecker.TypeMismatch mismatch = InconvertibleTypesChecker.deepCheck(lhsType, rhsType, this.getMutualSubclassMode());
            if (mismatch != null) {
                this.registerError((PsiElement)expression.getOperationSign(), mismatch);
            }
        }

        private void registerError(@NotNull PsiElement anchor, @NotNull InconvertibleTypesChecker.TypeMismatch mismatch) {
            InconvertibleTypesChecker.Convertible convertible;
            if (anchor == null) {
                EqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(1);
            }
            if (mismatch == null) {
                EqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(2);
            }
            if ((convertible = mismatch.isConvertible()) == InconvertibleTypesChecker.Convertible.CONVERTIBLE_MUTUAL_SUBCLASS_UNKNOWN) {
                this.registerPossibleProblem(anchor);
            } else {
                this.registerError(anchor, mismatch.getLeft(), mismatch.getRight(), convertible != InconvertibleTypesChecker.Convertible.NOT_CONVERTIBLE);
            }
        }

        private InconvertibleTypesChecker.LookForMutualSubclass getMutualSubclassMode() {
            if (!EqualsBetweenInconvertibleTypesInspection.this.WARN_IF_NO_MUTUAL_SUBCLASS_FOUND) {
                return InconvertibleTypesChecker.LookForMutualSubclass.NEVER;
            }
            return this.isOnTheFly() ? InconvertibleTypesChecker.LookForMutualSubclass.IF_CHEAP : InconvertibleTypesChecker.LookForMutualSubclass.ALWAYS;
        }

        @Override
        public boolean checkTypes(@NotNull PsiReferenceExpression expression, @NotNull PsiType leftType, @NotNull PsiType rightType) {
            InconvertibleTypesChecker.TypeMismatch mismatch;
            if (expression == null) {
                EqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(3);
            }
            if (leftType == null) {
                EqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(4);
            }
            if (rightType == null) {
                EqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(5);
            }
            if ((mismatch = InconvertibleTypesChecker.checkTypes(leftType, rightType, this.getMutualSubclassMode())) != null) {
                this.registerError(Objects.requireNonNull(expression.getReferenceNameElement()), mismatch);
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mismatch";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftType";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightType";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/EqualsBetweenInconvertibleTypesInspection$EqualsBetweenInconvertibleTypesVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBinaryExpression";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerError";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkTypes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

