/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImplicitArrayToStringInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (((Boolean)infos[1]).booleanValue()) {
            String string = InspectionGadgetsBundle.message("explicit.array.to.string.problem.descriptor", new Object[0]);
            if (string == null) {
                ImplicitArrayToStringInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (infos[0] instanceof PsiMethodCallExpression) {
            String string = InspectionGadgetsBundle.message("implicit.array.to.string.method.call.problem.descriptor", new Object[0]);
            if (string == null) {
                ImplicitArrayToStringInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("implicit.array.to.string.problem.descriptor", new Object[0]);
        if (string == null) {
            ImplicitArrayToStringInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiType componentType;
        PsiExpression expression = (PsiExpression)infos[0];
        boolean removeToString = (Boolean)infos[1];
        PsiArrayType type = (PsiArrayType)expression.getType();
        if (type != null && (componentType = type.getComponentType()) instanceof PsiArrayType) {
            return new ImplicitArrayToStringFix(true, removeToString);
        }
        return new ImplicitArrayToStringFix(false, removeToString);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ImplicitArrayToStringVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ImplicitArrayToStringInspection", "buildErrorString"));
    }

    private static class ImplicitArrayToStringFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean deepString;
        private final boolean removeToString;

        ImplicitArrayToStringFix(boolean deepString, boolean removeToString) {
            this.deepString = deepString;
            this.removeToString = removeToString;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("implicit.array.to.string.fix.family.name", new Object[0]);
            if (string == null) {
                ImplicitArrayToStringFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getName() {
            @NonNls String expressionText = this.deepString ? "java.util.Arrays.deepToString()" : "java.util.Arrays.toString()";
            String string = InspectionGadgetsBundle.message("implicit.array.to.string.quickfix", expressionText);
            if (string == null) {
                ImplicitArrayToStringFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiMethodCallExpression methodCallExpression;
            PsiReferenceExpression methodExpression;
            PsiElement grandParent;
            String expressionText;
            if (project == null) {
                ImplicitArrayToStringFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ImplicitArrayToStringFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ImplicitArrayToStringFix.$$$reportNull$$$0(4);
            }
            PsiExpression expression = element instanceof PsiExpression ? (PsiExpression)element : (PsiExpression)element.getParent().getParent();
            CommentTracker commentTracker = new CommentTracker();
            if (this.removeToString) {
                PsiMethodCallExpression methodCallExpression2 = (PsiMethodCallExpression)expression;
                PsiReferenceExpression methodExpression2 = methodCallExpression2.getMethodExpression();
                PsiExpression qualifier = methodExpression2.getQualifierExpression();
                if (qualifier == null) {
                    return;
                }
                expressionText = commentTracker.text((PsiElement)qualifier);
            } else {
                expressionText = commentTracker.text((PsiElement)expression);
            }
            @NonNls String newExpressionText = this.deepString ? "java.util.Arrays.deepToString(" + expressionText + ")" : "java.util.Arrays.toString(" + expressionText + ")";
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiExpressionList && (grandParent = parent.getParent()) instanceof PsiMethodCallExpression && "valueOf".equals((methodExpression = (methodCallExpression = (PsiMethodCallExpression)grandParent).getMethodExpression()).getReferenceName())) {
                PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, newExpressionText, commentTracker);
                return;
            }
            PsiReplacementUtil.replaceExpressionAndShorten(expression, newExpressionText, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/ImplicitArrayToStringInspection$ImplicitArrayToStringFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/ImplicitArrayToStringInspection$ImplicitArrayToStringFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ImplicitArrayToStringVisitor
    extends BaseInspectionVisitor {
        private ImplicitArrayToStringVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                ImplicitArrayToStringVisitor.$$$reportNull$$$0(0);
            }
            super.visitReferenceExpression(expression);
            if (!ImplicitArrayToStringVisitor.isImplicitArrayToStringCall((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression, Boolean.FALSE);
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                ImplicitArrayToStringVisitor.$$$reportNull$$$0(1);
            }
            super.visitNewExpression(expression);
            if (!ImplicitArrayToStringVisitor.isImplicitArrayToStringCall((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression, Boolean.FALSE);
        }

        public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expression) {
            if (expression == null) {
                ImplicitArrayToStringVisitor.$$$reportNull$$$0(2);
            }
            super.visitArrayAccessExpression(expression);
            if (!ImplicitArrayToStringVisitor.isImplicitArrayToStringCall((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression, Boolean.FALSE);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                ImplicitArrayToStringVisitor.$$$reportNull$$$0(3);
            }
            super.visitMethodCallExpression(expression);
            if (ImplicitArrayToStringVisitor.isExplicitArrayToStringCall(expression)) {
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                this.registerMethodCallError(expression, qualifier, Boolean.TRUE);
                return;
            }
            if (!ImplicitArrayToStringVisitor.isImplicitArrayToStringCall((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression, Boolean.FALSE);
        }

        private static boolean isExplicitArrayToStringCall(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"toString".equals(methodName) || !expression.getArgumentList().isEmpty()) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType type = qualifier.getType();
            return type instanceof PsiArrayType;
        }

        private static boolean isImplicitArrayToStringCall(PsiExpression expression) {
            return ExpressionUtils.isImplicitToStringCall(expression) && expression.getType() instanceof PsiArrayType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/bugs/ImplicitArrayToStringInspection$ImplicitArrayToStringVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArrayAccessExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

