/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.util.ArrayUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public final class IncorrectDateTimeFormatInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Map<Character, BiFunction<Character, Integer, String>> ALLOWED_DATE_TIME_FORMATTER = Map.ofEntries(Map.entry(Character.valueOf('G'), IncorrectDateTimeFormatInspection.rangeOf(1, 5)), Map.entry(Character.valueOf('u'), IncorrectDateTimeFormatInspection.rangeOf(1, 19)), Map.entry(Character.valueOf('y'), IncorrectDateTimeFormatInspection.rangeOf(1, 19)), Map.entry(Character.valueOf('Y'), IncorrectDateTimeFormatInspection.rangeOf(1, Integer.MAX_VALUE)), Map.entry(Character.valueOf('Q'), IncorrectDateTimeFormatInspection.rangeOf(1, 5)), Map.entry(Character.valueOf('q'), IncorrectDateTimeFormatInspection.rangeOf(1, 5)), Map.entry(Character.valueOf('M'), IncorrectDateTimeFormatInspection.rangeOf(1, 5)), Map.entry(Character.valueOf('L'), IncorrectDateTimeFormatInspection.rangeOf(1, 5)), Map.entry(Character.valueOf('w'), IncorrectDateTimeFormatInspection.rangeOf(1, 2)), Map.entry(Character.valueOf('W'), IncorrectDateTimeFormatInspection.rangeOf(1, 1)), Map.entry(Character.valueOf('d'), IncorrectDateTimeFormatInspection.rangeOf(1, 2)), Map.entry(Character.valueOf('D'), IncorrectDateTimeFormatInspection.rangeOf(1, 3)), Map.entry(Character.valueOf('F'), IncorrectDateTimeFormatInspection.rangeOf(1, 1)), Map.entry(Character.valueOf('g'), IncorrectDateTimeFormatInspection.rangeOf(1, 19)), Map.entry(Character.valueOf('E'), IncorrectDateTimeFormatInspection.rangeOf(1, 5)), Map.entry(Character.valueOf('e'), IncorrectDateTimeFormatInspection.rangeOf(1, 5)), Map.entry(Character.valueOf('c'), IncorrectDateTimeFormatInspection.rangeOf(1, 5)), Map.entry(Character.valueOf('a'), IncorrectDateTimeFormatInspection.rangeOf(1, 1)), Map.entry(Character.valueOf('h'), IncorrectDateTimeFormatInspection.rangeOf(1, 2)), Map.entry(Character.valueOf('H'), IncorrectDateTimeFormatInspection.rangeOf(1, 2)), Map.entry(Character.valueOf('k'), IncorrectDateTimeFormatInspection.rangeOf(1, 2)), Map.entry(Character.valueOf('K'), IncorrectDateTimeFormatInspection.rangeOf(1, 2)), Map.entry(Character.valueOf('m'), IncorrectDateTimeFormatInspection.rangeOf(1, 2)), Map.entry(Character.valueOf('s'), IncorrectDateTimeFormatInspection.rangeOf(1, 2)), Map.entry(Character.valueOf('S'), IncorrectDateTimeFormatInspection.rangeOf(1, 9)), Map.entry(Character.valueOf('A'), IncorrectDateTimeFormatInspection.rangeOf(1, 19)), Map.entry(Character.valueOf('n'), IncorrectDateTimeFormatInspection.rangeOf(1, 19)), Map.entry(Character.valueOf('N'), IncorrectDateTimeFormatInspection.rangeOf(1, 19)), Map.entry(Character.valueOf('B'), IncorrectDateTimeFormatInspection.setOf(1, 4, 5)), Map.entry(Character.valueOf('V'), IncorrectDateTimeFormatInspection.rangeOf(2, 2)), Map.entry(Character.valueOf('v'), IncorrectDateTimeFormatInspection.setOf(1, 4)), Map.entry(Character.valueOf('z'), IncorrectDateTimeFormatInspection.rangeOf(1, 4)), Map.entry(Character.valueOf('O'), IncorrectDateTimeFormatInspection.setOf(1, 4)), Map.entry(Character.valueOf('X'), IncorrectDateTimeFormatInspection.rangeOf(1, 5)), Map.entry(Character.valueOf('x'), IncorrectDateTimeFormatInspection.rangeOf(1, 5)), Map.entry(Character.valueOf('Z'), IncorrectDateTimeFormatInspection.rangeOf(1, 5)));
    private static final CallMatcher PATTERN_METHODS = CallMatcher.anyOf(CallMatcher.staticCall("java.time.format.DateTimeFormatter", "ofPattern"), CallMatcher.instanceCall("java.time.format.DateTimeFormatterBuilder", "appendPattern").parameterTypes("java.lang.String"));

    private static BiFunction<Character, Integer, String> rangeOf(int from, int to) {
        return (letter, count) -> {
            if (count < from) {
                return InspectionGadgetsBundle.message("inspection.incorrect.date.format.too.few.letters", letter, from, count);
            }
            if (count > to) {
                return InspectionGadgetsBundle.message("inspection.incorrect.date.format.too.many.letters", letter, to, count);
            }
            return null;
        };
    }

    private static BiFunction<Character, Integer, String> setOf(int ... numbers) {
        return (letter, count) -> {
            if (ArrayUtil.indexOf((int[])numbers, (int)count) >= 0) {
                return null;
            }
            String expected = StringUtil.join((int[])numbers, (String)", ");
            return InspectionGadgetsBundle.message("inspection.incorrect.date.format.wrong.number.of.letters", letter, expected, count);
        };
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            IncorrectDateTimeFormatInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PATTERN_METHODS.test(call)) {
                    this.processExpression(call.getArgumentList().getExpressions()[0]);
                }
            }

            private void processExpression(@NotNull PsiExpression expression) {
                Object patternObject;
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!((patternObject = ExpressionUtils.computeConstantExpression(expression)) instanceof String)) {
                    return;
                }
                String pattern = (String)patternObject;
                record Token(char character, int pos, int length) {
                }
                ArrayList<Token> tokens = new ArrayList<Token>();
                int optionalDepth = 0;
                char[] array = pattern.toCharArray();
                boolean inQuote = false;
                int lastQuoteIndex = 0;
                int length = 0;
                for (int pos = 0; pos < array.length; ++pos) {
                    char c = array[pos];
                    if (!inQuote && 1.isLetter(c)) {
                        ++length;
                        if (pos != array.length - 1 && c == array[pos + 1]) continue;
                        tokens.add(new Token(c, pos - length + 1, length));
                        this.checkPadding(expression, array, pos - length + 1, pos + 1);
                    }
                    length = 0;
                    if (c == '\'') {
                        inQuote = !inQuote;
                        lastQuoteIndex = pos;
                        continue;
                    }
                    if (inQuote) continue;
                    this.checkUnsupportedSymbolsProblem(expression, pos, c);
                    if (c == '[') {
                        ++optionalDepth;
                    }
                    if (c != ']') continue;
                    this.checkOptionalDepthProblem(expression, --optionalDepth, pos);
                    if (optionalDepth >= 0) continue;
                    optionalDepth = 0;
                }
                this.checkInQuoteProblem(expression, inQuote, lastQuoteIndex);
                for (Token token : tokens) {
                    this.checkAvailableCount(expression, token.character, token.pos, token.length);
                }
            }

            private void checkOptionalDepthProblem(@NotNull PsiExpression expression, int optionalDepth, int pos) {
                if (expression == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (optionalDepth < 0) {
                    holder.registerProblem((PsiElement)expression, ExpressionUtils.findStringLiteralRange(expression, pos, pos + 1), InspectionGadgetsBundle.message("inspection.incorrect.date.format.message.unpaired", Character.valueOf('[')), new LocalQuickFix[0]);
                }
            }

            private void checkInQuoteProblem(@NotNull PsiExpression expression, boolean inQuote, int pos) {
                if (expression == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (inQuote) {
                    holder.registerProblem((PsiElement)expression, ExpressionUtils.findStringLiteralRange(expression, pos, pos + 1), InspectionGadgetsBundle.message("inspection.incorrect.date.format.message.literal", Character.valueOf('\'')), new LocalQuickFix[0]);
                }
            }

            private void checkUnsupportedSymbolsProblem(@NotNull PsiExpression expression, int pos, char c) {
                if (expression == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (c == '{' || c == '}' || c == '#') {
                    holder.registerProblem((PsiElement)expression, ExpressionUtils.findStringLiteralRange(expression, pos, pos + 1), InspectionGadgetsBundle.message("inspection.incorrect.date.format.message.reserved.character", Character.valueOf(c)), new LocalQuickFix[0]);
                }
            }

            private void checkPadding(@NotNull PsiExpression expression, char[] array, int from, int to) {
                if (expression == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (!(array[from] != 'p' || to < array.length && 1.isLetter(array[to]))) {
                    holder.registerProblem((PsiElement)expression, ExpressionUtils.findStringLiteralRange(expression, from, to), InspectionGadgetsBundle.message("inspection.incorrect.date.format.message.padding", Character.valueOf('p')), new LocalQuickFix[0]);
                }
            }

            private static boolean isLetter(char c) {
                return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
            }

            private void checkAvailableCount(PsiExpression expression, char character, int pos, int length) {
                if (character == 'p') {
                    return;
                }
                BiFunction<Character, Integer, @InspectionMessage String> verifier = ALLOWED_DATE_TIME_FORMATTER.get(Character.valueOf(character));
                if (verifier == null) {
                    holder.registerProblem((PsiElement)expression, ExpressionUtils.findStringLiteralRange(expression, pos, pos + length), InspectionGadgetsBundle.message("inspection.incorrect.date.format.message.unsupported", Character.valueOf(character)), new LocalQuickFix[0]);
                } else {
                    String message = verifier.apply(Character.valueOf(character), length);
                    if (message != null) {
                        TextRange range = ExpressionUtils.findStringLiteralRange(expression, pos, pos + length);
                        holder.registerProblem((PsiElement)expression, range, message, new LocalQuickFix[0]);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/bugs/IncorrectDateTimeFormatInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkOptionalDepthProblem";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkInQuoteProblem";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkUnsupportedSymbolsProblem";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkPadding";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/siyeh/ig/bugs/IncorrectDateTimeFormatInspection", "buildVisitor"));
    }
}

