/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.java.PsiEmptyExpressionImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.format.MessageFormatUtil;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.MethodMatcher;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IncorrectMessageFormatInspection
extends AbstractBaseJavaLocalInspectionTool {
    public MethodMatcher myMethodMatcher = new MethodMatcher().finishDefault();

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{this.myMethodMatcher.getTable(InspectionGadgetsBundle.message("inspection.incorrect.message.custom.classes.methods", new Object[0])).prefix("myMethodMatcher")});
        if (optPane == null) {
            IncorrectMessageFormatInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    private boolean isCustomPatternMethodCall(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            IncorrectMessageFormatInspection.$$$reportNull$$$0(1);
        }
        if (!this.myMethodMatcher.matches((PsiCall)call)) {
            return false;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != 2) {
            return false;
        }
        PsiType firstArgType = parameters[0].getType();
        if (!"java.lang.String".equals(firstArgType.getCanonicalText())) {
            return false;
        }
        PsiParameter secondParameter = parameters[1];
        return secondParameter.isVarArgs();
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            IncorrectMessageFormatInspection.$$$reportNull$$$0(2);
        }
        super.readSettings(element);
        this.myMethodMatcher.readSettings(element);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            IncorrectMessageFormatInspection.$$$reportNull$$$0(3);
        }
        super.writeSettings(element);
        this.myMethodMatcher.writeSettings(element);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            IncorrectMessageFormatInspection.$$$reportNull$$$0(4);
        }
        return new JavaElementVisitor(){

            public void visitNewExpression(@NotNull PsiNewExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ConstructionUtils.isReferenceTo(expression.getClassReference(), "java.text.MessageFormat")) {
                    PsiMethod method = expression.resolveMethod();
                    if (method == null || !method.isConstructor()) {
                        return;
                    }
                    PsiParameterList parameterList = method.getParameterList();
                    if (parameterList.getParametersCount() < 1) {
                        return;
                    }
                    PsiParameter[] parameters = parameterList.getParameters();
                    if (parameters.length < 1 || parameters[0] == null) {
                        return;
                    }
                    PsiType type = parameters[0].getType();
                    if (!"java.lang.String".equals(type.getCanonicalText())) {
                        return;
                    }
                    PsiExpressionList argumentList = expression.getArgumentList();
                    if (argumentList == null) {
                        return;
                    }
                    this.checkStringFormatAndGetIndexes(argumentList.getExpressions()[0]);
                }
            }

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                List<MessageFormatUtil.MessageFormatPlaceholder> indexes;
                if (call == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((MessageFormatUtil.PATTERN_METHODS.test(call) || IncorrectMessageFormatInspection.this.isCustomPatternMethodCall(call)) && (indexes = this.checkStringFormatAndGetIndexes(call.getArgumentList().getExpressions()[0])) != null) {
                    this.checkIndexes(call, indexes);
                }
            }

            private void checkIndexes(@NotNull PsiMethodCallExpression call, @NotNull List<MessageFormatUtil.MessageFormatPlaceholder> indexes) {
                PsiExpression[] expressions;
                int count;
                if (call == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (indexes == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((count = (expressions = call.getArgumentList().getExpressions()).length) == 2 && expressions[1].getType() instanceof PsiArrayType) {
                    return;
                }
                for (PsiExpression expression : expressions) {
                    if (expression != null && !(expression instanceof PsiEmptyExpressionImpl)) continue;
                    return;
                }
                int argumentNumber = count - 1;
                ArrayList<Integer> notFoundArguments = new ArrayList<Integer>();
                HashSet<Integer> usedArgumentIndexes = new HashSet<Integer>();
                for (MessageFormatUtil.MessageFormatPlaceholder index : indexes) {
                    if (index.index() >= argumentNumber) {
                        notFoundArguments.add(index.index());
                    }
                    usedArgumentIndexes.add(index.index());
                }
                ArrayList<Integer> notUsedArguments = new ArrayList<Integer>();
                for (int i = 0; i < argumentNumber; ++i) {
                    if (usedArgumentIndexes.contains(i)) continue;
                    notUsedArguments.add(i);
                }
                if (notFoundArguments.isEmpty() && notUsedArguments.isEmpty()) {
                    return;
                }
                PsiIdentifier[] identifiers = (PsiIdentifier[])PsiTreeUtil.getChildrenOfType((PsiElement)call.getMethodExpression(), PsiIdentifier.class);
                if (identifiers == null || identifiers.length != 1) {
                    return;
                }
                PsiIdentifier identifier = identifiers[0];
                if (!notFoundArguments.isEmpty()) {
                    if (notFoundArguments.size() == 1) {
                        holder.registerProblem((PsiElement)identifier, InspectionGadgetsBundle.message("inspection.incorrect.message.format.not.found.argument", notFoundArguments.iterator().next()), new LocalQuickFix[0]);
                    } else {
                        StringJoiner joiner = new StringJoiner(", ");
                        for (Integer notFoundArgument : notFoundArguments) {
                            joiner.add(notFoundArgument.toString());
                        }
                        holder.registerProblem((PsiElement)identifier, InspectionGadgetsBundle.message("inspection.incorrect.message.format.not.found.arguments", joiner.toString()), new LocalQuickFix[0]);
                    }
                }
                if (!notUsedArguments.isEmpty()) {
                    for (Integer notUsedArgument : notUsedArguments) {
                        int expressionIndex = notUsedArgument + 1;
                        PsiExpression expression = expressions[expressionIndex];
                        holder.registerProblem((PsiElement)expression, InspectionGadgetsBundle.message("inspection.incorrect.message.format.not.used.argument", notUsedArgument), new LocalQuickFix[0]);
                    }
                }
            }

            @Nullable
            private List<MessageFormatUtil.MessageFormatPlaceholder> checkStringFormatAndGetIndexes(@Nullable PsiExpression expression) {
                MessageFormatUtil.MessageFormatResult result;
                PsiExpression initializer;
                PsiVariable variable;
                PsiReferenceExpression referenceExpression;
                PsiElement psiElement;
                if (expression == null) {
                    return null;
                }
                boolean immediatePattern = true;
                String pattern = null;
                if (expression instanceof PsiLiteralExpression) {
                    PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
                    pattern = literalExpression.getText();
                }
                if (pattern == null && expression instanceof PsiReferenceExpression && (psiElement = (referenceExpression = (PsiReferenceExpression)expression).resolve()) instanceof PsiVariable && (variable = (PsiVariable)psiElement).hasModifierProperty("final") && (initializer = variable.getInitializer()) instanceof PsiLiteralExpression) {
                    PsiLiteralExpression literalExpression = (PsiLiteralExpression)initializer;
                    pattern = literalExpression.getText();
                    expression = initializer;
                }
                if (pattern == null) {
                    immediatePattern = false;
                    CommonDataflow.DataflowResult dataflowResult = CommonDataflow.getDataflowResult((PsiElement)expression);
                    if (dataflowResult == null) {
                        return null;
                    }
                    Set<Object> values = dataflowResult.getExpressionValues(expression);
                    if (values.size() != 1) {
                        return null;
                    }
                    Object object = values.iterator().next();
                    if (!(object instanceof String)) {
                        return null;
                    }
                    String value = (String)object;
                    pattern = value;
                }
                if ((result = MessageFormatUtil.checkFormat(pattern)).valid()) {
                    return result.placeholders();
                }
                if (!immediatePattern) {
                    Optional<MessageFormatUtil.MessageFormatError> toHighlight = result.errors().stream().filter(t -> t.errorType().getSeverity().ordinal() <= MessageFormatUtil.ErrorSeverity.WARNING.ordinal()).min(Comparator.comparing(t -> t.errorType().getSeverity()));
                    if (toHighlight.isEmpty()) {
                        return null;
                    }
                    MessageFormatUtil.MessageFormatError error2 = toHighlight.get();
                    this.createError(expression, error2, pattern, 0, expression.getTextLength());
                } else {
                    for (MessageFormatUtil.MessageFormatError error2 : result.errors()) {
                        this.createError(expression, error2, pattern, -1, 0);
                    }
                }
                if (!ContainerUtil.exists(result.errors(), error -> error.errorType().getSeverity() == MessageFormatUtil.ErrorSeverity.RUNTIME_EXCEPTION)) {
                    return result.placeholders();
                }
                return null;
            }

            @Nullable
            private static String getRelatedText(@NotNull String pattern, @NotNull MessageFormatUtil.MessageFormatError error) {
                if (pattern == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (error == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (error.fromIndex() < 0 || error.toIndex() > pattern.length() || error.toIndex() < error.fromIndex()) {
                    return null;
                }
                return pattern.substring(error.fromIndex(), error.toIndex());
            }

            private void createError(@NotNull PsiExpression expression, @NotNull MessageFormatUtil.MessageFormatError error, @NotNull String pattern, int start, int end) {
                MessageFormatUtil.MessageFormatErrorType type;
                if (expression == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (error == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (pattern == null) {
                    1.$$$reportNull$$$0(8);
                }
                if ((type = error.errorType()) == MessageFormatUtil.MessageFormatErrorType.QUOTED_PLACEHOLDER) {
                    return;
                }
                String relatedText = 1.getRelatedText(pattern, error);
                if (relatedText == null) {
                    return;
                }
                String errorText = IncorrectMessageFormatInspection.getMessageFormatTemplate(type, relatedText);
                if (start >= 0) {
                    errorText = InspectionGadgetsBundle.message("inspection.incorrect.message.format.pattern", errorText, pattern);
                } else {
                    start = error.fromIndex();
                    end = error.toIndex();
                }
                ProblemHighlightType highlightType = 1.getCustomHighlightType(type);
                if (highlightType == null) {
                    holder.registerProblem((PsiElement)expression, TextRange.create((int)start, (int)end), errorText, new LocalQuickFix[0]);
                } else {
                    holder.registerProblem((PsiElement)expression, errorText, highlightType, TextRange.create((int)start, (int)end), new LocalQuickFix[0]);
                }
            }

            @Nullable
            private static ProblemHighlightType getCustomHighlightType(@NotNull MessageFormatUtil.MessageFormatErrorType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (type.getSeverity() == MessageFormatUtil.ErrorSeverity.WARNING || type.getSeverity() == MessageFormatUtil.ErrorSeverity.WEAK_WARNING) {
                    return ProblemHighlightType.WEAK_WARNING;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indexes";
                        break;
                    }
                    case 4: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pattern";
                        break;
                    }
                    case 5: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/bugs/IncorrectMessageFormatInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNewExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkIndexes";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getRelatedText";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createError";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getCustomHighlightType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    @Nls
    public static String getMessageFormatTemplate(@NotNull MessageFormatUtil.MessageFormatErrorType type, @NotNull String relatedText) {
        if (type == null) {
            IncorrectMessageFormatInspection.$$$reportNull$$$0(5);
        }
        if (relatedText == null) {
            IncorrectMessageFormatInspection.$$$reportNull$$$0(6);
        }
        String string = switch (type) {
            default -> throw new MatchException(null, null);
            case MessageFormatUtil.MessageFormatErrorType.QUOTED_PLACEHOLDER -> InspectionGadgetsBundle.message("inspection.incorrect.message.format.quotes.around.parameter", relatedText);
            case MessageFormatUtil.MessageFormatErrorType.UNPARSED_INDEX, MessageFormatUtil.MessageFormatErrorType.INDEX_NEGATIVE -> InspectionGadgetsBundle.message("inspection.incorrect.message.format.incorrect.index", relatedText);
            case MessageFormatUtil.MessageFormatErrorType.UNKNOWN_FORMAT_TYPE -> InspectionGadgetsBundle.message("inspection.incorrect.message.format.unknown.format.type", relatedText);
            case MessageFormatUtil.MessageFormatErrorType.UNCLOSED_BRACE_PLACEHOLDER -> InspectionGadgetsBundle.message("inspection.incorrect.message.format.unclosed.brace", new Object[0]);
            case MessageFormatUtil.MessageFormatErrorType.UNPAIRED_QUOTE -> InspectionGadgetsBundle.message("inspection.incorrect.message.format.unpaired.quote", new Object[0]);
            case MessageFormatUtil.MessageFormatErrorType.UNMATCHED_BRACE -> InspectionGadgetsBundle.message("inspection.incorrect.message.format.unmatched.brace", new Object[0]);
            case MessageFormatUtil.MessageFormatErrorType.MANY_QUOTES -> InspectionGadgetsBundle.message("inspection.incorrect.message.format.incorrect.quotes.number", new Object[0]);
            case MessageFormatUtil.MessageFormatErrorType.INCORRECT_CHOICE_SELECTOR -> InspectionGadgetsBundle.message("inspection.incorrect.message.format.choice.limit.incorrect", relatedText);
            case MessageFormatUtil.MessageFormatErrorType.SELECTOR_NOT_FOUND -> InspectionGadgetsBundle.message("inspection.incorrect.message.format.choice.limit.not.found", new Object[0]);
            case MessageFormatUtil.MessageFormatErrorType.INCORRECT_ORDER_CHOICE_SELECTOR -> InspectionGadgetsBundle.message("inspection.incorrect.message.format.incorrect.order.choice", new Object[0]);
        };
        if (string == null) {
            IncorrectMessageFormatInspection.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/bugs/IncorrectMessageFormatInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relatedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/bugs/IncorrectMessageFormatInspection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageFormatTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isCustomPatternMethodCall";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMessageFormatTemplate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

