/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InnerClassReferencedViaSubclassInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass declaringClass = (PsiClass)infos[0];
        PsiClass referencedClass = (PsiClass)infos[1];
        String string = InspectionGadgetsBundle.message("inner.class.referenced.via.subclass.problem.descriptor", declaringClass.getQualifiedName(), referencedClass.getQualifiedName());
        if (string == null) {
            InnerClassReferencedViaSubclassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new InnerClassReferencedViaSubclassFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new InnerClassReferencedViaSubclassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/InnerClassReferencedViaSubclassInspection", "buildErrorString"));
    }

    private static class InnerClassReferencedViaSubclassFix
    extends PsiUpdateModCommandQuickFix {
        private InnerClassReferencedViaSubclassFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inner.class.referenced.via.subclass.quickfix", new Object[0]);
            if (string == null) {
                InnerClassReferencedViaSubclassFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiIdentifier name;
            PsiJavaCodeReferenceElement reference;
            PsiClass aClass;
            if (project == null) {
                InnerClassReferencedViaSubclassFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                InnerClassReferencedViaSubclassFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                InnerClassReferencedViaSubclassFix.$$$reportNull$$$0(3);
            }
            if ((aClass = (PsiClass)(reference = (PsiJavaCodeReferenceElement)(name = (PsiIdentifier)startElement).getParent()).resolve()) == null) {
                return;
            }
            PsiClass containingClass = aClass.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)reference.getProject());
            Object newReferenceElement = reference instanceof PsiReferenceExpression ? factory.createReferenceExpression(containingClass) : factory.createClassReferenceElement(containingClass);
            PsiElement qualifier = reference.getQualifier();
            if (qualifier == null) {
                return;
            }
            qualifier.replace((PsiElement)newReferenceElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/InnerClassReferencedViaSubclassInspection$InnerClassReferencedViaSubclassFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/InnerClassReferencedViaSubclassInspection$InnerClassReferencedViaSubclassFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class InnerClassReferencedViaSubclassVisitor
    extends BaseInspectionVisitor {
        private InnerClassReferencedViaSubclassVisitor() {
        }

        public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
            if (reference == null) {
                InnerClassReferencedViaSubclassVisitor.$$$reportNull$$$0(0);
            }
            super.visitReferenceElement(reference);
            PsiElement qualifier = reference.getQualifier();
            if (!(qualifier instanceof PsiJavaCodeReferenceElement)) {
                return;
            }
            PsiJavaCodeReferenceElement qualifierReference = (PsiJavaCodeReferenceElement)qualifier;
            PsiElement qualifierTarget = qualifierReference.resolve();
            if (!(qualifierTarget instanceof PsiClass)) {
                return;
            }
            PsiClass qualifierClass = (PsiClass)qualifierTarget;
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            PsiClass containingClass = aClass.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!qualifierClass.isInheritor(containingClass, true)) {
                return;
            }
            PsiElement identifier = reference.getReferenceNameElement();
            if (identifier == null) {
                return;
            }
            this.registerError(identifier, containingClass, qualifierClass);
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                InnerClassReferencedViaSubclassVisitor.$$$reportNull$$$0(1);
            }
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/InnerClassReferencedViaSubclassInspection$InnerClassReferencedViaSubclassVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

