/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.ChangeAnnotationParameterQuickFix;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionForUnavailableAnnotationInspection
extends BaseInspection {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.ANNOTATIONS);
        if (set == null) {
            ReflectionForUnavailableAnnotationInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        if (infos.length == 1) {
            PsiClass annotationClass = (PsiClass)infos[0];
            String text = ReflectionForUnavailableAnnotationInspection.getText(annotationClass);
            return LocalQuickFix.from((ModCommandAction)new SetRuntimeRetentionFix(text, annotationClass));
        }
        if (infos.length == 2) {
            PsiAnnotation retentionAnnotation = (PsiAnnotation)infos[1];
            String text = ReflectionForUnavailableAnnotationInspection.getText((PsiClass)infos[0]);
            String runtimeRef = StringUtil.getQualifiedName((String)"java.lang.annotation.RetentionPolicy", (String)"RUNTIME");
            return LocalQuickFix.from((ModCommandAction)new ChangeAnnotationParameterQuickFix(retentionAnnotation, "value", runtimeRef, text));
        }
        assert (false);
        return null;
    }

    @IntentionName
    private static String getText(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ReflectionForUnavailableAnnotationInspection.$$$reportNull$$$0(1);
        }
        return JavaAnalysisBundle.message((String)"inspection.i18n.quickfix.annotate.element.as", (Object[])new Object[]{"annotation", aClass.getName(), "Retention(RetentionPolicy.RUNTIME)"});
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("reflection.for.unavailable.annotation.problem.descriptor", new Object[0]);
        if (string == null) {
            ReflectionForUnavailableAnnotationInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ReflectionForUnavailableAnnotationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/bugs/ReflectionForUnavailableAnnotationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/bugs/ReflectionForUnavailableAnnotationInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class SetRuntimeRetentionFix
    extends PsiUpdateModCommandAction<PsiClass> {
        @IntentionName
        private final String myName;

        private SetRuntimeRetentionFix(@IntentionName String name, @NotNull PsiClass psiClass) {
            if (psiClass == null) {
                SetRuntimeRetentionFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)psiClass);
            this.myName = name;
        }

        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiClass element) {
            if (context == null) {
                SetRuntimeRetentionFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                SetRuntimeRetentionFix.$$$reportNull$$$0(2);
            }
            return Presentation.of((String)this.myName);
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"inspection.i18n.quickfix.annotate", (Object[])new Object[0]);
            if (string == null) {
                SetRuntimeRetentionFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiClass psiClass, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                SetRuntimeRetentionFix.$$$reportNull$$$0(4);
            }
            if (psiClass == null) {
                SetRuntimeRetentionFix.$$$reportNull$$$0(5);
            }
            if (updater == null) {
                SetRuntimeRetentionFix.$$$reportNull$$$0(6);
            }
            String runtimeRef = StringUtil.getQualifiedName((String)"java.lang.annotation.RetentionPolicy", (String)"RUNTIME");
            PsiAnnotation newAnnotation = JavaPsiFacade.getElementFactory((Project)context.project()).createAnnotationFromText("@Retention(" + runtimeRef + ")", (PsiElement)psiClass);
            PsiModifierList list = psiClass.getModifierList();
            if (list == null) {
                return;
            }
            PsiAnnotation annotation = AddAnnotationPsiFix.addPhysicalAnnotationIfAbsent("java.lang.annotation.Retention", newAnnotation.getParameterList().getAttributes(), (PsiAnnotationOwner)list);
            if (annotation != null) {
                JavaCodeStyleManager.getInstance((Project)context.project()).shortenClassReferences((PsiElement)annotation);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/ReflectionForUnavailableAnnotationInspection$SetRuntimeRetentionFix";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/ReflectionForUnavailableAnnotationInspection$SetRuntimeRetentionFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class ReflectionForUnavailableAnnotationVisitor
    extends BaseInspectionVisitor {
        private ReflectionForUnavailableAnnotationVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiNameValuePair[] attributes;
            if (expression == null) {
                ReflectionForUnavailableAnnotationVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            @NonNls String methodName = methodExpression.getReferenceName();
            if (!"isAnnotationPresent".equals(methodName) && !"getAnnotation".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiExpression arg = args[0];
            if (arg == null) {
                return;
            }
            if (!(arg instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)arg;
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.lang.reflect.AnnotatedElement")) {
                return;
            }
            PsiTypeElement operand = classObjectAccessExpression.getOperand();
            PsiClass annotationClass = PsiTypesUtil.getPsiClass((PsiType)operand.getType());
            if (annotationClass == null) {
                return;
            }
            PsiModifierList modifierList = annotationClass.getModifierList();
            if (modifierList == null) {
                return;
            }
            PsiAnnotation retentionAnnotation = modifierList.findAnnotation("java.lang.annotation.Retention");
            if (retentionAnnotation == null) {
                if (annotationClass.isWritable()) {
                    this.registerError((PsiElement)arg, annotationClass);
                }
                return;
            }
            PsiAnnotationParameterList parameters = retentionAnnotation.getParameterList();
            for (PsiNameValuePair attribute : attributes = parameters.getAttributes()) {
                String text;
                PsiAnnotationMemberValue value;
                @NonNls String name = attribute.getName();
                if (name != null && !"value".equals(name) || (value = attribute.getValue()) == null || (text = value.getText()).contains("RUNTIME")) continue;
                if (annotationClass.isWritable()) {
                    this.registerError((PsiElement)arg, annotationClass, retentionAnnotation);
                }
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/ReflectionForUnavailableAnnotationInspection$ReflectionForUnavailableAnnotationVisitor", "visitMethodCallExpression"));
        }
    }
}

