/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public final class StaticFieldReferenceOnSubclassInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getID() {
        return "StaticFieldReferencedViaSubclass";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass declaringClass = (PsiClass)infos[0];
        PsiClass referencedClass = (PsiClass)infos[1];
        String string = InspectionGadgetsBundle.message("static.field.via.subclass.problem.descriptor", declaringClass.getQualifiedName(), referencedClass.getQualifiedName());
        if (string == null) {
            StaticFieldReferenceOnSubclassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new StaticFieldOnSubclassFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new StaticFieldOnSubclassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/StaticFieldReferenceOnSubclassInspection", "buildErrorString"));
    }

    private static class StaticFieldOnSubclassFix
    extends PsiUpdateModCommandQuickFix {
        private StaticFieldOnSubclassFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("static.field.via.subclass.rationalize.quickfix", new Object[0]);
            if (string == null) {
                StaticFieldOnSubclassFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiIdentifier name;
            if (project == null) {
                StaticFieldOnSubclassFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                StaticFieldOnSubclassFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                StaticFieldOnSubclassFix.$$$reportNull$$$0(3);
            }
            if ((name = (PsiIdentifier)ObjectUtils.tryCast((Object)startElement, PsiIdentifier.class)) == null) {
                return;
            }
            PsiReferenceExpression expression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)name.getParent(), PsiReferenceExpression.class);
            if (expression == null) {
                return;
            }
            PsiField field = (PsiField)ObjectUtils.tryCast((Object)expression.resolve(), PsiField.class);
            if (field == null) {
                return;
            }
            PsiReplacementUtil.replaceExpressionWithReferenceTo((PsiExpression)expression, (PsiMember)field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/StaticFieldReferenceOnSubclassInspection$StaticFieldOnSubclassFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/StaticFieldReferenceOnSubclassInspection$StaticFieldOnSubclassFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class StaticFieldOnSubclassVisitor
    extends BaseInspectionVisitor {
        private StaticFieldOnSubclassVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                StaticFieldOnSubclassVisitor.$$$reportNull$$$0(0);
            }
            super.visitReferenceExpression(expression);
            PsiElement qualifier = expression.getQualifier();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = expression.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            if (!field.hasModifierProperty("static")) {
                return;
            }
            PsiElement qualifierReferent = ((PsiReferenceExpression)qualifier).resolve();
            if (!(qualifierReferent instanceof PsiClass)) {
                return;
            }
            PsiClass referencedClass = (PsiClass)qualifierReferent;
            PsiClass declaringClass = field.getContainingClass();
            if (declaringClass == null || declaringClass.equals((Object)referencedClass)) {
                return;
            }
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)expression.getProject()).getResolveHelper();
            if (!resolveHelper.isAccessible((PsiMember)declaringClass, (PsiElement)expression, null)) {
                return;
            }
            PsiElement identifier = expression.getReferenceNameElement();
            if (identifier == null) {
                return;
            }
            this.registerError(identifier, declaringClass, referencedClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/StaticFieldReferenceOnSubclassInspection$StaticFieldOnSubclassVisitor", "visitReferenceExpression"));
        }
    }
}

