/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.ChronoUtil;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Locale;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SuspiciousDateFormatInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SuspiciousDateFormatInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ChronoUtil.isPatternForDateFormat(expression)) {
                    this.processLiteral(expression);
                }
            }

            private void processLiteral(@NotNull PsiLiteralExpression expression) {
                String pattern;
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((pattern = (String)ObjectUtils.tryCast((Object)expression.getValue(), String.class)) == null) {
                    return;
                }
                ArrayList<Token> tokens = new ArrayList<Token>();
                char lastChar = '\u0000';
                int countNonFormat = 0;
                char[] array = pattern.toCharArray();
                boolean inQuote = false;
                for (int pos = 0; pos < array.length; ++pos) {
                    char c = array[pos];
                    if (c == '\'') {
                        boolean bl = inQuote = !inQuote;
                    }
                    if (c == lastChar) continue;
                    lastChar = c;
                    if (!inQuote && (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                        countNonFormat = 0;
                        tokens.add(new Token(pos, array));
                        continue;
                    }
                    if (++countNonFormat <= 3) continue;
                    tokens.add(null);
                }
                for (int i = 0; i < tokens.size(); ++i) {
                    TextRange range;
                    Token next;
                    Token prev;
                    Token token = (Token)tokens.get(i);
                    Problem problem = 1.getProblem(token, prev = i > 0 ? (Token)tokens.get(i - 1) : null, next = i < tokens.size() - 1 ? (Token)tokens.get(i + 1) : null);
                    if (problem == null || (range = ExpressionUtils.findStringLiteralRange((PsiExpression)expression, token.pos, token.pos + token.length)) == null) continue;
                    holder.registerProblem((PsiElement)expression, range, problem.toString(), new LocalQuickFix[]{new IncorrectDateFormatFix(token, range)});
                }
            }

            @Contract(value="null, _, _ -> null")
            private static Problem getProblem(@Nullable Token token, @Nullable Token prev, @Nullable Token next) {
                if (token == null) {
                    return null;
                }
                switch (token.character) {
                    case 'Y': {
                        if (1.hasNeighbor("w", prev, next)) break;
                        return new Problem(token, "week year", "year");
                    }
                    case 'M': {
                        if (!1.hasNeighbor("HhKk", prev, next) || 1.hasNeighbor("yd", prev, next)) break;
                        return new Problem(token, "month", "minute");
                    }
                    case 'm': {
                        if (!1.hasNeighbor("yd", prev, next) || 1.hasNeighbor("HhKk", prev, next)) break;
                        return new Problem(token, "minute", "month");
                    }
                    case 'D': {
                        if (!1.hasNeighbor("ML", prev, next)) break;
                        return new Problem(token, "day of year", "day of month");
                    }
                    case 'S': {
                        if (!1.hasNeighbor("m", prev, next)) break;
                        return new Problem(token, "milliseconds", "seconds");
                    }
                }
                return null;
            }

            private static boolean hasNeighbor(@NotNull @NonNls String neighbors, @Nullable Token prev, @Nullable Token next) {
                if (neighbors == null) {
                    1.$$$reportNull$$$0(2);
                }
                return prev != null && neighbors.indexOf(prev.character) >= 0 || next != null && neighbors.indexOf(next.character) >= 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "neighbors";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/bugs/SuspiciousDateFormatInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLiteralExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processLiteral";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "hasNeighbor";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/siyeh/ig/bugs/SuspiciousDateFormatInspection", "buildVisitor"));
    }

    private static class IncorrectDateFormatFix
    extends PsiUpdateModCommandQuickFix {
        private final Token myToken;
        private final TextRange myRange;

        IncorrectDateFormatFix(Token token, TextRange range) {
            this.myToken = token;
            this.myRange = range;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{this.myToken.toString(), this.myToken.fixed()});
            if (string == null) {
                IncorrectDateFormatFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("incorrect.date.format.fix.family.name", new Object[0]);
            if (string == null) {
                IncorrectDateFormatFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiLiteralExpression literal;
            if (project == null) {
                IncorrectDateFormatFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                IncorrectDateFormatFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                IncorrectDateFormatFix.$$$reportNull$$$0(4);
            }
            if ((literal = (PsiLiteralExpression)ObjectUtils.tryCast((Object)element, PsiLiteralExpression.class)) == null) {
                return;
            }
            Object text = literal.getText();
            if (this.myRange.getEndOffset() >= ((String)text).length()) {
                return;
            }
            String existing = this.myRange.substring((String)text);
            if (!existing.equals(this.myToken.toString())) {
                return;
            }
            text = ((String)text).substring(0, this.myRange.getStartOffset()) + this.myToken.fixed() + ((String)text).substring(this.myRange.getEndOffset());
            PsiExpression replacement = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText((String)text, (PsiElement)literal);
            literal.replace((PsiElement)replacement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/SuspiciousDateFormatInspection$IncorrectDateFormatFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/SuspiciousDateFormatInspection$IncorrectDateFormatFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private record Problem(Token token, @NlsSafe String usedName, @NlsSafe String intendedName) {
        @Override
        @InspectionMessage
        public String toString() {
            String key = Character.isUpperCase(this.token.character) ? "inspection.suspicious.date.format.message.upper" : "inspection.suspicious.date.format.message.lower";
            return InspectionGadgetsBundle.message(key, this.token, this.usedName, this.token.fixed(), this.intendedName);
        }
    }

    private static class Token {
        final char character;
        final int pos;
        final int length;

        Token(int pos, char[] chars) {
            this.character = chars[pos];
            this.pos = pos;
            int length = 0;
            for (int i = pos; i < chars.length && chars[i] == this.character; ++i) {
                ++length;
            }
            this.length = length;
        }

        public String fixed() {
            return Character.isUpperCase(this.character) ? this.toString().toLowerCase(Locale.ROOT) : this.toString().toUpperCase(Locale.ROOT);
        }

        public String toString() {
            return StringUtil.repeat((String)String.valueOf(this.character), (int)this.length);
        }
    }
}

