/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.application.options.CodeStyle;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class SuspiciousIndentAfterControlStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiStatement statement = (PsiStatement)infos[0];
        PsiElement token = statement.getFirstChild();
        String string = InspectionGadgetsBundle.message("suspicious.indent.after.control.statement.problem.descriptor", token.getText());
        if (string == null) {
            SuspiciousIndentAfterControlStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousIndentAfterControlStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/SuspiciousIndentAfterControlStatementInspection", "buildErrorString"));
    }

    private static class SuspiciousIndentAfterControlStatementVisitor
    extends BaseInspectionVisitor {
        private SuspiciousIndentAfterControlStatementVisitor() {
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                SuspiciousIndentAfterControlStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitWhileStatement(statement);
            this.checkWhitespaceSuspiciousness((PsiStatement)statement, statement.getBody());
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                SuspiciousIndentAfterControlStatementVisitor.$$$reportNull$$$0(1);
            }
            super.visitDoWhileStatement(statement);
            this.checkWhitespaceSuspiciousness((PsiStatement)statement, statement.getBody());
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                SuspiciousIndentAfterControlStatementVisitor.$$$reportNull$$$0(2);
            }
            super.visitForeachStatement(statement);
            this.checkWhitespaceSuspiciousness((PsiStatement)statement, statement.getBody());
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                SuspiciousIndentAfterControlStatementVisitor.$$$reportNull$$$0(3);
            }
            super.visitForStatement(statement);
            this.checkWhitespaceSuspiciousness((PsiStatement)statement, statement.getBody());
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                SuspiciousIndentAfterControlStatementVisitor.$$$reportNull$$$0(4);
            }
            super.visitIfStatement(statement);
            PsiStatement elseStatement = statement.getElseBranch();
            if (elseStatement instanceof PsiBlockStatement || elseStatement instanceof PsiIfStatement) {
                return;
            }
            this.checkWhitespaceSuspiciousness((PsiStatement)statement, elseStatement == null ? statement.getThenBranch() : elseStatement);
        }

        private void checkWhitespaceSuspiciousness(PsiStatement statement, PsiStatement body) {
            PsiStatement nextStatement;
            boolean lineBreakBeforeBody;
            if (body instanceof PsiBlockStatement || body == null) {
                return;
            }
            PsiElement bodyWhiteSpace = body.getPrevSibling();
            if (!(bodyWhiteSpace instanceof PsiWhiteSpace)) {
                lineBreakBeforeBody = false;
                bodyWhiteSpace = statement.getPrevSibling();
                if (!(bodyWhiteSpace instanceof PsiWhiteSpace)) {
                    return;
                }
            } else {
                String text = bodyWhiteSpace.getText();
                int bodyLineBreak = text.lastIndexOf(10);
                if (bodyLineBreak < 0) {
                    lineBreakBeforeBody = false;
                    bodyWhiteSpace = statement.getPrevSibling();
                    if (!(bodyWhiteSpace instanceof PsiWhiteSpace)) {
                        return;
                    }
                } else {
                    String indentText;
                    int bodyIndent;
                    int statementIndent;
                    String siblingText;
                    int statementLineBreak;
                    lineBreakBeforeBody = true;
                    PsiElement statementWhiteSpace = statement.getPrevSibling();
                    if (statementWhiteSpace instanceof PsiWhiteSpace && (statementLineBreak = (siblingText = statementWhiteSpace.getText()).lastIndexOf(10)) >= 0 && (statementIndent = this.getIndent(siblingText.substring(statementLineBreak + 1))) == (bodyIndent = this.getIndent(indentText = text.substring(bodyLineBreak + 1)))) {
                        this.registerErrorAtOffset(bodyWhiteSpace, bodyLineBreak + 1, indentText.length(), statement);
                        return;
                    }
                }
            }
            if ((nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class)) == null) {
                return;
            }
            String text = bodyWhiteSpace.getText();
            int bodyLineBreak = text.lastIndexOf(10);
            if (bodyLineBreak < 0) {
                return;
            }
            PsiElement nextWhiteSpace = nextStatement.getPrevSibling();
            if (!(nextWhiteSpace instanceof PsiWhiteSpace)) {
                return;
            }
            String nextText = nextWhiteSpace.getText();
            int nextLineBreak = nextText.lastIndexOf(10);
            if (nextLineBreak < 0) {
                return;
            }
            int bodyIndent = this.getIndent(text.substring(bodyLineBreak + 1));
            String nextIndentText = nextText.substring(nextLineBreak + 1);
            int nextIndent = this.getIndent(nextIndentText);
            if (nextIndent > bodyIndent || lineBreakBeforeBody && nextIndent == bodyIndent) {
                this.registerErrorAtOffset(nextWhiteSpace, nextLineBreak + 1, nextIndentText.length(), statement);
            }
        }

        private int getIndent(String indent) {
            int result = 0;
            int length = indent.length();
            for (int i = 0; i < length; ++i) {
                char c = indent.charAt(i);
                if (c == ' ') {
                    ++result;
                    continue;
                }
                if (c == '\t') {
                    result += this.getTabSize();
                    continue;
                }
                if (c != '\f') {
                    throw new AssertionError((Object)indent);
                }
            }
            return result;
        }

        private int getTabSize() {
            return CodeStyle.getIndentOptions((PsiFile)this.getCurrentFile()).TAB_SIZE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/siyeh/ig/bugs/SuspiciousIndentAfterControlStatementInspection$SuspiciousIndentAfterControlStatementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDoWhileStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForeachStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIfStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

