/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SuspiciousIntegerDivAssignmentInspection
extends BaseInspection {
    public boolean myReportPossiblyExactDivision = true;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("suspicious.integer.div.assignment.problem.descriptor", new Object[0]);
        if (string == null) {
            SuspiciousIntegerDivAssignmentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myReportPossiblyExactDivision", (String)JavaAnalysisBundle.message((String)"inspection.suspicious.integer.div.assignment.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            SuspiciousIntegerDivAssignmentInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new SuspiciousIntegerDivAssignmentFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousIntegerDivAssignmentVisitor();
    }

    @Nullable
    private static PsiBinaryExpression getRhs(@NotNull PsiAssignmentExpression assignment) {
        PsiBinaryExpression rhs;
        if (assignment == null) {
            SuspiciousIntegerDivAssignmentInspection.$$$reportNull$$$0(2);
        }
        if ((rhs = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression()), PsiBinaryExpression.class)) == null || !rhs.getOperationTokenType().equals(JavaTokenType.DIV) || !TypeConversionUtil.isIntegralNumberType((PsiType)rhs.getType())) {
            return null;
        }
        return rhs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/bugs/SuspiciousIntegerDivAssignmentInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/bugs/SuspiciousIntegerDivAssignmentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRhs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static class SuspiciousIntegerDivAssignmentFix
    extends PsiUpdateModCommandQuickFix {
        private SuspiciousIntegerDivAssignmentFix() {
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiAssignmentExpression expression;
            if (project == null) {
                SuspiciousIntegerDivAssignmentFix.$$$reportNull$$$0(0);
            }
            if (startElement == null) {
                SuspiciousIntegerDivAssignmentFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                SuspiciousIntegerDivAssignmentFix.$$$reportNull$$$0(2);
            }
            if ((expression = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)startElement, PsiAssignmentExpression.class)) == null) {
                return;
            }
            PsiJavaToken token = expression.getOperationSign();
            IElementType tokenType = token.getTokenType();
            if (!JavaTokenType.ASTERISKEQ.equals(tokenType) && !JavaTokenType.DIVEQ.equals(tokenType)) {
                return;
            }
            PsiBinaryExpression rhs = SuspiciousIntegerDivAssignmentInspection.getRhs(expression);
            if (rhs == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            PsiExpression operand = rhs.getLOperand();
            Number number = JavaPsiMathUtil.getNumberFromLiteral(operand);
            if (number != null) {
                PsiReplacementUtil.replaceExpression(operand, String.valueOf(number) + ".0", tracker);
            } else {
                PsiReplacementUtil.replaceExpression(operand, "(double)" + operand.getText(), tracker);
            }
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("suspicious.integer.div.assignment.quickfix", new Object[0]);
            if (string == null) {
                SuspiciousIntegerDivAssignmentFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/SuspiciousIntegerDivAssignmentInspection$SuspiciousIntegerDivAssignmentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/SuspiciousIntegerDivAssignmentInspection$SuspiciousIntegerDivAssignmentFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private class SuspiciousIntegerDivAssignmentVisitor
    extends BaseInspectionVisitor {
        private SuspiciousIntegerDivAssignmentVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            LongRangeSet divisorRange;
            if (assignment == null) {
                SuspiciousIntegerDivAssignmentVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(assignment);
            IElementType assignmentTokenType = assignment.getOperationTokenType();
            if (!assignmentTokenType.equals(JavaTokenType.ASTERISKEQ) && !assignmentTokenType.equals(JavaTokenType.DIVEQ)) {
                return;
            }
            PsiBinaryExpression rhs = SuspiciousIntegerDivAssignmentInspection.getRhs(assignment);
            if (rhs == null) {
                return;
            }
            LongRangeSet dividendRange = CommonDataflow.getExpressionRange(rhs.getLOperand());
            if (dividendRange != null && (divisorRange = CommonDataflow.getExpressionRange(rhs.getROperand())) != null) {
                LongRangeSet modRange = dividendRange.mod(divisorRange);
                if (modRange.isEmpty() || LongRangeSet.point((long)0L).equals(modRange)) {
                    return;
                }
                if (!modRange.contains(0L)) {
                    this.registerError((PsiElement)assignment, new Object[0]);
                    return;
                }
            }
            if (!SuspiciousIntegerDivAssignmentInspection.this.myReportPossiblyExactDivision) {
                return;
            }
            this.registerError((PsiElement)assignment, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/siyeh/ig/bugs/SuspiciousIntegerDivAssignmentInspection$SuspiciousIntegerDivAssignmentVisitor", "visitAssignmentExpression"));
        }
    }
}

