/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.java.JavaDfaListener;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.GetterDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.PlainDescriptor;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class SuspiciousInvocationHandlerImplementationInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final String HANDLER_CLASS = "java.lang.reflect.InvocationHandler";
    private static final String[] HANDLER_ARGUMENT_TYPES = new String[]{"java.lang.Object", "java.lang.reflect.Method", "java.lang.Object[]"};
    private static final CallMatcher INVOKE = CallMatcher.instanceCall("java.lang.reflect.InvocationHandler", "invoke").parameterTypes(HANDLER_ARGUMENT_TYPES);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SuspiciousInvocationHandlerImplementationInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitMethod(@NotNull PsiMethod method) {
                Object[] parameters;
                PsiParameterList list;
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (INVOKE.methodMatches(method)) {
                    this.check((PsiParameterListOwner)method);
                }
                if (method.getReturnType() instanceof PsiClassType && (list = method.getParameterList()).getParametersCount() == 3 && EntryStream.zip((Object[])(parameters = list.getParameters()), (Object[])HANDLER_ARGUMENT_TYPES).allMatch((p, t) -> TypeUtils.typeEquals(t, p.getType())) && SyntaxTraverser.psiTraverser((PsiElement)holder.getFile()).filter(PsiMethodReferenceExpression.class).filter(ref -> ref.isReferenceTo((PsiElement)method) && TypeUtils.typeEquals(SuspiciousInvocationHandlerImplementationInspection.HANDLER_CLASS, ref.getFunctionalInterfaceType())).first() != null) {
                    this.check((PsiParameterListOwner)method);
                }
            }

            public void visitLambdaExpression(@NotNull PsiLambdaExpression lambda) {
                if (lambda == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (lambda.getParameterList().getParametersCount() != 3) {
                    return;
                }
                PsiType type = lambda.getFunctionalInterfaceType();
                if (!InheritanceUtil.isInheritor((PsiType)type, (String)SuspiciousInvocationHandlerImplementationInspection.HANDLER_CLASS)) {
                    return;
                }
                this.check((PsiParameterListOwner)lambda);
            }

            private void check(final PsiParameterListOwner method) {
                final PsiElement body = method.getBody();
                if (body == null) {
                    return;
                }
                PsiParameter methodParameter = method.getParameterList().getParameter(1);
                if (methodParameter == null) {
                    return;
                }
                if (body instanceof PsiCodeBlock && !ControlFlowUtils.containsReturn(body)) {
                    return;
                }
                if (!VariableAccessUtils.variableIsUsed((PsiVariable)methodParameter, body)) {
                    holder.registerProblem((PsiElement)Objects.requireNonNull(methodParameter.getNameIdentifier()), JavaAnalysisBundle.message((String)"suspicious.invocation.handler.implementation.method.unused.message", (Object[])new Object[0]), new LocalQuickFix[0]);
                    return;
                }
                final InvocationHandlerAnalysisRunner runner = new InvocationHandlerAnalysisRunner(holder, body, methodParameter);
                final DfaVariableValue methodName = runner.myDfaMethodName;
                if (methodName == null) {
                    return;
                }
                final TreeMap<String, Map> returnMap = new TreeMap<String, Map>();
                RunnerResult result = runner.analyzeMethod(body, new JavaDfaListener(){

                    @Override
                    public void beforeValueReturn(@NotNull DfaValue value, @Nullable PsiExpression expression, @NotNull PsiElement context, @NotNull DfaMemoryState state) {
                        if (value == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (context == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (state == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (context != method) {
                            return;
                        }
                        String name = (String)state.getDfType((DfaValue)methodName).getConstantOfType(String.class);
                        if (name == null) {
                            runner.cancel();
                            return;
                        }
                        DfType type = state.getDfType(value);
                        if (type instanceof DfPrimitiveType) {
                            type = DfTypes.typedObject((PsiType)((DfPrimitiveType)type).getPsiType().getBoxedType(body), Nullability.NOT_NULL);
                        }
                        returnMap.computeIfAbsent(name, k -> new HashMap()).merge(expression, type, DfType::join);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "value";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "context";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[0] = "state";
                                break;
                            }
                        }
                        objectArray[1] = "com/siyeh/ig/bugs/SuspiciousInvocationHandlerImplementationInspection$1$1";
                        objectArray[2] = "beforeValueReturn";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                if (result != RunnerResult.OK) {
                    return;
                }
                HashSet reportedAnchors = new HashSet();
                returnMap.forEach((name, map) -> {
                    DfType reduced = map.values().stream().reduce(DfType.BOTTOM, DfType::join);
                    PsiType wantedType = 1.getWantedType(body, name);
                    if (wantedType == null) {
                        return;
                    }
                    TypeConstraint wantedConstraint = TypeConstraints.exact(wantedType);
                    if (reduced.meet(wantedConstraint.asDfType().meet((DfType)DfTypes.NOT_NULL_OBJECT)) != DfType.BOTTOM && StreamEx.ofValues((Map)map).map(DfaNullability::fromDfType).anyMatch(n -> n != DfaNullability.NULLABLE && n != DfaNullability.NULL)) {
                        return;
                    }
                    map.forEach((expression, type) -> {
                        DfaNullability nullability;
                        if (reportedAnchors.contains(expression)) {
                            return;
                        }
                        String message = null;
                        TypeConstraint constraint = TypeConstraint.fromDfType(type);
                        if (wantedConstraint.meet(constraint) == TypeConstraints.BOTTOM) {
                            message = JavaAnalysisBundle.message((String)"suspicious.invocation.handler.implementation.type.mismatch.message", (Object[])new Object[]{name, wantedConstraint.getPresentationText(null), constraint.getPresentationText(null)});
                        }
                        if ((nullability = DfaNullability.fromDfType(type)) == DfaNullability.NULL) {
                            String string = message = name.equals("toString") ? JavaAnalysisBundle.message((String)"suspicious.invocation.handler.implementation.null.returned.for.toString.message", (Object[])new Object[0]) : JavaAnalysisBundle.message((String)"suspicious.invocation.handler.implementation.null.returned.message", (Object[])new Object[]{name});
                        }
                        if (message != null) {
                            reportedAnchors.add(expression);
                            holder.registerProblem((PsiElement)expression, message, new LocalQuickFix[0]);
                        }
                    });
                });
            }

            @Nullable
            private static PsiType getWantedType(PsiElement body, String name) {
                return switch (name) {
                    case "equals" -> PsiTypes.booleanType().getBoxedType(body);
                    case "hashCode" -> PsiTypes.intType().getBoxedType(body);
                    case "toString" -> PsiType.getJavaLangString((PsiManager)body.getManager(), (GlobalSearchScope)body.getResolveScope());
                    default -> null;
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lambda";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/bugs/SuspiciousInvocationHandlerImplementationInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/siyeh/ig/bugs/SuspiciousInvocationHandlerImplementationInspection", "buildVisitor"));
    }

    private static class InvocationHandlerAnalysisRunner
    extends StandardDataFlowRunner {
        private final PsiElement myBody;
        private DfaVariableValue myDfaMethodName;
        private DfaVariableValue myDfaMethodDeclaringClass;
        private PsiType myStringType;
        private PsiType myObjectType;
        private PsiType myClassType;

        InvocationHandlerAnalysisRunner(@NotNull ProblemsHolder holder, PsiElement body, PsiParameter methodParameter) {
            if (holder == null) {
                InvocationHandlerAnalysisRunner.$$$reportNull$$$0(0);
            }
            super(holder.getProject());
            this.myBody = body;
            PsiClass methodClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)methodParameter.getType());
            if (methodClass == null) {
                return;
            }
            PsiMethod[] getNameMethods = methodClass.findMethodsByName("getName", false);
            if (getNameMethods.length != 1) {
                return;
            }
            PsiMethod getNameMethod = getNameMethods[0];
            if (!getNameMethod.getParameterList().isEmpty()) {
                return;
            }
            PsiMethod[] getDeclaringClassMethods = methodClass.findMethodsByName("getDeclaringClass", false);
            if (getDeclaringClassMethods.length != 1) {
                return;
            }
            PsiMethod getDeclaringClassMethod = getDeclaringClassMethods[0];
            if (!getDeclaringClassMethod.getParameterList().isEmpty()) {
                return;
            }
            this.myClassType = getDeclaringClassMethod.getReturnType();
            this.myStringType = getNameMethod.getReturnType();
            this.myObjectType = PsiType.getJavaLangObject((PsiManager)methodClass.getManager(), (GlobalSearchScope)methodClass.getResolveScope());
            if (this.myClassType == null || this.myStringType == null) {
                return;
            }
            DfaValueFactory factory = this.getFactory();
            DfaVariableValue dfaMethod = PlainDescriptor.createVariableValue(factory, (PsiVariable)methodParameter);
            this.myDfaMethodName = (DfaVariableValue)new GetterDescriptor(getNameMethod).createValue(factory, (DfaValue)dfaMethod);
            this.myDfaMethodDeclaringClass = (DfaVariableValue)new GetterDescriptor(getDeclaringClassMethod).createValue(factory, (DfaValue)dfaMethod);
        }

        @Override
        protected @Unmodifiable @NotNull List<DfaInstructionState> createInitialInstructionStates(@NotNull PsiElement psiBlock, @NotNull Collection<? extends DfaMemoryState> memStates, @NotNull ControlFlow flow) {
            if (psiBlock == null) {
                InvocationHandlerAnalysisRunner.$$$reportNull$$$0(1);
            }
            if (memStates == null) {
                InvocationHandlerAnalysisRunner.$$$reportNull$$$0(2);
            }
            if (flow == null) {
                InvocationHandlerAnalysisRunner.$$$reportNull$$$0(3);
            }
            if (psiBlock != this.myBody) {
                List<DfaInstructionState> list = super.createInitialInstructionStates(psiBlock, memStates, flow);
                if (list == null) {
                    InvocationHandlerAnalysisRunner.$$$reportNull$$$0(4);
                }
                return list;
            }
            ArrayList<DfaInstructionState> result = new ArrayList<DfaInstructionState>();
            Instruction instruction = flow.getInstruction(0);
            DfaVariableValue qualifier = this.myDfaMethodName.getQualifier();
            flow.keepVariables(desc -> desc.equals((Object)this.myDfaMethodDeclaringClass.getDescriptor()) || desc.equals((Object)this.myDfaMethodName.getDescriptor()) || qualifier != null && desc.equals((Object)qualifier.getDescriptor()));
            for (DfaMemoryState dfaMemoryState : memStates) {
                dfaMemoryState.applyCondition(this.myDfaMethodDeclaringClass.eq(DfTypes.constant((Object)this.myObjectType, this.myClassType)));
                for (String methodName : Arrays.asList("hashCode", "equals", "toString")) {
                    DfaMemoryState methodSpecificState = dfaMemoryState.createCopy();
                    methodSpecificState.applyCondition(this.myDfaMethodName.eq(DfTypes.constant((Object)methodName, this.myStringType)));
                    result.add(new DfaInstructionState(instruction, methodSpecificState));
                }
            }
            ArrayList<DfaInstructionState> arrayList = result;
            if (arrayList == null) {
                InvocationHandlerAnalysisRunner.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiBlock";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memStates";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/SuspiciousInvocationHandlerImplementationInspection$InvocationHandlerAnalysisRunner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/SuspiciousInvocationHandlerImplementationInspection$InvocationHandlerAnalysisRunner";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createInitialInstructionStates";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createInitialInstructionStates";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

