/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThrowableNotThrownInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        if (expression instanceof PsiMethodCallExpression) {
            String string = InspectionGadgetsBundle.message("throwable.result.of.method.call.ignored.problem.descriptor", new Object[0]);
            if (string == null) {
                ThrowableNotThrownInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String type = TypeUtils.expressionHasTypeOrSubtype(expression, "java.lang.RuntimeException", "java.lang.Exception", "java.lang.Error");
        if ("java.lang.RuntimeException".equals(type)) {
            String string = InspectionGadgetsBundle.message("throwable.instance.never.thrown.runtime.exception.problem.descriptor", new Object[0]);
            if (string == null) {
                ThrowableNotThrownInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        if ("java.lang.Exception".equals(type)) {
            String string = InspectionGadgetsBundle.message("throwable.instance.never.thrown.checked.exception.problem.descriptor", new Object[0]);
            if (string == null) {
                ThrowableNotThrownInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        if ("java.lang.Error".equals(type)) {
            String string = InspectionGadgetsBundle.message("throwable.instance.never.thrown.error.problem.descriptor", new Object[0]);
            if (string == null) {
                ThrowableNotThrownInspection.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("throwable.instance.never.thrown.problem.descriptor", new Object[0]);
        if (string == null) {
            ThrowableNotThrownInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return ThrowableNotThrownFix.createFix((PsiCallExpression)infos[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowableResultOfMethodCallIgnoredVisitor();
    }

    private static boolean isIgnoredThrowable(PsiExpression expression) {
        if (!TypeUtils.expressionHasTypeOrSubtype(expression, "java.lang.Throwable")) {
            return false;
        }
        return ThrowableNotThrownInspection.isIgnored(expression, true);
    }

    private static boolean isIgnored(PsiExpression expression, boolean checkDeep) {
        PsiElement parent = ThrowableNotThrownInspection.getHandlingParent(expression);
        if (parent instanceof PsiVariable) {
            if (!(parent instanceof PsiLocalVariable)) {
                return false;
            }
            return checkDeep && !ThrowableNotThrownInspection.isUsedElsewhere((PsiLocalVariable)parent);
        }
        if (parent instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)parent;
            PsiExpression expression1 = expressionStatement.getExpression();
            return !PsiTypes.voidType().equals((Object)expression1.getType());
        }
        if (parent instanceof PsiExpressionList) {
            return parent.getParent() instanceof PsiExpressionListStatement;
        }
        if (parent instanceof PsiLambdaExpression) {
            return PsiTypes.voidType().equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)parent)));
        }
        if (parent instanceof PsiReturnStatement || parent instanceof PsiThrowStatement || parent instanceof PsiLoopStatement || parent instanceof PsiIfStatement || parent instanceof PsiAssertStatement) {
            return false;
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (!PsiTreeUtil.isAncestor((PsiElement)rhs, (PsiElement)expression, (boolean)false)) {
                return false;
            }
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiLocalVariable)) {
                return false;
            }
            return checkDeep && !ThrowableNotThrownInspection.isUsedElsewhere((PsiLocalVariable)target);
        }
        return true;
    }

    private static PsiElement getHandlingParent(PsiExpression expression) {
        PsiElement parent;
        while ((parent = ExpressionUtils.getPassThroughParent(expression)) instanceof PsiExpression && !(parent instanceof PsiLambdaExpression) && !(parent instanceof PsiAssignmentExpression)) {
            expression = (PsiExpression)parent;
        }
        return parent;
    }

    private static boolean isUsedElsewhere(PsiLocalVariable variable) {
        for (PsiReferenceExpression reference : VariableAccessUtils.getVariableReferences((PsiVariable)variable)) {
            if (ThrowableNotThrownInspection.isIgnored((PsiExpression)reference, false)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ThrowableNotThrownInspection", "buildErrorString"));
    }

    private static class ThrowableNotThrownFix
    extends PsiUpdateModCommandQuickFix {
        private ThrowableNotThrownFix() {
        }

        private static ThrowableNotThrownFix createFix(PsiCallExpression context) {
            PsiElement parent = context.getParent();
            if (!(parent instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiElement next = PsiTreeUtil.getNextSiblingOfType((PsiElement)parent, PsiStatement.class);
            return next == null ? new ThrowableNotThrownFix() : null;
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.insert.x", (Object[])new Object[]{"throw "});
            if (string == null) {
                ThrowableNotThrownFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiElement element;
            if (project == null) {
                ThrowableNotThrownFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                ThrowableNotThrownFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ThrowableNotThrownFix.$$$reportNull$$$0(3);
            }
            if (!((element = startElement.getParent()) instanceof PsiCallExpression)) {
                return;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiExpressionStatement)) {
                return;
            }
            PsiReplacementUtil.replaceStatement((PsiStatement)parent, "throw " + element.getText() + ";");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/ThrowableNotThrownInspection$ThrowableNotThrownFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/ThrowableNotThrownInspection$ThrowableNotThrownFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ThrowableResultOfMethodCallIgnoredVisitor
    extends BaseInspectionVisitor {
        private ThrowableResultOfMethodCallIgnoredVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                ThrowableResultOfMethodCallIgnoredVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression);
            if (!ThrowableNotThrownInspection.isIgnoredThrowable((PsiExpression)expression)) {
                return;
            }
            this.registerNewExpressionError(expression, expression);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                ThrowableResultOfMethodCallIgnoredVisitor.$$$reportNull$$$0(1);
            }
            super.visitMethodCallExpression(expression);
            if (!ThrowableNotThrownInspection.isIgnoredThrowable((PsiExpression)expression)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)method.getReturnType());
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!method.hasModifierProperty("static") && InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.lang.Throwable")) {
                return;
            }
            StandardMethodContract contract = (StandardMethodContract)ContainerUtil.getOnlyItem(JavaMethodContractUtil.getMethodContracts(method));
            if (contract != null && contract.isTrivial() && contract.getReturnValue().isFail()) {
                return;
            }
            if (MethodUtils.hasCanIgnoreReturnValueAnnotation(method, (PsiElement)method.getContainingFile())) {
                return;
            }
            this.registerMethodCallError(expression, expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/bugs/ThrowableNotThrownInspection$ThrowableResultOfMethodCallIgnoredVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

