/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.java.codeserver.core.JavaPsiModifierUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.RemoveModifierFix;
import org.jetbrains.annotations.NotNull;

public final class FinalPrivateMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("final.private.method.problem.descriptor", new Object[0]);
        if (string == null) {
            FinalPrivateMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new FinalPrivateMethodVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new RemoveModifierFix((String)infos[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/FinalPrivateMethodInspection", "buildErrorString"));
    }

    private static class FinalPrivateMethodVisitor
    extends BaseInspectionVisitor {
        private FinalPrivateMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                FinalPrivateMethodVisitor.$$$reportNull$$$0(0);
            }
            if (!method.hasModifierProperty("final") || !method.hasModifierProperty("private")) {
                return;
            }
            if (!PsiUtil.isLanguageLevel9OrHigher((PsiElement)method) && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"java.lang.SafeVarargs", (int)0)) {
                return;
            }
            if (!JavaPsiModifierUtil.isLegalModifierCombination((PsiModifierList)method.getModifierList())) {
                return;
            }
            this.registerModifierError("final", (PsiModifierListOwner)method, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new Object[]{"final"});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/classlayout/FinalPrivateMethodInspection$FinalPrivateMethodVisitor", "visitMethod"));
        }
    }
}

