/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefOverridable;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodInheritanceUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class MethodReturnAlwaysConstantInspection
extends BaseGlobalInspection {
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        PsiElement psi;
        if (refEntity == null) {
            MethodReturnAlwaysConstantInspection.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            MethodReturnAlwaysConstantInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            MethodReturnAlwaysConstantInspection.$$$reportNull$$$0(2);
        }
        if (globalContext == null) {
            MethodReturnAlwaysConstantInspection.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            MethodReturnAlwaysConstantInspection.$$$reportNull$$$0(4);
        }
        if (!(refEntity instanceof RefMethod)) {
            return null;
        }
        RefMethod refMethod = (RefMethod)refEntity;
        if (refMethod.hasSuperMethods()) {
            return null;
        }
        PsiElement element = refMethod.getPsiElement();
        if (!(element instanceof PsiMethod)) {
            return null;
        }
        PsiMethod psiMethod = (PsiMethod)element;
        if (psiMethod.getBody() == null && refMethod.getDerivedReferences().isEmpty()) {
            return null;
        }
        Set<RefOverridable> allScopeInheritors = MethodInheritanceUtils.calculateSiblingReferences(refMethod);
        for (RefOverridable siblingReference : allScopeInheritors) {
            PsiLambdaExpression siblingLambda;
            PsiMethod siblingPsiMethod;
            psi = siblingReference.getPsiElement();
            if (!(psi instanceof PsiMethod ? (siblingPsiMethod = (PsiMethod)psi).getBody() != null && !MethodReturnAlwaysConstantInspection.alwaysReturnsConstant(siblingPsiMethod.getBody()) : (psi instanceof PsiLambdaExpression ? (siblingLambda = (PsiLambdaExpression)psi).getBody() != null && !MethodReturnAlwaysConstantInspection.alwaysReturnsConstant(siblingLambda) : psi instanceof PsiMethodReferenceExpression))) continue;
            return null;
        }
        for (RefOverridable siblingReference : allScopeInheritors) {
            PsiMethod siblingMethod;
            PsiIdentifier identifier;
            psi = siblingReference.getPsiElement();
            if (!(psi instanceof PsiMethod) || (identifier = (siblingMethod = (PsiMethod)psi).getNameIdentifier()) == null) continue;
            processor.addProblemElement((RefEntity)siblingReference, new CommonProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)identifier, InspectionGadgetsBundle.message("method.return.always.constant.problem.descriptor", new Object[0]), false, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)});
        }
        return null;
    }

    private static boolean alwaysReturnsConstant(@NotNull PsiCodeBlock body) {
        PsiStatement statement;
        if (body == null) {
            MethodReturnAlwaysConstantInspection.$$$reportNull$$$0(5);
        }
        if (!((statement = ControlFlowUtils.getOnlyStatementInBlock(body)) instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
        PsiExpression value = returnStatement.getReturnValue();
        return value != null && PsiUtil.isConstantExpression((PsiExpression)value);
    }

    private static boolean alwaysReturnsConstant(@NotNull PsiLambdaExpression lambdaExpression) {
        PsiElement body;
        if (lambdaExpression == null) {
            MethodReturnAlwaysConstantInspection.$$$reportNull$$$0(6);
        }
        if ((body = lambdaExpression.getBody()) instanceof PsiCodeBlock) {
            PsiCodeBlock codeBlock = (PsiCodeBlock)body;
            return MethodReturnAlwaysConstantInspection.alwaysReturnsConstant(codeBlock);
        }
        if (body instanceof PsiExpression) {
            PsiExpression expression = (PsiExpression)body;
            return PsiUtil.isConstantExpression((PsiExpression)expression);
        }
        return false;
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor) {
        if (manager == null) {
            MethodReturnAlwaysConstantInspection.$$$reportNull$$$0(7);
        }
        if (globalContext == null) {
            MethodReturnAlwaysConstantInspection.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            MethodReturnAlwaysConstantInspection.$$$reportNull$$$0(9);
        }
        manager.iterate((RefVisitor)new RefJavaVisitor(this){

            public void visitMethod(@NotNull RefMethod refMethod) {
                if (refMethod == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (processor.getDescriptions((RefEntity)refMethod) == null) {
                    return;
                }
                if ("private".equals(refMethod.getAccessModifier())) {
                    return;
                }
                globalContext.enqueueDerivedMethodsProcessor(refMethod, derivedMethod -> {
                    processor.ignoreElement((RefEntity)refMethod);
                    return false;
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/siyeh/ig/classlayout/MethodReturnAlwaysConstantInspection$1", "visitMethod"));
            }
        });
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaExpression";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/classlayout/MethodReturnAlwaysConstantInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "alwaysReturnsConstant";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "queryExternalUsagesRequests";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

