/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.MakeFieldFinalFix;
import com.siyeh.ig.psiutils.FinalUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NonFinalFieldInEnumInspection
extends BaseInspection {
    public boolean onlyWarnWhenQuickFix = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"onlyWarnWhenQuickFix", (String)InspectionGadgetsBundle.message("non.final.field.in.enum.quickfix.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            NonFinalFieldInEnumInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass enumClass = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("non.final.field.in.enum.problem.descriptor", enumClass.getName());
        if (string == null) {
            NonFinalFieldInEnumInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[1];
        return MakeFieldFinalFix.buildFix(field);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NonFinalFieldInEnumVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classlayout/NonFinalFieldInEnumInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NonFinalFieldInEnumVisitor
    extends BaseInspectionVisitor {
        private NonFinalFieldInEnumVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                NonFinalFieldInEnumVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            if (field.hasModifierProperty("final")) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null || !containingClass.isEnum()) {
                return;
            }
            if (NonFinalFieldInEnumInspection.this.onlyWarnWhenQuickFix && !FinalUtils.canBeFinal((PsiVariable)field)) {
                return;
            }
            this.registerFieldError(field, containingClass, field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/classlayout/NonFinalFieldInEnumInspection$NonFinalFieldInEnumVisitor", "visitField"));
        }
    }
}

