/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.UtilityClassUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class UtilityClassCanBeEnumInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("utility.class.code.can.be.enum.problem.descriptor", new Object[0]);
        if (string == null) {
            UtilityClassCanBeEnumInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected LocalQuickFix buildFix(Object ... infos) {
        return new UtilityClassCanBeEnumFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UtilityClassCanBeEnumVisitor();
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.ENUMS);
        if (set == null) {
            UtilityClassCanBeEnumInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classlayout/UtilityClassCanBeEnumInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UtilityClassCanBeEnumFix
    extends PsiUpdateModCommandQuickFix {
        private UtilityClassCanBeEnumFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("utility.class.code.can.be.enum.quickfix", new Object[0]);
            if (string == null) {
                UtilityClassCanBeEnumFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement psiElement;
            if (project == null) {
                UtilityClassCanBeEnumFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                UtilityClassCanBeEnumFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UtilityClassCanBeEnumFix.$$$reportNull$$$0(3);
            }
            if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.ENUMS, (PsiElement)element) || !((psiElement = element.getParent()) instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)psiElement;
            PsiKeyword keyword = (PsiKeyword)PsiTreeUtil.getChildOfType((PsiElement)aClass, PsiKeyword.class);
            if (keyword == null) {
                return;
            }
            for (PsiMethod constructor : aClass.getConstructors()) {
                constructor.delete();
            }
            PsiModifierList modifierList = aClass.getModifierList();
            if (modifierList != null) {
                modifierList.setModifierProperty("final", false);
                modifierList.setModifierProperty("abstract", false);
                modifierList.setModifierProperty("static", false);
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiStatement statement = factory.createStatementFromText(";", element);
            PsiElement token = statement.getFirstChild();
            aClass.addAfter(token, aClass.getLBrace());
            keyword.replace((PsiElement)factory.createKeyword("enum"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/classlayout/UtilityClassCanBeEnumInspection$UtilityClassCanBeEnumFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/classlayout/UtilityClassCanBeEnumInspection$UtilityClassCanBeEnumFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class UtilityClassCanBeEnumVisitor
    extends BaseInspectionVisitor {
        private UtilityClassCanBeEnumVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                UtilityClassCanBeEnumVisitor.$$$reportNull$$$0(0);
            }
            super.visitClass(aClass);
            if (aClass.isEnum() || !UtilityClassUtil.isUtilityClass(aClass, true, true) || !UtilityClassUtil.hasPrivateEmptyOrNoConstructor(aClass)) {
                return;
            }
            for (PsiField field : aClass.getFields()) {
                if (field.hasModifierProperty("final") && PsiUtil.isCompileTimeConstant((PsiVariable)field)) continue;
                for (PsiReference psiReference : VariableAccessUtils.getVariableReferences((PsiVariable)field)) {
                    PsiClassInitializer initializer = (PsiClassInitializer)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiClassInitializer.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
                    if (initializer == null || initializer.hasModifierProperty("static")) continue;
                    return;
                }
            }
            if (!ReferencesSearch.search((PsiElement)aClass).forEach(ref -> !(ref.getElement().getParent() instanceof PsiNewExpression))) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/UtilityClassCanBeEnumInspection$UtilityClassCanBeEnumVisitor", "visitClass"));
        }
    }
}

