/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import com.siyeh.ig.classmetrics.CyclomaticComplexityVisitor;
import org.jetbrains.annotations.NotNull;

public final class ClassComplexityInspection
extends ClassMetricInspection {
    private static final int DEFAULT_COMPLEXITY_LIMIT = 80;

    @NotNull
    public String getID() {
        return "OverlyComplexClass";
    }

    @Override
    protected int getDefaultLimit() {
        return 80;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("cyclomatic.complexity.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer totalComplexity = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("overly.complex.class.problem.descriptor", totalComplexity);
        if (string == null) {
            ClassComplexityInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ClassComplexityVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classmetrics/ClassComplexityInspection", "buildErrorString"));
    }

    private class ClassComplexityVisitor
    extends BaseInspectionVisitor {
        private ClassComplexityVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            int totalComplexity;
            if (aClass == null) {
                ClassComplexityVisitor.$$$reportNull$$$0(0);
            }
            if ((totalComplexity = this.calculateTotalComplexity(aClass)) <= ClassComplexityInspection.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass, totalComplexity);
        }

        private int calculateTotalComplexity(PsiClass aClass) {
            PsiMethod[] methods = aClass.getMethods();
            int totalComplexity = ClassComplexityVisitor.calculateComplexityForMethods(methods);
            return totalComplexity += ClassComplexityVisitor.calculateInitializerComplexity(aClass);
        }

        private static int calculateInitializerComplexity(PsiClass aClass) {
            PsiClassInitializer[] initializers;
            CyclomaticComplexityVisitor visitor2 = new CyclomaticComplexityVisitor();
            int complexity = 0;
            for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
                visitor2.reset();
                initializer.accept((PsiElementVisitor)visitor2);
                complexity += visitor2.getComplexity();
            }
            return complexity;
        }

        private static int calculateComplexityForMethods(PsiMethod[] methods) {
            CyclomaticComplexityVisitor visitor2 = new CyclomaticComplexityVisitor();
            int complexity = 0;
            for (PsiMethod method : methods) {
                visitor2.reset();
                method.accept((PsiElementVisitor)visitor2);
                complexity += visitor2.getComplexity();
            }
            return complexity;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classmetrics/ClassComplexityInspection$ClassComplexityVisitor", "visitClass"));
        }
    }
}

