/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import org.jetbrains.annotations.NotNull;

public final class BooleanExpressionMayBeConditionalInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("if.may.be.conditional.problem.descriptor", new Object[0]);
        if (string == null) {
            BooleanExpressionMayBeConditionalInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new BooleanExpressionMayBeConditionalFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new BooleanExpressionMayBeConditionalVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/BooleanExpressionMayBeConditionalInspection", "buildErrorString"));
    }

    private static class BooleanExpressionMayBeConditionalFix
    extends PsiUpdateModCommandQuickFix {
        private BooleanExpressionMayBeConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("if.may.be.conditional.quickfix", new Object[0]);
            if (string == null) {
                BooleanExpressionMayBeConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiBinaryExpression lBinaryExpression;
            PsiExpression rhs;
            PsiBinaryExpression binaryExpression;
            block12: {
                block11: {
                    if (project == null) {
                        BooleanExpressionMayBeConditionalFix.$$$reportNull$$$0(1);
                    }
                    if (element == null) {
                        BooleanExpressionMayBeConditionalFix.$$$reportNull$$$0(2);
                    }
                    if (updater == null) {
                        BooleanExpressionMayBeConditionalFix.$$$reportNull$$$0(3);
                    }
                    if (!(element instanceof PsiBinaryExpression)) {
                        return;
                    }
                    binaryExpression = (PsiBinaryExpression)element;
                    PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getLOperand());
                    rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getROperand());
                    if (!(lhs instanceof PsiBinaryExpression)) break block11;
                    lBinaryExpression = (PsiBinaryExpression)lhs;
                    if (rhs instanceof PsiBinaryExpression) break block12;
                }
                return;
            }
            PsiBinaryExpression rBinaryExpression = (PsiBinaryExpression)rhs;
            PsiExpression llhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)lBinaryExpression.getLOperand());
            PsiExpression lrhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)rBinaryExpression.getLOperand());
            if (llhs == null || lrhs == null) {
                return;
            }
            PsiExpression thenExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)lBinaryExpression.getROperand());
            PsiExpression elseExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)rBinaryExpression.getROperand());
            if (thenExpression == null || elseExpression == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            if (BoolUtils.isNegation(llhs)) {
                PsiReplacementUtil.replaceExpression((PsiExpression)binaryExpression, BooleanExpressionMayBeConditionalFix.getText(lrhs, commentTracker) + "?" + BooleanExpressionMayBeConditionalFix.getText(elseExpression, commentTracker) + ":" + BooleanExpressionMayBeConditionalFix.getText(thenExpression, commentTracker), commentTracker);
            } else {
                PsiReplacementUtil.replaceExpression((PsiExpression)binaryExpression, BooleanExpressionMayBeConditionalFix.getText(llhs, commentTracker) + "?" + BooleanExpressionMayBeConditionalFix.getText(thenExpression, commentTracker) + ":" + BooleanExpressionMayBeConditionalFix.getText(elseExpression, commentTracker), commentTracker);
            }
        }

        private static String getText(@NotNull PsiExpression expression, CommentTracker commentTracker) {
            if (expression == null) {
                BooleanExpressionMayBeConditionalFix.$$$reportNull$$$0(4);
            }
            return ParenthesesUtils.getText(commentTracker.markUnchanged(expression), 15);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/BooleanExpressionMayBeConditionalInspection$BooleanExpressionMayBeConditionalFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/BooleanExpressionMayBeConditionalInspection$BooleanExpressionMayBeConditionalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class BooleanExpressionMayBeConditionalVisitor
    extends BaseInspectionVisitor {
        private BooleanExpressionMayBeConditionalVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            PsiExpression expression2;
            PsiBinaryExpression lBinaryExpression;
            PsiExpression rhs;
            block8: {
                block7: {
                    if (expression == null) {
                        BooleanExpressionMayBeConditionalVisitor.$$$reportNull$$$0(0);
                    }
                    super.visitBinaryExpression(expression);
                    IElementType tokenType = expression.getOperationTokenType();
                    if (!JavaTokenType.OROR.equals(tokenType)) {
                        return;
                    }
                    PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getLOperand());
                    rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getROperand());
                    if (!(lhs instanceof PsiBinaryExpression)) break block7;
                    lBinaryExpression = (PsiBinaryExpression)lhs;
                    if (rhs instanceof PsiBinaryExpression) break block8;
                }
                return;
            }
            PsiBinaryExpression rBinaryExpression = (PsiBinaryExpression)rhs;
            IElementType lTokenType = lBinaryExpression.getOperationTokenType();
            IElementType rTokenType = rBinaryExpression.getOperationTokenType();
            if (!JavaTokenType.ANDAND.equals(lTokenType) || !JavaTokenType.ANDAND.equals(rTokenType)) {
                return;
            }
            PsiExpression expression1 = PsiUtil.skipParenthesizedExprDown((PsiExpression)lBinaryExpression.getLOperand());
            if (BoolUtils.areExpressionsOpposite(expression1, expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)rBinaryExpression.getLOperand())) && !SideEffectChecker.mayHaveSideEffects(expression1)) {
                this.registerError((PsiElement)expression, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/controlflow/BooleanExpressionMayBeConditionalInspection$BooleanExpressionMayBeConditionalVisitor", "visitBinaryExpression"));
        }
    }
}

