/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import org.jetbrains.annotations.NotNull;

public final class ConditionalExpressionWithIdenticalBranchesInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("conditional.expression.with.identical.branches.problem.descriptor", new Object[0]);
        if (string == null) {
            ConditionalExpressionWithIdenticalBranchesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new CollapseConditionalFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ConditionalExpressionWithIdenticalBranchesVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConditionalExpressionWithIdenticalBranchesInspection", "buildErrorString"));
    }

    private static class CollapseConditionalFix
    extends PsiUpdateModCommandQuickFix {
        private CollapseConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("conditional.expression.with.identical.branches.collapse.quickfix", new Object[0]);
            if (string == null) {
                CollapseConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiConditionalExpression conditionalExpression;
            PsiExpression thenExpression;
            if (project == null) {
                CollapseConditionalFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                CollapseConditionalFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                CollapseConditionalFix.$$$reportNull$$$0(3);
            }
            if ((thenExpression = (conditionalExpression = (PsiConditionalExpression)startElement).getThenExpression()) == null) {
                return;
            }
            PsiExpression elseExpression = conditionalExpression.getElseExpression();
            if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenExpression, elseExpression)) {
                CommentTracker commentTracker = new CommentTracker();
                PsiReplacementUtil.replaceExpression((PsiExpression)conditionalExpression, commentTracker.text((PsiElement)thenExpression), commentTracker);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/ConditionalExpressionWithIdenticalBranchesInspection$CollapseConditionalFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/ConditionalExpressionWithIdenticalBranchesInspection$CollapseConditionalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ConditionalExpressionWithIdenticalBranchesVisitor
    extends BaseInspectionVisitor {
        private ConditionalExpressionWithIdenticalBranchesVisitor() {
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
            if (expression == null) {
                ConditionalExpressionWithIdenticalBranchesVisitor.$$$reportNull$$$0(0);
            }
            super.visitConditionalExpression(expression);
            PsiExpression thenExpression = expression.getThenExpression();
            if (thenExpression == null) {
                return;
            }
            PsiExpression elseExpression = expression.getElseExpression();
            if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenExpression, elseExpression)) {
                this.registerError((PsiElement)expression, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/controlflow/ConditionalExpressionWithIdenticalBranchesInspection$ConditionalExpressionWithIdenticalBranchesVisitor", "visitConditionalExpression"));
        }
    }
}

