/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.redundantCast.RemoveRedundantCastUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public final class ConstantConditionalExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiConditionalExpression expression = (PsiConditionalExpression)infos[0];
        String string = InspectionGadgetsBundle.message("constant.conditional.expression.problem.descriptor", ConstantConditionalExpressionInspection.calculateReplacementExpression(expression).getText());
        if (string == null) {
            ConstantConditionalExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    static PsiExpression calculateReplacementExpression(@NotNull PsiConditionalExpression exp) {
        if (exp == null) {
            ConstantConditionalExpressionInspection.$$$reportNull$$$0(1);
        }
        PsiExpression thenExpression = exp.getThenExpression();
        PsiExpression elseExpression = exp.getElseExpression();
        PsiExpression condition = exp.getCondition();
        assert (thenExpression != null);
        assert (elseExpression != null);
        PsiExpression psiExpression = BoolUtils.isTrue(condition) ? thenExpression : elseExpression;
        if (psiExpression == null) {
            ConstantConditionalExpressionInspection.$$$reportNull$$$0(2);
        }
        return psiExpression;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new ConstantConditionalFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantConditionalExpressionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/ConstantConditionalExpressionInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/ConstantConditionalExpressionInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateReplacementExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateReplacementExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class ConstantConditionalFix
    extends PsiUpdateModCommandQuickFix {
        private ConstantConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                ConstantConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ConstantConditionalFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                ConstantConditionalFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ConstantConditionalFix.$$$reportNull$$$0(3);
            }
            PsiConditionalExpression expression = (PsiConditionalExpression)startElement;
            CommentTracker ct = new CommentTracker();
            PsiExpression replacement = ConstantConditionalExpressionInspection.calculateReplacementExpression(expression);
            PsiType type = replacement.getType();
            PsiType expressionType = expression.getType();
            if (type != null && expressionType != null && !type.equals(expressionType) && PsiTypesUtil.isDenotableType((PsiType)expressionType, (PsiElement)expression)) {
                PsiTypeCastExpression castExpression = (PsiTypeCastExpression)ct.replaceAndRestoreComments((PsiElement)expression, "(" + expressionType.getCanonicalText() + ")" + ct.text(replacement, 4));
                if (RedundantCastUtil.isCastRedundant(castExpression)) {
                    RemoveRedundantCastUtil.removeCast(castExpression);
                }
            } else {
                ct.replaceAndRestoreComments((PsiElement)expression, (PsiElement)replacement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/ConstantConditionalExpressionInspection$ConstantConditionalFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/ConstantConditionalExpressionInspection$ConstantConditionalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ConstantConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private ConstantConditionalExpressionVisitor() {
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
            if (expression == null) {
                ConstantConditionalExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitConditionalExpression(expression);
            PsiExpression condition = expression.getCondition();
            PsiExpression thenExpression = expression.getThenExpression();
            if (thenExpression == null) {
                return;
            }
            PsiExpression elseExpression = expression.getElseExpression();
            if (elseExpression == null) {
                return;
            }
            if (BoolUtils.isFalse(condition) || BoolUtils.isTrue(condition)) {
                this.registerError((PsiElement)expression, expression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/controlflow/ConstantConditionalExpressionInspection$ConstantConditionalExpressionVisitor", "visitConditionalExpression"));
        }
    }
}

