/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ThreeState;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.SideEffectChecker;
import org.jetbrains.annotations.NotNull;

public final class ExpressionComparedToItselfInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean ignoreSideEffectConditions = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreSideEffectConditions", (String)InspectionGadgetsBundle.message("duplicate.condition.ignore.method.calls.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(InspectionGadgetsBundle.message("duplicate.condition.ignore.method.calls.option.description", new Object[0]))});
        if (optPane == null) {
            ExpressionComparedToItselfInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ExpressionComparedToItselfInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
                IElementType tokenType;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!ComparisonUtils.isComparisonOperation(tokenType = expression.getOperationTokenType())) {
                    return;
                }
                PsiExpression leftOperand = expression.getLOperand();
                PsiExpression rightOperand = expression.getROperand();
                if (rightOperand == null) {
                    return;
                }
                boolean equivalent = EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(leftOperand, rightOperand);
                if (!equivalent) {
                    return;
                }
                if (PsiUtil.isConstantExpression((PsiExpression)leftOperand)) {
                    return;
                }
                if (Boolean.TRUE.equals(CommonDataflow.computeValue((PsiExpression)expression))) {
                    return;
                }
                ThreeState wantedStatus = ExpressionComparedToItselfInspection.this.ignoreSideEffectConditions ? ThreeState.UNSURE : ThreeState.YES;
                ThreeState actualStatus = SideEffectChecker.getSideEffectStatus(leftOperand);
                if (actualStatus.isAtLeast(wantedStatus)) {
                    return;
                }
                UpdateInspectionOptionFix fix = null;
                if (actualStatus == ThreeState.UNSURE) {
                    fix = new UpdateInspectionOptionFix((InspectionProfileEntry)ExpressionComparedToItselfInspection.this, "ignoreSideEffectConditions", JavaAnalysisBundle.message((String)"intention.name.do.not.report.conditions.with.possible.side.effect", (Object[])new Object[0]), true);
                }
                holder.problem((PsiElement)expression.getOperationSign(), JavaAnalysisBundle.message((String)"inspection.message.expression.compared.to.itself.description", (Object[])new Object[0])).maybeFix(fix).register();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/controlflow/ExpressionComparedToItselfInspection$1", "visitBinaryExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/ExpressionComparedToItselfInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/ExpressionComparedToItselfInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

