/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public final class IfStatementWithTooManyBranchesInspection
extends BaseInspection {
    private static final int DEFAULT_BRANCH_LIMIT = 3;
    public int m_limit = 3;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"m_limit", (String)InspectionGadgetsBundle.message("if.statement.with.too.many.branches.max.option", new Object[0]), (int)1, (int)1000)});
        if (optPane == null) {
            IfStatementWithTooManyBranchesInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer branchCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("if.statement.with.too.many.branches.problem.descriptor", branchCount);
        if (string == null) {
            IfStatementWithTooManyBranchesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new IfStatementWithTooManyBranchesVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/IfStatementWithTooManyBranchesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class IfStatementWithTooManyBranchesVisitor
    extends BaseInspectionVisitor {
        private IfStatementWithTooManyBranchesVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                IfStatementWithTooManyBranchesVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(statement);
            if (ControlFlowUtils.isElseIf(statement)) {
                return;
            }
            int branchCount = IfStatementWithTooManyBranchesVisitor.calculateBranchCount(statement);
            if (branchCount <= IfStatementWithTooManyBranchesInspection.this.m_limit) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, branchCount);
        }

        private static int calculateBranchCount(PsiIfStatement statement) {
            PsiStatement branch = statement.getElseBranch();
            if (branch == null) {
                return 1;
            }
            if (!(branch instanceof PsiIfStatement)) {
                return 2;
            }
            return 1 + IfStatementWithTooManyBranchesVisitor.calculateBranchCount((PsiIfStatement)branch);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/IfStatementWithTooManyBranchesInspection$IfStatementWithTooManyBranchesVisitor", "visitIfStatement"));
        }
    }
}

